/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.filter.Filter;

public class RunLengthDecodeFilter
implements Filter {
    private static final int RUN_LENGTH_EOD = 128;

    @Override
    public void decode(InputStream compressedData, OutputStream result, COSDictionary options) throws IOException {
        int dupAmount = -1;
        byte[] buffer = new byte[128];
        while ((dupAmount = compressedData.read()) != -1 && dupAmount != 128) {
            if (dupAmount <= 127) {
                int compressedRead = 0;
                for (int amountToCopy = dupAmount + 1; amountToCopy > 0; amountToCopy -= compressedRead) {
                    compressedRead = compressedData.read(buffer, 0, amountToCopy);
                    result.write(buffer, 0, compressedRead);
                }
                continue;
            }
            int dupByte = compressedData.read();
            for (int i = 0; i < 257 - dupAmount; ++i) {
                result.write(dupByte);
            }
        }
    }

    @Override
    public void encode(InputStream rawData, OutputStream result, COSDictionary options) throws IOException {
        System.err.println("Warning: RunLengthDecodeFilter.encode is not implemented yet, skipping this stream.");
    }
}

