/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfparser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.io.ByteArrayPushBackInputStream;
import org.pdfbox.io.PushBackInputStream;
import org.pdfbox.io.RandomAccess;
import org.pdfbox.pdfparser.PDFXref;
import org.pdfbox.persistence.util.COSObjectKey;

public abstract class BaseParser {
    public static final byte[] ENDSTREAM = new byte[]{101, 110, 100, 115, 116, 114, 101, 97, 109};
    public static final String DEF = "def";
    protected PushBackInputStream pdfSource;
    private List xrefs = new ArrayList();
    private COSDocument document;

    public BaseParser(InputStream input) throws IOException {
        this.pdfSource = new PushBackInputStream(new BufferedInputStream(input, 16384), 4096);
    }

    protected BaseParser(byte[] input) throws IOException {
        this.pdfSource = new ByteArrayPushBackInputStream(input);
    }

    public void setDocument(COSDocument doc) {
        this.document = doc;
    }

    private static boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }

    private COSBase parseCOSDictionaryValue() throws IOException {
        COSBase retval = null;
        COSBase number = this.parseDirObject();
        this.skipSpaces();
        char next = (char)this.pdfSource.peek();
        if (next >= '0' && next <= '9') {
            COSBase generationNumber = this.parseDirObject();
            this.skipSpaces();
            char r = (char)this.pdfSource.read();
            if (r != 'R') {
                throw new IOException("expected='R' actual='" + r + "' " + this.pdfSource);
            }
            COSObjectKey key = new COSObjectKey(((COSInteger)number).intValue(), ((COSInteger)generationNumber).intValue());
            retval = this.document.getObjectFromPool(key);
        } else {
            retval = number;
        }
        return retval;
    }

    protected COSDictionary parseCOSDictionary() throws IOException {
        char c = (char)this.pdfSource.read();
        if (c != '<') {
            throw new IOException("expected='<' actual='" + c + "'");
        }
        c = (char)this.pdfSource.read();
        if (c != '<') {
            throw new IOException("expected='<' actual='" + c + "' " + this.pdfSource);
        }
        this.skipSpaces();
        COSDictionary obj = new COSDictionary();
        boolean done = false;
        while (!done) {
            this.skipSpaces();
            c = (char)this.pdfSource.peek();
            if (c == '>') {
                done = true;
                continue;
            }
            COSName key = this.parseCOSName();
            COSBase value = this.parseCOSDictionaryValue();
            this.skipSpaces();
            if ((char)this.pdfSource.peek() == 'd') {
                String potentialDEF = this.readString();
                if (!potentialDEF.equals(DEF)) {
                    this.pdfSource.unread(potentialDEF.getBytes());
                } else {
                    this.skipSpaces();
                }
            }
            if (value == null) {
                throw new IOException("Bad Dictionary Declaration " + this.pdfSource);
            }
            obj.setItem(key, value);
        }
        char ch = (char)this.pdfSource.read();
        if (ch != '>') {
            throw new IOException("expected='>' actual='" + ch + "'");
        }
        ch = (char)this.pdfSource.read();
        if (ch != '>') {
            throw new IOException("expected='>' actual='" + ch + "'");
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected COSStream parseCOSStream(COSDictionary dic, RandomAccess file) throws IOException {
        COSStream stream = new COSStream(dic, file);
        try (OutputStream out = null;){
            String streamString = this.readString();
            if (!streamString.equals("stream")) {
                throw new IOException("expected='stream' actual='" + streamString + "'");
            }
            int whitespace = this.pdfSource.read();
            while (whitespace == 32) {
                whitespace = this.pdfSource.read();
            }
            if (whitespace == 13) {
                whitespace = this.pdfSource.read();
                if (whitespace != 10) {
                    this.pdfSource.unread(whitespace);
                }
            } else if (whitespace != 10) {
                this.pdfSource.unread(whitespace);
            }
            COSBase streamLength = dic.getDictionaryObject(COSName.LENGTH);
            out = stream.createFilteredStream(streamLength);
            String endStream = null;
            this.readUntilEndStream(out);
            this.skipSpaces();
            endStream = this.readString();
            if (!endStream.equals("endstream")) {
                this.readUntilEndStream(out);
                endStream = this.readString();
                if (!endStream.equals("endstream")) {
                    throw new IOException("expected='endstream' actual='" + endStream + "' " + this.pdfSource);
                }
            }
        }
        return stream;
    }

    private void readUntilEndStream(OutputStream out) throws IOException {
        int currentIndex = 0;
        int byteRead = 0;
        int additionalBytes = 0;
        byte[] buffer = new byte[ENDSTREAM.length + additionalBytes];
        int writeIndex = 0;
        while (!this.cmpCircularBuffer(buffer, currentIndex, ENDSTREAM) && byteRead != -1) {
            writeIndex = currentIndex - buffer.length;
            if (writeIndex >= 0) {
                out.write(buffer[writeIndex % buffer.length]);
            }
            byteRead = this.pdfSource.read();
            buffer[currentIndex % buffer.length] = (byte)byteRead;
            ++currentIndex;
        }
        this.pdfSource.unread(ENDSTREAM);
    }

    private boolean cmpCircularBuffer(byte[] buffer, int currentIndex, byte[] compareTo) {
        int cmpLen = compareTo.length;
        int buflen = buffer.length;
        boolean match = true;
        int off = currentIndex - cmpLen;
        if (off < 0) {
            match = false;
        }
        for (int i = 0; match && i < cmpLen; ++i) {
            match = buffer[(off + i) % buflen] == compareTo[i];
        }
        return match;
    }

    protected COSString parseCOSString() throws IOException {
        char closeBrace;
        char openBrace;
        char nextChar = (char)this.pdfSource.read();
        COSString retval = new COSString();
        if (nextChar == '(') {
            openBrace = '(';
            closeBrace = ')';
        } else if (nextChar == '<') {
            openBrace = '<';
            closeBrace = '>';
        } else {
            throw new IOException("parseCOSString string should start with '(' or '<' and not '" + nextChar + "' " + this.pdfSource);
        }
        int braces = 1;
        int c = this.pdfSource.read();
        while (braces > 0 && c != -1) {
            char ch = (char)c;
            int nextc = -2;
            if (ch == closeBrace) {
                --braces;
                byte[] nextThreeBytes = new byte[3];
                int amountRead = this.pdfSource.read(nextThreeBytes);
                if (amountRead == 3 && nextThreeBytes[0] == 13 && nextThreeBytes[1] == 10 && nextThreeBytes[2] == 47) {
                    braces = 0;
                }
                this.pdfSource.unread(nextThreeBytes, 0, amountRead);
                if (braces != 0) {
                    retval.append(ch);
                }
            } else if (ch == openBrace) {
                ++braces;
                retval.append(ch);
            } else if (ch == '\\') {
                char next = (char)this.pdfSource.read();
                switch (next) {
                    case 'n': {
                        retval.append(10);
                        break;
                    }
                    case 'r': {
                        retval.append(13);
                        break;
                    }
                    case 't': {
                        retval.append(9);
                        break;
                    }
                    case 'b': {
                        retval.append(8);
                        break;
                    }
                    case 'f': {
                        retval.append(12);
                        break;
                    }
                    case '(': 
                    case ')': 
                    case '\\': {
                        retval.append(next);
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        c = this.pdfSource.read();
                        while (this.isEOL(c) && c != -1) {
                            c = this.pdfSource.read();
                        }
                        nextc = c;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        StringBuffer octal = new StringBuffer();
                        octal.append(next);
                        c = this.pdfSource.read();
                        char digit = (char)c;
                        if (digit >= '0' && digit <= '7') {
                            octal.append(digit);
                            c = this.pdfSource.read();
                            digit = (char)c;
                            if (digit >= '0' && digit <= '7') {
                                octal.append(digit);
                            } else {
                                nextc = c;
                            }
                        } else {
                            nextc = c;
                        }
                        int character = 0;
                        try {
                            character = Integer.parseInt(octal.toString(), 8);
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Error: Expected octal character, actual='" + octal + "'");
                        }
                        retval.append(character);
                        break;
                    }
                    default: {
                        retval.append(92);
                        retval.append(next);
                        break;
                    }
                }
            } else if (openBrace == '<') {
                if (BaseParser.isHexDigit(ch)) {
                    retval.append(ch);
                }
            } else {
                retval.append(ch);
            }
            if (nextc != -2) {
                c = nextc;
                continue;
            }
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        if (openBrace == '<') {
            retval = COSString.createFromHexString(retval.getString());
        }
        return retval;
    }

    protected COSArray parseCOSArray() throws IOException {
        char ch = (char)this.pdfSource.read();
        if (ch != '[') {
            throw new IOException("expected='[' actual='" + ch + "'");
        }
        COSArray po = new COSArray();
        COSBase pbo = null;
        this.skipSpaces();
        int i = 0;
        while ((i = this.pdfSource.peek()) > 0 && (char)i != ']') {
            pbo = this.parseDirObject();
            if (pbo instanceof COSObject) {
                COSInteger genNumber = (COSInteger)po.remove(po.size() - 1);
                COSInteger number = (COSInteger)po.remove(po.size() - 1);
                COSObjectKey key = new COSObjectKey(number.intValue(), genNumber.intValue());
                pbo = this.document.getObjectFromPool(key);
            }
            if (pbo != null) {
                po.add(pbo);
            }
            this.skipSpaces();
        }
        this.pdfSource.read();
        this.skipSpaces();
        return po;
    }

    protected boolean isEndOfName(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t' || ch == '>' || ch == '<' || ch == '[' || ch == '/' || ch == ']' || ch == ')' || ch == '(' || ch == '\uffffffff';
    }

    protected COSName parseCOSName() throws IOException {
        COSName retval = null;
        int c = this.pdfSource.read();
        if ((char)c != '/') {
            throw new IOException("expected='/' actual='" + (char)c + "'-" + c + " " + this.pdfSource);
        }
        StringBuffer buffer = new StringBuffer();
        c = this.pdfSource.read();
        while (c != -1) {
            char ch = (char)c;
            if (ch == '#') {
                char ch1 = (char)this.pdfSource.read();
                char ch2 = (char)this.pdfSource.read();
                if (BaseParser.isHexDigit(ch1) && BaseParser.isHexDigit(ch2)) {
                    String hex = "" + ch1 + ch2;
                    try {
                        buffer.append((char)Integer.parseInt(hex, 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Error: expected hex number, actual='" + hex + "'");
                    }
                    c = this.pdfSource.read();
                    continue;
                }
                this.pdfSource.unread(ch2);
                c = ch1;
                buffer.append(ch);
                continue;
            }
            if (this.isEndOfName(ch)) break;
            buffer.append(ch);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        retval = COSName.getPDFName(buffer.toString());
        return retval;
    }

    protected COSBoolean parseBoolean() throws IOException {
        COSBoolean retval = null;
        char c = (char)this.pdfSource.peek();
        if (c == 't') {
            byte[] trueArray = new byte[4];
            int amountRead = this.pdfSource.read(trueArray, 0, 4);
            String trueString = new String(trueArray, 0, amountRead);
            if (!trueString.equals("true")) {
                throw new IOException("Error parsing boolean: expected='true' actual='" + trueString + "'");
            }
            retval = COSBoolean.TRUE;
        } else if (c == 'f') {
            byte[] falseArray = new byte[5];
            int amountRead = this.pdfSource.read(falseArray, 0, 5);
            String falseString = new String(falseArray, 0, amountRead);
            if (!falseString.equals("false")) {
                throw new IOException("Error parsing boolean: expected='true' actual='" + falseString + "'");
            }
            retval = COSBoolean.FALSE;
        } else {
            throw new IOException("Error parsing boolean expected='t or f' actual='" + c + "'");
        }
        return retval;
    }

    protected COSBase parseDirObject() throws IOException {
        COSBase retval = null;
        this.skipSpaces();
        int nextByte = this.pdfSource.peek();
        char c = (char)nextByte;
        switch (c) {
            case '<': {
                int leftBracket = this.pdfSource.read();
                c = (char)this.pdfSource.peek();
                this.pdfSource.unread(leftBracket);
                if (c == '<') {
                    retval = this.parseCOSDictionary();
                    this.skipSpaces();
                    break;
                }
                retval = this.parseCOSString();
                break;
            }
            case '[': {
                retval = this.parseCOSArray();
                break;
            }
            case '(': {
                retval = this.parseCOSString();
                break;
            }
            case '/': {
                retval = this.parseCOSName();
                break;
            }
            case 'n': {
                String nullString = this.readString();
                if (!nullString.equals("null")) {
                    throw new IOException("Expected='null' actual='" + nullString + "'");
                }
                retval = COSNull.NULL;
                break;
            }
            case 't': {
                byte[] trueBytes = new byte[4];
                int amountRead = this.pdfSource.read(trueBytes, 0, 4);
                String trueString = new String(trueBytes, 0, amountRead);
                if (trueString.equals("true")) {
                    retval = COSBoolean.TRUE;
                    break;
                }
                throw new IOException("expected true actual='" + trueString + "' " + this.pdfSource);
            }
            case 'f': {
                byte[] falseBytes = new byte[5];
                int amountRead = this.pdfSource.read(falseBytes, 0, 5);
                String falseString = new String(falseBytes, 0, amountRead);
                if (falseString.equals("false")) {
                    retval = COSBoolean.FALSE;
                    break;
                }
                throw new IOException("expected false actual='" + falseString + "' " + this.pdfSource);
            }
            case 'R': {
                this.pdfSource.read();
                retval = new COSObject(null);
                break;
            }
            case '\uffff': {
                return null;
            }
            default: {
                if (Character.isDigit(c) || c == '-' || c == '+' || c == '.') {
                    StringBuffer buf = new StringBuffer();
                    int ic = this.pdfSource.read();
                    c = (char)ic;
                    while (Character.isDigit(c) || c == '-' || c == '+' || c == '.' || c == 'E' || c == 'e') {
                        buf.append(c);
                        ic = this.pdfSource.read();
                        c = (char)ic;
                    }
                    if (ic != -1) {
                        this.pdfSource.unread(ic);
                    }
                    retval = COSNumber.get(buf.toString());
                    break;
                }
                String badString = this.readString();
                if (badString != null && badString.length() != 0) break;
                int peek = this.pdfSource.peek();
                throw new IOException("Unknown dir object c='" + c + "' cInt=" + c + " peek='" + (char)peek + "' peekInt=" + peek + " " + this.pdfSource);
            }
        }
        return retval;
    }

    protected String readString() throws IOException {
        this.skipSpaces();
        StringBuffer buffer = new StringBuffer();
        int c = this.pdfSource.read();
        while (!this.isEndOfName((char)c) && !this.isClosing(c) && c != -1) {
            buffer.append((char)c);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    protected String readExpectedString(String theString) throws IOException {
        int c = this.pdfSource.read();
        while (this.isWhitespace(c) && c != -1) {
            c = this.pdfSource.read();
        }
        StringBuffer buffer = new StringBuffer(theString.length());
        for (int charsRead = 0; !this.isEOL(c) && c != -1 && charsRead < theString.length(); ++charsRead) {
            char next = (char)c;
            buffer.append(next);
            if (theString.charAt(charsRead) == next) {
            } else {
                throw new IOException("Error: Expected to read '" + theString + "' instead started reading '" + buffer.toString() + "'");
            }
            c = this.pdfSource.read();
        }
        while (this.isEOL(c) && c != -1) {
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    protected String readString(int length) throws IOException {
        this.skipSpaces();
        int c = this.pdfSource.read();
        StringBuffer buffer = new StringBuffer(length);
        while (!this.isWhitespace(c) && !this.isClosing(c) && c != -1 && buffer.length() < length && c != 91 && c != 60 && c != 40 && c != 47) {
            buffer.append((char)c);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    protected boolean isClosing() throws IOException {
        return this.isClosing(this.pdfSource.peek());
    }

    protected boolean isClosing(int c) {
        return c == 93;
    }

    protected String readLine() throws IOException {
        int c = this.pdfSource.read();
        while (this.isWhitespace(c) && c != -1) {
            c = this.pdfSource.read();
        }
        StringBuffer buffer = new StringBuffer(11);
        while (!this.isEOL(c) && c != -1) {
            buffer.append((char)c);
            c = this.pdfSource.read();
        }
        while (this.isEOL(c) && c != -1) {
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    protected boolean isEOL() throws IOException {
        return this.isEOL(this.pdfSource.peek());
    }

    protected boolean isEOL(int c) {
        return c == 10 || c == 13;
    }

    protected boolean isWhitespace() throws IOException {
        return this.isWhitespace(this.pdfSource.peek());
    }

    protected boolean isWhitespace(int c) {
        return c == 0 || c == 9 || c == 12 || c == 10 || c == 13 || c == 32;
    }

    protected void skipSpaces() throws IOException {
        int c = this.pdfSource.read();
        while (c == 0 || c == 9 || c == 12 || c == 10 || c == 13 || c == 32 || c == 37) {
            if (c == 37) {
                c = this.pdfSource.read();
                while (!this.isEOL(c) && c != -1) {
                    c = this.pdfSource.read();
                }
                continue;
            }
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
    }

    protected int readInt() throws IOException {
        this.skipSpaces();
        int retval = 0;
        int lastByte = 0;
        StringBuffer intBuffer = new StringBuffer();
        while ((lastByte = this.pdfSource.read()) != 32 && lastByte != 10 && lastByte != 13 && lastByte != 0 && lastByte != -1) {
            intBuffer.append((char)lastByte);
        }
        try {
            retval = Integer.parseInt(intBuffer.toString());
        }
        catch (NumberFormatException e) {
            throw new IOException("Error: Expected an integer type, actual='" + intBuffer + "'");
        }
        return retval;
    }

    public void addXref(PDFXref xref) {
        this.xrefs.add(xref);
    }

    public List getXrefs() {
        return this.xrefs;
    }
}

