/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import javax.swing.JPanel;
import org.pdfbox.pdfviewer.PageDrawer;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;

public class PDFPagePanel
extends JPanel {
    private PDPage page;
    private PageDrawer drawer = new PageDrawer();
    private Dimension pageDimension = null;

    public void setPage(PDPage pdfPage) {
        this.page = pdfPage;
        PDRectangle pageSize = this.page.findMediaBox();
        int rotation = this.page.findRotation();
        this.pageDimension = pageSize.createDimension();
        if (rotation == 90 || rotation == 270) {
            this.pageDimension = new Dimension(this.pageDimension.height, this.pageDimension.width);
        }
        this.setSize(this.pageDimension);
        this.setBackground(Color.white);
    }

    @Override
    public void paint(Graphics g) {
        try {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.drawer.drawPage(g, this.page, this.pageDimension);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

