/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDResources;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.pdfbox.util.PDFStreamEngine;
import org.pdfbox.util.ResourceLoader;
import org.pdfbox.util.TextPosition;

public class PageDrawer
extends PDFStreamEngine {
    private Graphics2D graphics;
    private Dimension pageSize;
    private PDPage page;
    private List lineSubPaths = new ArrayList();
    private GeneralPath linePath = new GeneralPath();
    private Color strokingColor = Color.BLACK;
    private Color nonStrokingColor = Color.BLACK;

    public PageDrawer() throws IOException {
        super(ResourceLoader.loadProperties("Resources/PageDrawer.properties"));
    }

    public void drawPage(Graphics g, PDPage p, Dimension pageDimension) throws IOException {
        this.graphics = (Graphics2D)g;
        this.page = p;
        this.pageSize = pageDimension;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PDResources resources = this.page.findResources();
        this.processStream(this.page, resources, this.page.getContents().getStream());
        List annotations = this.page.getAnnotations();
        for (int i = 0; i < annotations.size(); ++i) {
            Map appearanceMap;
            PDAppearanceStream appearance;
            PDAnnotation annot = (PDAnnotation)annotations.get(i);
            PDRectangle rect = annot.getRectangle();
            String appearanceName = annot.getAppearanceStream();
            PDAppearanceDictionary appearDictionary = annot.getAppearance();
            if (appearDictionary == null) continue;
            if (appearanceName == null) {
                appearanceName = "default";
            }
            if ((appearance = (PDAppearanceStream)(appearanceMap = appearDictionary.getNormalAppearance()).get(appearanceName)) == null) continue;
            g.translate((int)rect.getLowerLeftX(), (int)(-rect.getLowerLeftY()));
            this.processSubStream(this.page, appearance.getResources(), appearance.getStream());
            g.translate((int)(-rect.getLowerLeftX()), (int)rect.getLowerLeftY());
        }
    }

    @Override
    protected void showCharacter(TextPosition text) {
        try {
            this.graphics.setColor(Color.black);
            PDFont font = text.getFont();
            font.drawString(text.getCharacter(), this.graphics, text.getFontSize(), text.getXScale(), text.getYScale(), text.getX(), text.getY());
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public PDPage getPage() {
        return this.page;
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    public double fixY(double x, double y) {
        double retval = y;
        int rotation = this.page.findRotation();
        if (rotation == 0) {
            retval = this.pageSize.getHeight() - y;
        } else if (rotation == 90) {
            retval = y;
        }
        return retval;
    }

    public GeneralPath getLinePath() {
        return this.linePath;
    }

    public void setLinePath(GeneralPath newLinePath) {
        this.linePath = newLinePath;
    }

    public List getLineSubPaths() {
        return this.lineSubPaths;
    }

    public void setLineSubPaths(List newLineSubPaths) {
        this.lineSubPaths = newLineSubPaths;
    }

    public Color getNonStrokingColor() {
        return this.nonStrokingColor;
    }

    public void setNonStrokingColor(Color newNonStrokingColor) {
        this.nonStrokingColor = newNonStrokingColor;
    }

    public Color getStrokingColor() {
        return this.strokingColor;
    }

    public void setStrokingColor(Color newStrokingColor) {
        this.strokingColor = newStrokingColor;
    }
}

