/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfviewer;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.pdfbox.PDFReader;
import org.pdfbox.pdfviewer.PDFPagePanel;
import org.pdfbox.pdmodel.PDPage;

public class PageWrapper
implements MouseMotionListener {
    private JPanel pageWrapper = new JPanel();
    private PDFPagePanel pagePanel = null;
    private PDFReader reader = null;
    private static final int SPACE_AROUND_DOCUMENT = 20;

    public PageWrapper(PDFReader aReader) throws IOException {
        this.reader = aReader;
        this.pagePanel = new PDFPagePanel();
        this.pageWrapper.setLayout(null);
        this.pageWrapper.add(this.pagePanel);
        this.pagePanel.setLocation(20, 20);
        this.pageWrapper.setBorder(LineBorder.createBlackLineBorder());
        this.pagePanel.addMouseMotionListener(this);
    }

    public void displayPage(PDPage page) {
        this.pagePanel.setPage(page);
        this.pagePanel.setPreferredSize(this.pagePanel.getSize());
        Dimension d = this.pagePanel.getSize();
        d.width += 40;
        d.height += 40;
        this.pageWrapper.setPreferredSize(d);
        this.pageWrapper.validate();
    }

    public JPanel getPanel() {
        return this.pageWrapper;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.reader.getBottomStatusPanel().getStatusLabel().setText(e.getX() + "," + e.getY());
    }
}

