/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;

public class PDNameTreeNode
implements COSObjectable {
    private COSDictionary node;
    private Class valueType = null;

    public PDNameTreeNode(Class valueClass) {
        this.node = new COSDictionary();
        this.valueType = valueClass;
    }

    public PDNameTreeNode(COSDictionary dict, Class valueClass) {
        this.node = dict;
        this.valueType = valueClass;
    }

    @Override
    public COSBase getCOSObject() {
        return this.node;
    }

    public COSDictionary getCOSDictionary() {
        return this.node;
    }

    public List getKids() {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.node.getDictionaryObject("Kids");
        if (kids != null) {
            ArrayList<PDNameTreeNode> pdObjects = new ArrayList<PDNameTreeNode>();
            for (int i = 0; i < kids.size(); ++i) {
                pdObjects.add(this.createChildNode((COSDictionary)kids.getObject(i)));
            }
            retval = new COSArrayList(pdObjects, kids);
        }
        return retval;
    }

    public void setKids(List kids) {
        this.node.setItem("Kids", (COSBase)COSArrayList.converterToCOSArray(kids));
    }

    public Object getValue(String name) throws IOException {
        Object retval = null;
        Map names = this.getNames();
        if (names != null) {
            retval = names.get(name);
        } else {
            List kids = this.getKids();
            for (int i = 0; i < kids.size() && retval == null; ++i) {
                PDNameTreeNode childNode = (PDNameTreeNode)kids.get(i);
                if (childNode.getLowerLimit().compareTo(name) > 0 || childNode.getUpperLimit().compareTo(name) < 0) continue;
                retval = childNode.getValue(name);
            }
        }
        return retval;
    }

    public Map getNames() throws IOException {
        Map<String, Object> names = null;
        COSArray namesArray = (COSArray)this.node.getDictionaryObject("Names");
        if (namesArray != null) {
            names = new HashMap();
            for (int i = 0; i < namesArray.size(); i += 2) {
                COSString key = (COSString)namesArray.getObject(i);
                COSBase cosValue = namesArray.getObject(i + 1);
                Object pdValue = this.convertCOSToPD(cosValue);
                names.put(key.getString(), pdValue);
            }
            names = Collections.unmodifiableMap(names);
        }
        return names;
    }

    protected Object convertCOSToPD(COSBase base) throws IOException {
        Object retval = null;
        try {
            Constructor ctor = this.valueType.getConstructor(base.getClass());
            retval = ctor.newInstance(base);
        }
        catch (Throwable t) {
            throw new IOException("Error while trying to create value in named tree:" + t.getMessage());
        }
        return retval;
    }

    protected PDNameTreeNode createChildNode(COSDictionary dic) {
        return new PDNameTreeNode(dic, this.valueType);
    }

    public void setNames(Map names) {
        if (names == null) {
            this.node.setItem("Names", (COSObjectable)null);
            this.node.setItem("Limits", (COSObjectable)null);
        } else {
            ArrayList keys = new ArrayList(names.keySet());
            Collections.sort(keys);
            COSArray array = new COSArray();
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                array.add(new COSString(key));
                COSObjectable obj = (COSObjectable)names.get(key);
                array.add(obj);
            }
            String lower = null;
            String upper = null;
            if (keys.size() > 0) {
                lower = (String)keys.get(0);
                upper = (String)keys.get(keys.size() - 1);
            }
            this.setUpperLimit(upper);
            this.setLowerLimit(lower);
            this.node.setItem("Names", (COSBase)array);
        }
    }

    public String getUpperLimit() {
        String retval = null;
        COSArray arr = (COSArray)this.node.getDictionaryObject("Limits");
        if (arr != null) {
            retval = arr.getString(1);
        }
        return retval;
    }

    private void setUpperLimit(String upper) {
        COSArray arr = (COSArray)this.node.getDictionaryObject("Limits");
        if (arr == null) {
            arr = new COSArray();
            arr.add(null);
            arr.add(null);
        }
        arr.setString(1, upper);
    }

    public String getLowerLimit() {
        String retval = null;
        COSArray arr = (COSArray)this.node.getDictionaryObject("Limits");
        if (arr != null) {
            retval = arr.getString(0);
        }
        return retval;
    }

    private void setLowerLimit(String lower) {
        COSArray arr = (COSArray)this.node.getDictionaryObject("Limits");
        if (arr == null) {
            arr = new COSArray();
            arr.add(null);
            arr.add(null);
        }
        arr.setString(0, lower);
    }
}

