/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.documentinterchange.prepress;

import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.graphics.PDLineDashPattern;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceInstance;
import org.pdfbox.pdmodel.graphics.color.PDDeviceRGB;

public class PDBoxStyle
implements COSObjectable {
    public static final String GUIDELINE_STYLE_SOLID = "S";
    public static final String GUIDELINE_STYLE_DASHED = "D";
    private COSDictionary dictionary;

    public PDBoxStyle() {
        this.dictionary = new COSDictionary();
    }

    public PDBoxStyle(COSDictionary dic) {
        this.dictionary = dic;
    }

    @Override
    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public PDColorSpaceInstance getGuidelineColor() {
        COSArray colorValues = (COSArray)this.dictionary.getDictionaryObject("C");
        if (colorValues == null) {
            colorValues = new COSArray();
            colorValues.add(COSInteger.ZERO);
            colorValues.add(COSInteger.ZERO);
            colorValues.add(COSInteger.ZERO);
            this.dictionary.setItem("C", (COSBase)colorValues);
        }
        PDColorSpaceInstance instance = new PDColorSpaceInstance(colorValues);
        instance.setColorSpace(PDDeviceRGB.INSTANCE);
        return instance;
    }

    public void setGuideLineColor(PDColorSpaceInstance color) {
        COSArray values = null;
        if (color != null) {
            values = color.getCOSColorSpaceValue();
        }
        this.dictionary.setItem("C", (COSBase)values);
    }

    public float getGuidelineWidth() {
        return this.dictionary.getFloat("W", 1.0f);
    }

    public void setGuidelineWidth(float width) {
        this.dictionary.setFloat("W", width);
    }

    public String getGuidelineStyle() {
        return this.dictionary.getNameAsString(GUIDELINE_STYLE_SOLID, GUIDELINE_STYLE_SOLID);
    }

    public void setGuidelineStyle(String style) {
        this.dictionary.setName(GUIDELINE_STYLE_SOLID, style);
    }

    public PDLineDashPattern getLineDashPattern() {
        PDLineDashPattern pattern = null;
        COSArray d = (COSArray)this.dictionary.getDictionaryObject(GUIDELINE_STYLE_DASHED);
        if (d == null) {
            d = new COSArray();
            d.add(new COSInteger(3));
            this.dictionary.setItem(GUIDELINE_STYLE_DASHED, (COSBase)d);
        }
        COSArray lineArray = new COSArray();
        lineArray.add(d);
        lineArray.add(new COSInteger(0));
        pattern = new PDLineDashPattern(lineArray);
        return pattern;
    }

    public void setLineDashPattern(PDLineDashPattern pattern) {
        COSArray array = null;
        if (pattern != null) {
            array = pattern.getCOSDashPattern();
        }
        this.dictionary.setItem(GUIDELINE_STYLE_DASHED, (COSBase)array);
    }
}

