/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.fdf;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.common.COSArrayList;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.filespecification.PDFileSpecification;
import org.pdfbox.pdmodel.common.filespecification.PDSimpleFileSpecification;
import org.pdfbox.pdmodel.fdf.FDFAnnotation;
import org.pdfbox.pdmodel.fdf.FDFField;
import org.pdfbox.pdmodel.fdf.FDFJavaScript;
import org.pdfbox.pdmodel.fdf.FDFPage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FDFDictionary
implements COSObjectable {
    private COSDictionary fdf;

    public FDFDictionary() {
        this.fdf = new COSDictionary();
    }

    public FDFDictionary(COSDictionary fdfDictionary) {
        this.fdf = fdfDictionary;
    }

    public FDFDictionary(Element fdfXML) throws IOException {
        this();
        NodeList nodeList = fdfXML.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (child.getTagName().equals("f")) {
                PDSimpleFileSpecification fs = new PDSimpleFileSpecification();
                fs.setFile(child.getAttribute("href"));
                continue;
            }
            if (child.getTagName().equals("ids")) {
                COSArray ids = new COSArray();
                String original = child.getAttribute("original");
                String modified = child.getAttribute("modified");
                ids.add(COSString.createFromHexString(original));
                ids.add(COSString.createFromHexString(modified));
                this.setID(ids);
                continue;
            }
            if (!child.getTagName().equals("fields")) continue;
            NodeList fields = child.getElementsByTagName("field");
            ArrayList<FDFField> fieldList = new ArrayList<FDFField>();
            for (int f = 0; f < fields.getLength(); ++f) {
                fieldList.add(new FDFField((Element)fields.item(f)));
            }
            this.setFields(fieldList);
        }
    }

    public void writeXML(Writer output) throws IOException {
        List fields;
        COSArray ids;
        PDFileSpecification fs = this.getFile();
        if (fs != null) {
            output.write("<f href=\"" + fs.getFile() + "\" />\n");
        }
        if ((ids = this.getID()) != null) {
            COSString original = (COSString)ids.getObject(0);
            COSString modified = (COSString)ids.getObject(1);
            output.write("<ids original=\"" + original.getHexString() + "\" ");
            output.write("modified=\"" + modified.getHexString() + "\" />\n");
        }
        if ((fields = this.getFields()) != null && fields.size() > 0) {
            output.write("<fields>\n");
            for (int i = 0; i < fields.size(); ++i) {
                ((FDFField)fields.get(i)).writeXML(output);
            }
            output.write("</fields>\n");
        }
    }

    @Override
    public COSBase getCOSObject() {
        return this.fdf;
    }

    public COSDictionary getCOSDictionary() {
        return this.fdf;
    }

    public PDFileSpecification getFile() throws IOException {
        return PDFileSpecification.createFS(this.fdf.getDictionaryObject("F"));
    }

    public void setFile(PDFileSpecification fs) {
        this.fdf.setItem("F", (COSObjectable)fs);
    }

    public COSArray getID() {
        return (COSArray)this.fdf.getDictionaryObject("ID");
    }

    public void setID(COSArray id) {
        this.fdf.setItem("ID", (COSBase)id);
    }

    public List getFields() {
        COSArrayList retval = null;
        COSArray fieldArray = (COSArray)this.fdf.getDictionaryObject("Fields");
        if (fieldArray != null) {
            ArrayList<FDFField> fields = new ArrayList<FDFField>();
            for (int i = 0; i < fieldArray.size(); ++i) {
                fields.add(new FDFField((COSDictionary)fieldArray.getObject(i)));
            }
            retval = new COSArrayList(fields, fieldArray);
        }
        return retval;
    }

    public void setFields(List fields) {
        this.fdf.setItem("Fields", (COSBase)COSArrayList.converterToCOSArray(fields));
    }

    public String getStatus() {
        return this.fdf.getString("Status");
    }

    public void setStatus(String status) {
        this.fdf.setString("Status", status);
    }

    public List getPages() {
        COSArrayList retval = null;
        COSArray pageArray = (COSArray)this.fdf.getDictionaryObject("Pages");
        if (pageArray != null) {
            ArrayList<FDFPage> pages = new ArrayList<FDFPage>();
            for (int i = 0; i < pageArray.size(); ++i) {
                pages.add(new FDFPage((COSDictionary)pageArray.get(i)));
            }
            retval = new COSArrayList(pages, pageArray);
        }
        return retval;
    }

    public void setPages(List pages) {
        this.fdf.setItem("Pages", (COSBase)COSArrayList.converterToCOSArray(pages));
    }

    public String getEncoding() {
        String encoding = this.fdf.getNameAsString("Encoding");
        if (encoding == null) {
            encoding = "PDFDocEncoding";
        }
        return encoding;
    }

    public void setEncoding(String encoding) {
        this.fdf.setName("Encoding", encoding);
    }

    public List getAnnotations() {
        COSArrayList retval = null;
        COSArray annotArray = (COSArray)this.fdf.getDictionaryObject("Annots");
        if (annotArray != null) {
            ArrayList<FDFAnnotation> annots = new ArrayList<FDFAnnotation>();
            for (int i = 0; i < annotArray.size(); ++i) {
                annots.add(new FDFAnnotation((COSDictionary)annotArray.getObject(i)));
            }
            retval = new COSArrayList(annots, annotArray);
        }
        return retval;
    }

    public void setAnnotations(List annots) {
        this.fdf.setItem("Annots", (COSBase)COSArrayList.converterToCOSArray(annots));
    }

    public COSStream getDifferences() {
        return (COSStream)this.fdf.getDictionaryObject("Differences");
    }

    public void setDifferences(COSStream diff) {
        this.fdf.setItem("Differences", (COSBase)diff);
    }

    public String getTarget() {
        return this.fdf.getString("Target");
    }

    public void setTarget(String target) {
        this.fdf.setString("Target", target);
    }

    public List getEmbeddedFDFs() throws IOException {
        COSArrayList retval = null;
        COSArray embeddedArray = (COSArray)this.fdf.getDictionaryObject("EmbeddedFDFs");
        if (embeddedArray != null) {
            ArrayList<PDFileSpecification> embedded = new ArrayList<PDFileSpecification>();
            for (int i = 0; i < embeddedArray.size(); ++i) {
                embedded.add(PDFileSpecification.createFS(embeddedArray.get(i)));
            }
            retval = new COSArrayList(embedded, embeddedArray);
        }
        return retval;
    }

    public void setEmbeddedFDFs(List embedded) {
        this.fdf.setItem("EmbeddedFDFs", (COSBase)COSArrayList.converterToCOSArray(embedded));
    }

    public FDFJavaScript getJavaScript() {
        FDFJavaScript fs = null;
        COSDictionary dic = (COSDictionary)this.fdf.getDictionaryObject("JavaScript");
        if (dic != null) {
            fs = new FDFJavaScript(dic);
        }
        return fs;
    }

    public void setJavaScript(FDFJavaScript js) {
        this.fdf.setItem("JavaScript", (COSObjectable)js);
    }
}

