/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.io.IOException;
import org.fontbox.afm.FontMetric;
import org.fontbox.util.BoundingBox;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.font.PDFontDescriptor;

public class PDFontDescriptorAFM
extends PDFontDescriptor {
    private FontMetric afm;

    public PDFontDescriptorAFM(FontMetric afmFile) {
        this.afm = afmFile;
    }

    @Override
    public String getFontName() {
        return this.afm.getFontName();
    }

    @Override
    public void setFontName(String fontName) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public String getFontFamily() {
        return this.afm.getFamilyName();
    }

    @Override
    public void setFontFamily(String fontFamily) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getFontWeight() {
        String weight = this.afm.getWeight();
        float retval = 500.0f;
        if (weight != null && weight.equalsIgnoreCase("bold")) {
            retval = 900.0f;
        } else if (weight != null && weight.equalsIgnoreCase("light")) {
            retval = 100.0f;
        }
        return retval;
    }

    @Override
    public void setFontWeight(float fontWeight) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public String getFontStretch() {
        return null;
    }

    @Override
    public void setFontStretch(String fontStretch) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public int getFlags() {
        return this.afm.isFixedPitch() ? 1 : 0;
    }

    @Override
    public void setFlags(int flags) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public PDRectangle getFontBoundingBox() {
        BoundingBox box = this.afm.getFontBBox();
        PDRectangle retval = null;
        if (box != null) {
            retval = new PDRectangle(box);
        }
        return retval;
    }

    @Override
    public void setFontBoundingBox(PDRectangle rect) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getItalicAngle() {
        return this.afm.getItalicAngle();
    }

    @Override
    public void setItalicAngle(float angle) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getAscent() {
        return this.afm.getAscender();
    }

    @Override
    public void setAscent(float ascent) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getDescent() {
        return this.afm.getDescender();
    }

    @Override
    public void setDescent(float descent) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getLeading() {
        return 0.0f;
    }

    @Override
    public void setLeading(float leading) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getCapHeight() {
        return this.afm.getCapHeight();
    }

    @Override
    public void setCapHeight(float capHeight) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getXHeight() {
        return this.afm.getXHeight();
    }

    @Override
    public void setXHeight(float xHeight) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getStemV() {
        return 0.0f;
    }

    @Override
    public void setStemV(float stemV) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getStemH() {
        return 0.0f;
    }

    @Override
    public void setStemH(float stemH) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getAverageWidth() throws IOException {
        return this.afm.getAverageCharacterWidth();
    }

    @Override
    public void setAverageWidth(float averageWidth) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public float getMaxWidth() {
        return 0.0f;
    }

    @Override
    public void setMaxWidth(float maxWidth) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    public float getMissingWidth() {
        return 0.0f;
    }

    public void setMissingWidth(float missingWidth) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }

    @Override
    public String getCharSet() {
        return this.afm.getCharacterSet();
    }

    @Override
    public void setCharacterSet(String charSet) {
        throw new UnsupportedOperationException("The AFM Font descriptor is immutable");
    }
}

