/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.font.PDSimpleFont;

public class PDType1Font
extends PDSimpleFont {
    public static final PDType1Font TIMES_ROMAN = new PDType1Font("Times-Roman");
    public static final PDType1Font TIMES_BOLD = new PDType1Font("Times-Bold");
    public static final PDType1Font TIMES_ITALIC = new PDType1Font("Times-Italic");
    public static final PDType1Font TIMES_BOLD_ITALIC = new PDType1Font("Times-BoldItalic");
    public static final PDType1Font HELVETICA = new PDType1Font("Helvetica");
    public static final PDType1Font HELVETICA_BOLD = new PDType1Font("Helvetica-Bold");
    public static final PDType1Font HELVETICA_OBLIQUE = new PDType1Font("Helvetica-Oblique");
    public static final PDType1Font HELVETICA_BOLD_OBLIQUE = new PDType1Font("Helvetica-BoldOblique");
    public static final PDType1Font COURIER = new PDType1Font("Courier");
    public static final PDType1Font COURIER_BOLD = new PDType1Font("Courier-Bold");
    public static final PDType1Font COURIER_OBLIQUE = new PDType1Font("Courier-Oblique");
    public static final PDType1Font COURIER_BOLD_OBLIQUE = new PDType1Font("Courier-BoldOblique");
    public static final PDType1Font SYMBOL = new PDType1Font("Symbol");
    public static final PDType1Font ZAPF_DINGBATS = new PDType1Font("ZapfDingbats");
    private static final Map STANDARD_14 = new HashMap();
    private Font awtFont = null;

    public PDType1Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.getPDFName("Type1"));
    }

    public PDType1Font(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public PDType1Font(String baseFont) {
        this();
        this.setBaseFont(baseFont);
    }

    public static PDType1Font getStandardFont(String name) {
        return (PDType1Font)STANDARD_14.get(name);
    }

    public static String[] getStandard14Names() {
        return STANDARD_14.keySet().toArray(new String[14]);
    }

    @Override
    public void drawString(String string, Graphics g, float fontSize, float xScale, float yScale, float x, float y) throws IOException {
        if (this.awtFont == null) {
            String baseFont = this.getBaseFont();
            this.awtFont = baseFont.equals(TIMES_ROMAN.getBaseFont()) ? new Font("Times New Roman", 0, 1) : (baseFont.equals(TIMES_ITALIC.getBaseFont()) ? new Font("Times New Roman", 2, 1) : (baseFont.equals(TIMES_BOLD.getBaseFont()) ? new Font("Times New Roman", 1, 1) : (baseFont.equals(TIMES_BOLD_ITALIC.getBaseFont()) ? new Font("Times New Roman", 3, 1) : (baseFont.equals(HELVETICA.getBaseFont()) ? new Font("Helvetica", 0, 1) : (baseFont.equals(HELVETICA_BOLD.getBaseFont()) ? new Font("Helvetica", 1, 1) : (baseFont.equals(HELVETICA_BOLD_OBLIQUE.getBaseFont()) ? new Font("Helvetica", 3, 1) : (baseFont.equals(HELVETICA_OBLIQUE.getBaseFont()) ? new Font("Helvetica", 2, 1) : (baseFont.equals(COURIER.getBaseFont()) ? new Font("Courier", 0, 1) : (baseFont.equals(COURIER_BOLD.getBaseFont()) ? new Font("Courier", 1, 1) : (baseFont.equals(COURIER_BOLD_OBLIQUE.getBaseFont()) ? new Font("Courier", 3, 1) : (baseFont.equals(COURIER_OBLIQUE.getBaseFont()) ? new Font("Courier", 2, 1) : (baseFont.equals(SYMBOL.getBaseFont()) ? new Font("Symbol", 0, 1) : (baseFont.equals(ZAPF_DINGBATS.getBaseFont()) ? new Font("ZapfDingbats", 0, 1) : new Font("Arial", 0, 1))))))))))))));
        }
        AffineTransform at = new AffineTransform();
        at.scale(xScale, yScale);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(this.awtFont.deriveFont(at).deriveFont(fontSize));
        g2d.drawString(string, (int)x, (int)y);
    }

    static {
        STANDARD_14.put(TIMES_ROMAN.getBaseFont(), TIMES_ROMAN);
        STANDARD_14.put(TIMES_BOLD.getBaseFont(), TIMES_BOLD);
        STANDARD_14.put(TIMES_ITALIC.getBaseFont(), TIMES_ITALIC);
        STANDARD_14.put(TIMES_BOLD_ITALIC.getBaseFont(), TIMES_BOLD_ITALIC);
        STANDARD_14.put(HELVETICA.getBaseFont(), HELVETICA);
        STANDARD_14.put(HELVETICA_BOLD.getBaseFont(), HELVETICA_BOLD);
        STANDARD_14.put(HELVETICA_OBLIQUE.getBaseFont(), HELVETICA_OBLIQUE);
        STANDARD_14.put(HELVETICA_BOLD_OBLIQUE.getBaseFont(), HELVETICA_BOLD_OBLIQUE);
        STANDARD_14.put(COURIER.getBaseFont(), COURIER);
        STANDARD_14.put(COURIER_BOLD.getBaseFont(), COURIER_BOLD);
        STANDARD_14.put(COURIER_OBLIQUE.getBaseFont(), COURIER_OBLIQUE);
        STANDARD_14.put(COURIER_BOLD_OBLIQUE.getBaseFont(), COURIER_BOLD_OBLIQUE);
        STANDARD_14.put(SYMBOL.getBaseFont(), SYMBOL);
        STANDARD_14.put(ZAPF_DINGBATS.getBaseFont(), ZAPF_DINGBATS);
    }
}

