/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.PDMatrix;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDGamma;
import org.pdfbox.pdmodel.graphics.color.PDTristimulus;

public class PDCalRGB
extends PDColorSpace {
    public static final String NAME = "CalRGB";
    private COSArray array;
    private COSDictionary dictionary;

    public PDCalRGB() {
        this.array = new COSArray();
        this.dictionary = new COSDictionary();
        this.array.add(COSName.getPDFName(NAME));
        this.array.add(this.dictionary);
    }

    public PDCalRGB(COSArray rgb) {
        this.array = rgb;
        this.dictionary = (COSDictionary)this.array.getObject(1);
    }

    @Override
    public int getNumberOfComponents() throws IOException {
        return 3;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ColorSpace createColorSpace() throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public ColorModel createColorModel(int bpc) throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public COSBase getCOSObject() {
        return this.array;
    }

    public PDTristimulus getWhitepoint() {
        COSArray wp = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("WhitePoint"));
        if (wp == null) {
            wp = new COSArray();
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            this.dictionary.setItem(COSName.getPDFName("WhitePoint"), (COSBase)wp);
        }
        return new PDTristimulus(wp);
    }

    public void setWhitepoint(PDTristimulus wp) {
        COSBase wpArray = wp.getCOSObject();
        if (wpArray != null) {
            this.dictionary.setItem(COSName.getPDFName("WhitePoint"), wpArray);
        }
    }

    public PDTristimulus getBlackPoint() {
        COSArray bp = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("BlackPoint"));
        if (bp == null) {
            bp = new COSArray();
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            this.dictionary.setItem(COSName.getPDFName("BlackPoint"), (COSBase)bp);
        }
        return new PDTristimulus(bp);
    }

    public void setBlackPoint(PDTristimulus bp) {
        COSBase bpArray = null;
        if (bp != null) {
            bpArray = bp.getCOSObject();
        }
        this.dictionary.setItem(COSName.getPDFName("BlackPoint"), bpArray);
    }

    public PDGamma getGamma() {
        COSArray gamma = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("Gamma"));
        if (gamma == null) {
            gamma = new COSArray();
            gamma.add(new COSFloat(1.0f));
            gamma.add(new COSFloat(1.0f));
            gamma.add(new COSFloat(1.0f));
            this.dictionary.setItem(COSName.getPDFName("Gamma"), (COSBase)gamma);
        }
        return new PDGamma(gamma);
    }

    public void setGamma(PDGamma value) {
        COSArray gamma = null;
        if (value != null) {
            gamma = value.getCOSArray();
        }
        this.dictionary.setItem(COSName.getPDFName("Gamma"), (COSBase)gamma);
    }

    public PDMatrix getLinearInterpretation() {
        PDMatrix retval = null;
        COSArray matrix = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("Matrix"));
        if (matrix == null) {
            retval = new PDMatrix();
            this.setLinearInterpretation(retval);
        } else {
            retval = new PDMatrix(matrix);
        }
        return retval;
    }

    public void setLinearInterpretation(PDMatrix matrix) {
        COSArray matrixArray = null;
        if (matrix != null) {
            matrixArray = matrix.getCOSArray();
        }
        this.dictionary.setItem(COSName.getPDFName("Matrix"), (COSBase)matrixArray);
    }
}

