/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.util.ResourceLoader;

public class PDDeviceCMYK
extends PDColorSpace {
    public static final PDDeviceCMYK INSTANCE = new PDDeviceCMYK();
    public static final String NAME = "DeviceCMYK";
    public static final String ABBREVIATED_NAME = "CMYK";
    private ColorSpace cSpace = null;

    private PDDeviceCMYK() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumberOfComponents() throws IOException {
        return 4;
    }

    @Override
    public ColorSpace createColorSpace() throws IOException {
        if (this.cSpace == null) {
            try (InputStream profile = null;){
                profile = ResourceLoader.loadResource("Resources/colorspace-profiles/CMYK.pf");
                ICC_Profile iccProfile = ICC_Profile.getInstance(profile);
                this.cSpace = new ICC_ColorSpace(iccProfile);
            }
        }
        return this.cSpace;
    }

    @Override
    public ColorModel createColorModel(int bpc) throws IOException {
        throw new IOException("Not implemented");
    }
}

