/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class PDIndexed
extends PDColorSpace {
    public static final String NAME = "Indexed";
    public static final String ABBREVIATED_NAME = "I";
    private COSArray array;

    public PDIndexed() {
        this.array = new COSArray();
        this.array.add(COSName.getPDFName(NAME));
        this.array.add(COSName.getPDFName("DeviceRGB"));
        this.array.add(new COSInteger(255));
        this.array.add(COSNull.NULL);
    }

    public PDIndexed(COSArray indexedArray) {
        this.array = indexedArray;
    }

    @Override
    public int getNumberOfComponents() throws IOException {
        return this.getBaseColorSpace().getNumberOfComponents();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ColorSpace createColorSpace() throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public ColorModel createColorModel(int bpc) throws IOException {
        int size = this.getHighValue();
        byte[] index = this.getLookupData();
        IndexColorModel cm = new IndexColorModel(bpc, size + 1, index, 0, false);
        return cm;
    }

    public PDColorSpace getBaseColorSpace() throws IOException {
        PDColorSpace retval = null;
        COSBase base = this.array.getObject(1);
        if (!(base instanceof COSName)) {
            throw new IOException("Error:unknown base colorspace");
        }
        retval = PDColorSpaceFactory.createColorSpace(base);
        return retval;
    }

    public void setBaseColorSpace(PDColorSpace base) {
        this.array.set(1, base.getCOSObject());
    }

    public int getHighValue() {
        return ((COSNumber)this.array.getObject(2)).intValue();
    }

    public void setHighValue(int high) {
        this.array.set(2, new COSInteger(high));
    }

    public int lookupColor(int componentNumber, int lookupIndex) throws IOException {
        PDColorSpace baseColor = this.getBaseColorSpace();
        byte[] data = this.getLookupData();
        int numberOfComponents = baseColor.getNumberOfComponents();
        return (data[componentNumber * numberOfComponents + lookupIndex] + 256) % 256;
    }

    private byte[] getLookupData() throws IOException {
        COSBase lookupTable = this.array.getObject(3);
        byte[] data = null;
        if (lookupTable instanceof COSString) {
            data = ((COSString)lookupTable).getBytes();
        } else if (lookupTable instanceof COSStream) {
            int amountRead;
            COSStream lookupStream = (COSStream)lookupTable;
            InputStream input = lookupStream.getUnfilteredStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((amountRead = input.read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, amountRead);
            }
            data = output.toByteArray();
        } else if (lookupTable == null) {
            data = new byte[]{};
        } else {
            throw new IOException("Error: Unknown type for lookup table " + lookupTable);
        }
        return data;
    }

    public void setLookupColor(int componentNumber, int lookupIndex, int color) throws IOException {
        PDColorSpace baseColor = this.getBaseColorSpace();
        int numberOfComponents = baseColor.getNumberOfComponents();
        byte[] data = this.getLookupData();
        data[componentNumber * numberOfComponents + lookupIndex] = (byte)color;
        COSString string = new COSString(data);
        this.array.set(3, string);
    }
}

