/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.function.PDFunction;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class PDSeparation
extends PDColorSpace {
    public static final String NAME = "Separation";
    private COSArray array;

    public PDSeparation() {
        this.array = new COSArray();
        this.array.add(COSName.getPDFName(NAME));
        this.array.add(COSName.getPDFName(""));
    }

    public PDSeparation(COSArray separation) {
        this.array = separation;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumberOfComponents() throws IOException {
        return 1;
    }

    @Override
    public ColorSpace createColorSpace() throws IOException {
        throw new IOException("Not implemented");
    }

    @Override
    public ColorModel createColorModel(int bpc) throws IOException {
        throw new IOException("Not implemented");
    }

    public String getColorantName() {
        COSName name = (COSName)this.array.getObject(1);
        return name.getName();
    }

    public void setColorantName(String name) {
        this.array.set(1, COSName.getPDFName(name));
    }

    public PDColorSpace getAlternateColorSpace() throws IOException {
        COSBase alternate = this.array.getObject(2);
        return PDColorSpaceFactory.createColorSpace(alternate);
    }

    public void setAlternateColorSpace(PDColorSpace cs) {
        COSBase space = null;
        if (cs != null) {
            space = cs.getCOSObject();
        }
        this.array.set(2, space);
    }

    public PDFunction getTintTransform() throws IOException {
        return PDFunction.create(this.array.get(3));
    }

    public void setTintTransform(PDFunction tint) {
        this.array.set(3, tint);
    }
}

