/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.predictor.PredictorAlgorithm;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class PDPixelMap
extends PDXObjectImage {
    private BufferedImage image = null;

    public PDPixelMap(PDStream pdStream) {
        super(pdStream, "png");
    }

    @Override
    public BufferedImage getRGBImage() throws IOException {
        if (this.image != null) {
            return this.image;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int bpc = this.getBitsPerComponent();
        byte[] array = this.getPDStream().getByteArray();
        PDColorSpace colorspace = this.getColorSpace();
        ColorModel cm = colorspace.createColorModel(bpc);
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        byte[] bufferData = buffer.getData();
        int predictor = this.getPredictor();
        PredictorAlgorithm filter = PredictorAlgorithm.getFilter(predictor);
        filter.setWidth(width);
        filter.setHeight(height);
        filter.setBpp(bpc * 3 / 8);
        filter.decode(array, bufferData);
        this.image = new BufferedImage(cm, raster, false, null);
        return this.image;
    }

    @Override
    public void write2OutputStream(OutputStream out) throws IOException {
        this.getRGBImage();
        if (this.image != null) {
            ImageIO.write((RenderedImage)this.image, "png", out);
        }
    }

    public COSDictionary getDecodeParams() {
        COSBase decodeParms = this.getCOSStream().getDictionaryObject("DecodeParms");
        if (decodeParms != null) {
            if (decodeParms instanceof COSDictionary) {
                return (COSDictionary)decodeParms;
            }
            if (decodeParms instanceof COSArray) {
                return null;
            }
            return null;
        }
        return null;
    }

    public int getPredictor() {
        int i;
        COSDictionary decodeParms = this.getDecodeParams();
        if (decodeParms != null && (i = decodeParms.getInt("Predictor")) != -1) {
            return i;
        }
        return 1;
    }
}

