/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.xobject;

import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.pdfbox.pdmodel.graphics.xobject.PDXObject;

public abstract class PDXObjectImage
extends PDXObject {
    public static final String SUB_TYPE = "Image";
    private String suffix;

    public PDXObjectImage(PDStream imageStream, String fileSuffix) {
        super(imageStream);
        this.suffix = fileSuffix;
    }

    public PDXObjectImage(PDDocument doc, String fileSuffix) {
        super(doc);
        this.getCOSStream().setName(COSName.SUBTYPE, SUB_TYPE);
        this.suffix = fileSuffix;
    }

    public abstract BufferedImage getRGBImage() throws IOException;

    public abstract void write2OutputStream(OutputStream var1) throws IOException;

    public void write2file(String filename) throws IOException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(filename + "." + this.suffix);
            this.write2OutputStream(out);
            out.flush();
        }
    }

    public int getHeight() {
        return this.getCOSStream().getInt("Height", -1);
    }

    public void setHeight(int height) {
        this.getCOSStream().setInt("Height", height);
    }

    public int getWidth() {
        return this.getCOSStream().getInt("Width", -1);
    }

    public void setWidth(int width) {
        this.getCOSStream().setInt("Width", width);
    }

    public int getBitsPerComponent() {
        return this.getCOSStream().getInt(new String[]{"BPC", "BitsPerComponent"}, -1);
    }

    public void setBitsPerComponent(int bpc) {
        this.getCOSStream().setInt("BitsPerComponent", bpc);
    }

    public PDColorSpace getColorSpace() throws IOException {
        COSBase cs = this.getCOSStream().getDictionaryObject(new String[]{"CS", "ColorSpace"});
        PDColorSpace retval = null;
        if (cs != null) {
            retval = PDColorSpaceFactory.createColorSpace(cs);
        } else {
            COSBase filter = this.getCOSStream().getDictionaryObject("Filter");
            if (COSName.CCITTFAX_DECODE.equals(filter) || COSName.CCITTFAX_DECODE_ABBREVIATION.equals(filter)) {
                retval = new PDDeviceGray();
            }
        }
        return retval;
    }

    public void setColorSpace(PDColorSpace cs) {
        COSBase base = null;
        if (cs != null) {
            base = cs.getCOSObject();
        }
        this.getCOSStream().setItem(COSName.getPDFName("ColorSpace"), base);
    }

    public String getSuffix() {
        return this.suffix;
    }
}

