/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDVariableText;

public class PDChoiceField
extends PDVariableText {
    public PDChoiceField(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
    }

    @Override
    public void setValue(String optionValue) throws IOException {
        int indexSelected = -1;
        COSArray options = (COSArray)this.getDictionary().getDictionaryObject("Opt");
        if (options.size() == 0) {
            throw new IOException("Error: You cannot set a value for a choice field if there are no options.");
        }
        COSBase option = options.getObject(0);
        if (option instanceof COSArray) {
            for (int i = 0; i < options.size() && indexSelected == -1; ++i) {
                COSArray keyValuePair = (COSArray)options.get(i);
                COSString key = (COSString)keyValuePair.getObject(0);
                COSString value = (COSString)keyValuePair.getObject(1);
                if (!optionValue.equals(key.getString()) && !optionValue.equals(value.getString())) continue;
                super.setValue(value.getString());
                this.getDictionary().setItem(COSName.getPDFName("V"), (COSBase)key);
                indexSelected = i;
            }
        } else {
            for (int i = 0; i < options.size() && indexSelected == -1; ++i) {
                COSString value = (COSString)options.get(i);
                if (!optionValue.equals(value.getString())) continue;
                super.setValue(optionValue);
                indexSelected = i;
            }
        }
        if (indexSelected == -1) {
            throw new IOException("Error: '" + optionValue + "' was not an available option.");
        }
        COSArray indexArray = (COSArray)this.getDictionary().getDictionaryObject("I");
        if (indexArray != null) {
            indexArray.clear();
            indexArray.add(new COSInteger(indexSelected));
        }
    }
}

