/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.viewerpreferences;

import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.pdmodel.common.COSObjectable;

public class PDViewerPreferences
implements COSObjectable {
    public static final String NON_FULL_SCREEN_PAGE_MODE_USE_NONE = "UseNone";
    public static final String NON_FULL_SCREEN_PAGE_MODE_USE_OUTLINES = "UseOutlines";
    public static final String NON_FULL_SCREEN_PAGE_MODE_USE_THUMBS = "UseThumbs";
    public static final String NON_FULL_SCREEN_PAGE_MODE_USE_OPTIONAL_CONTENT = "UseOC";
    public static final String READING_DIRECTION_L2R = "L2R";
    public static final String READING_DIRECTION_R2L = "R2L";
    public static final String BOUNDARY_MEDIA_BOX = "MediaBox";
    public static final String BOUNDARY_CROP_BOX = "CropBox";
    public static final String BOUNDARY_BLEED_BOX = "BleedBox";
    public static final String BOUNDARY_TRIM_BOX = "TrimBox";
    public static final String BOUNDARY_ART_BOX = "ArtBox";
    private COSDictionary prefs;

    public PDViewerPreferences(COSDictionary dic) {
        this.prefs = dic;
    }

    public COSDictionary getDictionary() {
        return this.prefs;
    }

    @Override
    public COSBase getCOSObject() {
        return this.prefs;
    }

    public boolean hideToolbar() {
        return this.prefs.getBoolean("HideToolbar", false);
    }

    public void setHideToolbar(boolean value) {
        this.prefs.setBoolean("HideToolbar", value);
    }

    public boolean hideMenubar() {
        return this.prefs.getBoolean("HideMenubar", false);
    }

    public void setHideMenubar(boolean value) {
        this.prefs.setBoolean("HideMenubar", value);
    }

    public boolean hideWindowUI() {
        return this.prefs.getBoolean("HideWindowUI", false);
    }

    public void setHideWindowUI(boolean value) {
        this.prefs.setBoolean("HideWindowUI", value);
    }

    public boolean fitWindow() {
        return this.prefs.getBoolean("FitWindow", false);
    }

    public void setFitWindow(boolean value) {
        this.prefs.setBoolean("FitWindow", value);
    }

    public boolean centerWindow() {
        return this.prefs.getBoolean("CenterWindow", false);
    }

    public void setCenterWindow(boolean value) {
        this.prefs.setBoolean("CenterWindow", value);
    }

    public boolean displayDocTitle() {
        return this.prefs.getBoolean("DisplayDocTitle", false);
    }

    public void setDisplayDocTitle(boolean value) {
        this.prefs.setBoolean("DisplayDocTitle", value);
    }

    public String getNonFullScreenPageMode() {
        return this.prefs.getNameAsString("NonFullScreenPageMode", NON_FULL_SCREEN_PAGE_MODE_USE_NONE);
    }

    public void setNonFullScreenPageMode(String value) {
        this.prefs.setName("NonFullScreenPageMode", value);
    }

    public String getReadingDirection() {
        return this.prefs.getNameAsString("Direction", READING_DIRECTION_L2R);
    }

    public void setReadingDirection(String value) {
        this.prefs.setName("Direction", value);
    }

    public String getViewArea() {
        return this.prefs.getNameAsString("ViewArea", BOUNDARY_CROP_BOX);
    }

    public void setViewArea(String value) {
        this.prefs.setName("ViewArea", value);
    }

    public String getViewClip() {
        return this.prefs.getNameAsString("ViewClip", BOUNDARY_CROP_BOX);
    }

    public void setViewClip(String value) {
        this.prefs.setName("ViewClip", value);
    }

    public String getPrintArea() {
        return this.prefs.getNameAsString("PrintArea", BOUNDARY_CROP_BOX);
    }

    public void setPrintArea(String value) {
        this.prefs.setName("PrintArea", value);
    }

    public String getPrintClip() {
        return this.prefs.getNameAsString("PrintClip", BOUNDARY_CROP_BOX);
    }

    public void setPrintClip(String value) {
        this.prefs.setName("PrintClip", value);
    }
}

