/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceInstance;
import org.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.operator.OperatorProcessor;

public class SetNonStrokingColorSpace
extends OperatorProcessor {
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];

    @Override
    public void process(PDFOperator operator, List arguments) throws IOException {
        COSName name = (COSName)arguments.get(0);
        PDColorSpace cs = null;
        Map colorSpaces = this.context.getColorSpaces();
        if (colorSpaces != null) {
            cs = (PDColorSpace)colorSpaces.get(name.getName());
        }
        if (cs == null) {
            cs = PDColorSpaceFactory.createColorSpace(name);
        }
        PDColorSpaceInstance colorInstance = this.context.getGraphicsState().getNonStrokingColorSpace();
        colorInstance.setColorSpace(cs);
        int numComponents = cs.getNumberOfComponents();
        float[] values = EMPTY_FLOAT_ARRAY;
        if (numComponents >= 0) {
            values = new float[numComponents];
            for (int i = 0; i < numComponents; ++i) {
                values[i] = 0.0f;
            }
            if (cs instanceof PDDeviceCMYK) {
                values[3] = 1.0f;
            }
        }
        colorInstance.setColorSpaceValue(values);
    }
}

