/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;
import org.pdfbox.util.Matrix;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.operator.OperatorProcessor;

public class ShowTextGlyph
extends OperatorProcessor {
    @Override
    public void process(PDFOperator operator, List arguments) throws IOException {
        COSArray array = (COSArray)arguments.get(0);
        float adjustment = 0.0f;
        for (int i = 0; i < array.size(); ++i) {
            COSBase next = array.get(i);
            if (next instanceof COSNumber) {
                adjustment = ((COSNumber)next).floatValue();
                Matrix adjMatrix = new Matrix();
                adjustment = -adjustment / 1000.0f * this.context.getGraphicsState().getTextState().getFontSize() * (this.context.getGraphicsState().getTextState().getHorizontalScalingPercent() / 100.0f);
                adjMatrix.setValue(2, 0, adjustment);
                this.context.setTextMatrix(adjMatrix.multiply(this.context.getTextMatrix()));
                continue;
            }
            if (next instanceof COSString) {
                this.context.showString(((COSString)next).getBytes());
                continue;
            }
            throw new IOException("Unknown type in array for TJ operation:" + next);
        }
    }
}

