/*
 * Decompiled with CFR 0.152.
 */
package org.loesak.esque.core.concurrent;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.loesak.esque.core.elasticsearch.RestClientOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchDocumentLock
implements Lock {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchDocumentLock.class);
    private static final Duration DEFAULT_IDLE_BETWEEN_TRIES = Duration.ofMillis(100L);
    private final ReentrantLock delegate = new ReentrantLock();
    private final RestClientOperations operations;
    private final Duration idleBetweenTries;

    @ConstructorProperties(value={"operations"})
    public ElasticsearchDocumentLock(RestClientOperations operations) {
        this(operations, DEFAULT_IDLE_BETWEEN_TRIES);
    }

    @ConstructorProperties(value={"operations", "idleBetweenTries"})
    public ElasticsearchDocumentLock(RestClientOperations operations, Duration idleBetweenTries) {
        this.operations = operations;
        this.idleBetweenTries = idleBetweenTries;
    }

    @Override
    public void lock() {
        this.delegate.lock();
        while (true) {
            try {
                while (!this.doLock()) {
                    Thread.sleep(this.idleBetweenTries.toMillis());
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (Exception e) {
                this.delegate.unlock();
                this.rethrowAsLockException(e);
                continue;
            }
            break;
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.delegate.lockInterruptibly();
        while (true) {
            try {
                while (!this.doLock()) {
                    Thread.sleep(this.idleBetweenTries.toMillis());
                    if (!Thread.currentThread().isInterrupted()) continue;
                    throw new InterruptedException();
                }
            }
            catch (InterruptedException ie) {
                this.delegate.unlock();
                Thread.currentThread().interrupt();
                throw ie;
            }
            catch (Exception e) {
                this.delegate.unlock();
                this.rethrowAsLockException(e);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(0L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit timeUnit) throws InterruptedException {
        long now = System.currentTimeMillis();
        if (!this.delegate.tryLock(time, timeUnit)) {
            return false;
        }
        long expire = now + TimeUnit.MILLISECONDS.convert(time, timeUnit);
        while (true) {
            try {
                boolean acquired;
                while (!(acquired = this.doLock()) && System.currentTimeMillis() < expire) {
                    Thread.sleep(this.idleBetweenTries.toMillis());
                }
                if (!acquired) {
                    this.delegate.unlock();
                }
                return acquired;
            }
            catch (Exception e) {
                this.delegate.unlock();
                this.rethrowAsLockException(e);
                continue;
            }
            break;
        }
    }

    @Override
    public void unlock() {
        if (!this.delegate.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("You do not own mutex");
        }
        if (this.delegate.getHoldCount() > 1) {
            this.delegate.unlock();
            return;
        }
        try {
            this.operations.deleteLockRecord();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to release mutex");
        }
        finally {
            this.delegate.unlock();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Conditions are not supported");
    }

    private boolean doLock() {
        try {
            this.operations.createLockRecord();
            return true;
        }
        catch (Exception e) {
            log.debug("Failed to acquire lock", (Throwable)e);
            return false;
        }
    }

    private void rethrowAsLockException(Exception e) {
        throw new RuntimeException("Failed to lock mutex", e);
    }
}

