/*
 * Decompiled with CFR 0.152.
 */
package org.loesak.esque.core.elasticsearch;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.loesak.esque.core.elasticsearch.documents.MigrationLock;
import org.loesak.esque.core.elasticsearch.documents.MigrationRecord;
import org.loesak.esque.core.yaml.model.MigrationFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientOperations
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RestClientOperations.class);
    private static final String MIGRATION_DOCUMENT_INDEX = "/.esque";
    private static final String MIGRATION_DOCUMENT_INDEX_DEFINITION_FILE_PATH = "org/loesak/esque/core/elasticsearch/esque-index-defintion.json";
    private static final String MIGRATION_LOCK_DOCUMENT_ID_PREFIX = "lock";
    private static final String MIGRATION_RECORD_SEARCH_QUERY_TEMPLATE_FIND_ALL_BY_MIGRATION_KEY = "{\"query\":{\"bool\":{\"filter\":[{\"term\":{\"migration.migrationKey\":\"%s\"}}]}}}";
    private static final String MIGRATION_RECORD_SEARCH_QUERY_TEMPLATE_FIND_ONE_BY_MIGRATION_KEY_AND_MIGRATION_FILENAME = "{\"query\":{\"bool\":{\"filter\":[{\"term\":{\"migration.migrationKey\":\"%s\"}},{\"term\":{\"migration.filename\":\"%s\"}}]}}}";
    private static final String HTTP_METHOD_HEAD = "HEAD";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_METHOD_PUT = "PUT";
    private static final String HTTP_METHOD_POST = "POST";
    private static final String HTTP_METHOD_DELETE = "DELETE";
    private final RestClient client;
    private final String migrationKey;
    private final ObjectMapper mapper;

    @ConstructorProperties(value={"client", "migrationKey"})
    public RestClientOperations(RestClient client, String migrationKey) {
        this.client = client;
        this.migrationKey = migrationKey;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.mapper.registerModule((Module)new Jdk8Module());
        this.mapper.registerModule((Module)new ParameterNamesModule());
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public Boolean checkMigrationIndexExists() {
        try {
            log.info("Checking if migration index with name [{}] exists", (Object)MIGRATION_DOCUMENT_INDEX);
            Boolean status = this.sendRequest(new Request(HTTP_METHOD_HEAD, MIGRATION_DOCUMENT_INDEX)).getStatusLine().getStatusCode() == 200;
            log.info("Determined migration index with name [{}] {}", (Object)MIGRATION_DOCUMENT_INDEX, (Object)(status != false ? "exists" : "does not exist"));
            return status;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to check if migration index with name [%s] exists", MIGRATION_DOCUMENT_INDEX), e);
        }
    }

    public void createMigrationIndex() {
        try {
            log.info("Creating migration index with name [{}]", (Object)MIGRATION_DOCUMENT_INDEX);
            Request request = new Request(HTTP_METHOD_PUT, MIGRATION_DOCUMENT_INDEX);
            request.setEntity((HttpEntity)new InputStreamEntity(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(MIGRATION_DOCUMENT_INDEX_DEFINITION_FILE_PATH)), ContentType.APPLICATION_JSON));
            try {
                this.sendRequest(request);
            }
            catch (ResponseException e) {
                Map content = (Map)this.mapper.readValue(e.getResponse().getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                Boolean alreadyExists = content.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("error")).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals("type")).map(entry -> entry.getValue().equals("resource_already_exists_exception")).findFirst().orElse(false);
                if (alreadyExists.booleanValue()) {
                    log.info("Creation of migration index with name [{}] failed because it already exists. Likely another process got ahead of this process. Ignoring exception.", (Object)MIGRATION_DOCUMENT_INDEX);
                }
                throw e;
            }
            log.info("Migration index with name [{}] created", (Object)MIGRATION_DOCUMENT_INDEX);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to create migration index with name [%s]", MIGRATION_DOCUMENT_INDEX), e);
        }
    }

    public void createLockRecord() {
        try {
            log.info("Creating lock document for migration key [{}]", (Object)this.migrationKey);
            Request request = new Request(HTTP_METHOD_PUT, String.format("%s/_doc/%s:%s", MIGRATION_DOCUMENT_INDEX, MIGRATION_LOCK_DOCUMENT_ID_PREFIX, this.migrationKey));
            request.addParameter("op_type", "create");
            request.setJsonEntity(this.mapper.writeValueAsString((Object)new MigrationLock(Instant.now())));
            this.sendRequest(request);
            log.info("Lock document for migration key [{}] created", (Object)this.migrationKey);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to create lock document for migration key [%s]", this.migrationKey), e);
        }
    }

    public void deleteLockRecord() {
        try {
            log.info("Deleting lock document for key [{}]", (Object)this.migrationKey);
            this.sendRequest(new Request(HTTP_METHOD_DELETE, String.format("%s/_doc/%s:%s", MIGRATION_DOCUMENT_INDEX, MIGRATION_LOCK_DOCUMENT_ID_PREFIX, this.migrationKey)));
            log.info("Lock document for key [{}] deleted", (Object)this.migrationKey);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to delete lock document for key [%s]", this.migrationKey), e);
        }
    }

    public List<MigrationRecord> getMigrationRecords() {
        try {
            log.info("Getting migration records for migration key [{}]", (Object)this.migrationKey);
            Request request = new Request(HTTP_METHOD_GET, String.format("%s/_search", MIGRATION_DOCUMENT_INDEX));
            request.setJsonEntity(String.format(MIGRATION_RECORD_SEARCH_QUERY_TEMPLATE_FIND_ALL_BY_MIGRATION_KEY, this.migrationKey));
            Response response = this.sendRequest(request);
            Map content = (Map)this.mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            List<MigrationRecord> records = content.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("hits")).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals("hits")).flatMap(entry -> ((List)entry.getValue()).stream()).flatMap(item -> item.entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals("_source")).map(entry -> (MigrationRecord)this.mapper.convertValue(entry.getValue(), (TypeReference)new TypeReference<MigrationRecord>(){})).sorted(Comparator.comparing(MigrationRecord::getOrder)).collect(Collectors.toUnmodifiableList());
            log.info("Found [{}] migration records", (Object)records.size());
            return records;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to get migration records for migration key [%s]", this.migrationKey), e);
        }
    }

    public MigrationRecord getMigrationRecordForMigrationFile(MigrationFile file, String migrationKey) {
        try {
            log.info("Getting migration record for migration file named [{}] and migration key [{}]", (Object)file.getMetadata().getFilename(), (Object)migrationKey);
            Request request = new Request(HTTP_METHOD_GET, String.format("%s/_search", MIGRATION_DOCUMENT_INDEX));
            request.setJsonEntity(String.format(MIGRATION_RECORD_SEARCH_QUERY_TEMPLATE_FIND_ONE_BY_MIGRATION_KEY_AND_MIGRATION_FILENAME, this.migrationKey, file.getMetadata().getFilename()));
            Response response = this.sendRequest(request);
            Map content = (Map)this.mapper.readValue(response.getEntity().getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            List records = content.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("hits")).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals("hits")).flatMap(entry -> ((List)entry.getValue()).stream()).flatMap(item -> item.entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals("_source")).map(entry -> (MigrationRecord)this.mapper.convertValue(entry.getValue(), (TypeReference)new TypeReference<MigrationRecord>(){})).collect(Collectors.toUnmodifiableList());
            if (records.size() > 1) {
                throw new IllegalStateException(String.format("found more than one migration record for migration file named [%s] and migration key [%s]", file.getMetadata().getFilename(), migrationKey));
            }
            if (records.size() == 1) {
                log.info("Found existing migration record for migration file named [{}] and migration key [{}]", (Object)file.getMetadata().getFilename(), (Object)migrationKey);
                return (MigrationRecord)records.get(0);
            }
            log.info("Did not find any existing migration record for migration file named [{}] and migration key [{}]", (Object)file.getMetadata().getFilename(), (Object)migrationKey);
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to get migration records for migration file named [%s] and migration key [%s]", file.getMetadata().getFilename(), migrationKey));
        }
    }

    public void executeMigrationDefinition(MigrationFile.MigrationFileRequestDefinition definition) {
        try {
            log.info("Executing migration query definition");
            Request request = new Request(definition.getMethod(), definition.getPath());
            if (definition.getParams() != null) {
                definition.getParams().forEach((arg_0, arg_1) -> ((Request)request).addParameter(arg_0, arg_1));
            }
            if (definition.getBody() != null && !definition.getBody().trim().equals("")) {
                request.setEntity((HttpEntity)new NStringEntity(definition.getBody(), ContentType.parse((String)definition.getContentType())));
            }
            this.sendRequest(request);
            log.info("Migration query definition executed successfully");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to execute migration query definition", e);
        }
    }

    public void createMigrationRecord(MigrationRecord record) {
        if (!record.getMigrationKey().equals(this.migrationKey)) {
            throw new IllegalStateException("migration record migration key must match operational migration key");
        }
        try {
            log.info("Creating migration record for migration definition file [{}]", (Object)record.getFilename());
            Request request = new Request(HTTP_METHOD_POST, String.format("%s/_doc", MIGRATION_DOCUMENT_INDEX));
            request.addParameter("refresh", "true");
            request.setJsonEntity(this.mapper.writeValueAsString((Object)record));
            this.sendRequest(request);
            log.info("Migration record for migration definition file [{}] created", (Object)record.getFilename());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to creat migration record for migration definition file [%s]", record.getFilename()), e);
        }
    }

    private Response sendRequest(Request request) throws Exception {
        log.debug("sending request [{}]", (Object)request);
        Response response = this.client.performRequest(request);
        log.debug("received response [{}]", (Object)response);
        return response;
    }
}

