/*
 * Decompiled with CFR 0.152.
 */
package org.loesak.esque.core.elasticsearch.documents;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.beans.ConstructorProperties;
import java.time.Instant;
import lombok.NonNull;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="migration")
public final class MigrationRecord {
    @NonNull
    private final String migrationKey;
    @NonNull
    private final Integer order;
    @NonNull
    private final String filename;
    @NonNull
    private final String version;
    @NonNull
    private final String description;
    @NonNull
    private final Integer checksum;
    private final String installedBy;
    @NonNull
    private final Instant installedOn;
    @NonNull
    private final Long executionTime;

    @ConstructorProperties(value={"migrationKey", "order", "filename", "version", "description", "checksum", "installedBy", "installedOn", "executionTime"})
    public MigrationRecord(@NonNull String migrationKey, @NonNull Integer order, @NonNull String filename, @NonNull String version, @NonNull String description, @NonNull Integer checksum, String installedBy, @NonNull Instant installedOn, @NonNull Long executionTime) {
        if (migrationKey == null) {
            throw new NullPointerException("migrationKey is marked non-null but is null");
        }
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (checksum == null) {
            throw new NullPointerException("checksum is marked non-null but is null");
        }
        if (installedOn == null) {
            throw new NullPointerException("installedOn is marked non-null but is null");
        }
        if (executionTime == null) {
            throw new NullPointerException("executionTime is marked non-null but is null");
        }
        this.migrationKey = migrationKey;
        this.order = order;
        this.filename = filename;
        this.version = version;
        this.description = description;
        this.checksum = checksum;
        this.installedBy = installedBy;
        this.installedOn = installedOn;
        this.executionTime = executionTime;
    }

    @NonNull
    public String getMigrationKey() {
        return this.migrationKey;
    }

    @NonNull
    public Integer getOrder() {
        return this.order;
    }

    @NonNull
    public String getFilename() {
        return this.filename;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public Integer getChecksum() {
        return this.checksum;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    @NonNull
    public Instant getInstalledOn() {
        return this.installedOn;
    }

    @NonNull
    public Long getExecutionTime() {
        return this.executionTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrationRecord)) {
            return false;
        }
        MigrationRecord other = (MigrationRecord)o;
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Integer this$checksum = this.getChecksum();
        Integer other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
            return false;
        }
        Long this$executionTime = this.getExecutionTime();
        Long other$executionTime = other.getExecutionTime();
        if (this$executionTime == null ? other$executionTime != null : !((Object)this$executionTime).equals(other$executionTime)) {
            return false;
        }
        String this$migrationKey = this.getMigrationKey();
        String other$migrationKey = other.getMigrationKey();
        if (this$migrationKey == null ? other$migrationKey != null : !this$migrationKey.equals(other$migrationKey)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$installedBy = this.getInstalledBy();
        String other$installedBy = other.getInstalledBy();
        if (this$installedBy == null ? other$installedBy != null : !this$installedBy.equals(other$installedBy)) {
            return false;
        }
        Instant this$installedOn = this.getInstalledOn();
        Instant other$installedOn = other.getInstalledOn();
        return !(this$installedOn == null ? other$installedOn != null : !((Object)this$installedOn).equals(other$installedOn));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Integer $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
        Long $executionTime = this.getExecutionTime();
        result = result * 59 + ($executionTime == null ? 43 : ((Object)$executionTime).hashCode());
        String $migrationKey = this.getMigrationKey();
        result = result * 59 + ($migrationKey == null ? 43 : $migrationKey.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $installedBy = this.getInstalledBy();
        result = result * 59 + ($installedBy == null ? 43 : $installedBy.hashCode());
        Instant $installedOn = this.getInstalledOn();
        result = result * 59 + ($installedOn == null ? 43 : ((Object)$installedOn).hashCode());
        return result;
    }

    public String toString() {
        return "MigrationRecord(migrationKey=" + this.getMigrationKey() + ", order=" + this.getOrder() + ", filename=" + this.getFilename() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", checksum=" + this.getChecksum() + ", installedBy=" + this.getInstalledBy() + ", installedOn=" + this.getInstalledOn() + ", executionTime=" + this.getExecutionTime() + ")";
    }
}

