/*
 * Decompiled with CFR 0.152.
 */
package org.loesak.esque.core.yaml.model;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class MigrationFile
implements Comparable<MigrationFile> {
    private static final String MIGRATION_DEFINITION_FILE_VERSION_PARTS_DELIMITER_REGEX = "\\.";
    @NonNull
    private final MigrationFileMetadata metadata;
    @NonNull
    private final MigrationFileContents contents;

    @Override
    public int compareTo(MigrationFile that) {
        String[] thisVersionParts = this.getMetadata().getVersion().split(MIGRATION_DEFINITION_FILE_VERSION_PARTS_DELIMITER_REGEX);
        String[] thatVersionParts = that.getMetadata().getVersion().split(MIGRATION_DEFINITION_FILE_VERSION_PARTS_DELIMITER_REGEX);
        int largestNumberOfParts = Math.max(thisVersionParts.length, thatVersionParts.length);
        for (int i = 0; i < largestNumberOfParts; ++i) {
            Integer thatVersionPartValue;
            Integer thisVersionPartValue = thisVersionParts.length <= i ? 0 : Integer.valueOf(thisVersionParts[i]);
            int result = thisVersionPartValue.compareTo(thatVersionPartValue = Integer.valueOf(thatVersionParts.length <= i ? 0 : Integer.valueOf(thatVersionParts[i])));
            if (result == 0) continue;
            return result;
        }
        int versionCompareResult = this.getMetadata().getVersion().compareTo(that.getMetadata().getVersion());
        if (versionCompareResult != 0) {
            return versionCompareResult;
        }
        return this.getMetadata().getDescription().compareTo(that.getMetadata().getDescription());
    }

    @ConstructorProperties(value={"metadata", "contents"})
    public MigrationFile(@NonNull MigrationFileMetadata metadata, @NonNull MigrationFileContents contents) {
        if (metadata == null) {
            throw new NullPointerException("metadata is marked non-null but is null");
        }
        if (contents == null) {
            throw new NullPointerException("contents is marked non-null but is null");
        }
        this.metadata = metadata;
        this.contents = contents;
    }

    @NonNull
    public MigrationFileMetadata getMetadata() {
        return this.metadata;
    }

    @NonNull
    public MigrationFileContents getContents() {
        return this.contents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrationFile)) {
            return false;
        }
        MigrationFile other = (MigrationFile)o;
        MigrationFileMetadata this$metadata = this.getMetadata();
        MigrationFileMetadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        MigrationFileContents this$contents = this.getContents();
        MigrationFileContents other$contents = other.getContents();
        return !(this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MigrationFileMetadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        MigrationFileContents $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        return result;
    }

    public String toString() {
        return "MigrationFile(metadata=" + this.getMetadata() + ", contents=" + this.getContents() + ")";
    }

    public static final class MigrationFileRequestDefinition {
        @NonNull
        private final String method;
        @NonNull
        private final String path;
        private final String contentType;
        private final Map<String, String> params;
        private final String body;

        @ConstructorProperties(value={"method", "path", "contentType", "params", "body"})
        public MigrationFileRequestDefinition(@NonNull String method, @NonNull String path, String contentType, Map<String, String> params, String body) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.method = method;
            this.path = path;
            this.contentType = contentType;
            this.params = params;
            this.body = body;
        }

        @NonNull
        public String getMethod() {
            return this.method;
        }

        @NonNull
        public String getPath() {
            return this.path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public String getBody() {
            return this.body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MigrationFileRequestDefinition)) {
                return false;
            }
            MigrationFileRequestDefinition other = (MigrationFileRequestDefinition)o;
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            Map<String, String> this$params = this.getParams();
            Map<String, String> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            Map<String, String> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "MigrationFile.MigrationFileRequestDefinition(method=" + this.getMethod() + ", path=" + this.getPath() + ", contentType=" + this.getContentType() + ", params=" + this.getParams() + ", body=" + this.getBody() + ")";
        }
    }

    public static final class MigrationFileContents {
        private final List<MigrationFileRequestDefinition> requests;

        @ConstructorProperties(value={"requests"})
        public MigrationFileContents(List<MigrationFileRequestDefinition> requests) {
            this.requests = requests;
        }

        public List<MigrationFileRequestDefinition> getRequests() {
            return this.requests;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MigrationFileContents)) {
                return false;
            }
            MigrationFileContents other = (MigrationFileContents)o;
            List<MigrationFileRequestDefinition> this$requests = this.getRequests();
            List<MigrationFileRequestDefinition> other$requests = other.getRequests();
            return !(this$requests == null ? other$requests != null : !((Object)this$requests).equals(other$requests));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<MigrationFileRequestDefinition> $requests = this.getRequests();
            result = result * 59 + ($requests == null ? 43 : ((Object)$requests).hashCode());
            return result;
        }

        public String toString() {
            return "MigrationFile.MigrationFileContents(requests=" + this.getRequests() + ")";
        }
    }

    public static final class MigrationFileMetadata {
        @NonNull
        private final String filename;
        @NonNull
        private final String version;
        @NonNull
        private final String description;
        @NonNull
        private final Integer checksum;

        @ConstructorProperties(value={"filename", "version", "description", "checksum"})
        public MigrationFileMetadata(@NonNull String filename, @NonNull String version, @NonNull String description, @NonNull Integer checksum) {
            if (filename == null) {
                throw new NullPointerException("filename is marked non-null but is null");
            }
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            if (checksum == null) {
                throw new NullPointerException("checksum is marked non-null but is null");
            }
            this.filename = filename;
            this.version = version;
            this.description = description;
            this.checksum = checksum;
        }

        @NonNull
        public String getFilename() {
            return this.filename;
        }

        @NonNull
        public String getVersion() {
            return this.version;
        }

        @NonNull
        public String getDescription() {
            return this.description;
        }

        @NonNull
        public Integer getChecksum() {
            return this.checksum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MigrationFileMetadata)) {
                return false;
            }
            MigrationFileMetadata other = (MigrationFileMetadata)o;
            Integer this$checksum = this.getChecksum();
            Integer other$checksum = other.getChecksum();
            if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
                return false;
            }
            String this$filename = this.getFilename();
            String other$filename = other.getFilename();
            if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
            String $filename = this.getFilename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "MigrationFile.MigrationFileMetadata(filename=" + this.getFilename() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", checksum=" + this.getChecksum() + ")";
        }
    }
}

