/*
 * Decompiled with CFR 0.152.
 */
package org.loesak.esque.core.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.loesak.esque.core.yaml.model.MigrationFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationFileLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationFileLoader.class);
    private static final String MIGRATION_DEFINITION_DIRECTORY = "es.migration";
    private static final String MIGRATION_DEFINITION_FILE_NAME_REGEX = "^V((\\d+\\.?)+)__(\\w+)\\.yml$";
    private static final Pattern MIGRATION_DEFINITION_FILE_NAME_PATTERN = Pattern.compile("^V((\\d+\\.?)+)__(\\w+)\\.yml$");
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final MessageDigest MESSAGE_DIGEST;

    public List<MigrationFile> load() throws Exception {
        log.info("Loading migration files from [{}]", (Object)MIGRATION_DEFINITION_DIRECTORY);
        List<MigrationFile> files = Files.list(Paths.get(Objects.requireNonNull(this.getClass().getClassLoader().getResource("es.migration/")).toURI())).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toFile().getName().matches(MIGRATION_DEFINITION_FILE_NAME_REGEX)).map(MigrationFileLoader::read).sorted().collect(Collectors.toUnmodifiableList());
        log.info("Found [{}] migration files", (Object)files.size());
        return files;
    }

    private static MigrationFile read(Path path) {
        String filename = path.toFile().getName();
        log.info("Reading contents of migration file [{}]", (Object)filename);
        try {
            Matcher matcher = MIGRATION_DEFINITION_FILE_NAME_PATTERN.matcher(filename);
            if (!matcher.matches()) {
                throw new IllegalStateException("filename does not match expected pattern");
            }
            return new MigrationFile(new MigrationFile.MigrationFileMetadata(filename, matcher.group(1), matcher.group(3), MigrationFileLoader.calculateChecksum(path)), (MigrationFile.MigrationFileContents)YAML_MAPPER.readValue(Files.newInputStream(path, new OpenOption[0]), MigrationFile.MigrationFileContents.class));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("failed to read the contents of migration file [%s]", filename), e);
        }
    }

    private static Integer calculateChecksum(Path path) throws Exception {
        MESSAGE_DIGEST.reset();
        MESSAGE_DIGEST.update(Files.readAllBytes(path));
        return ByteBuffer.wrap(MESSAGE_DIGEST.digest()).getInt();
    }

    static {
        try {
            MESSAGE_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("failed to create message digest");
        }
    }
}

