/*
 * Decompiled with CFR 0.152.
 */
package org.log4s.log4sjs;

import org.log4s.Debug$;
import org.log4s.Error$;
import org.log4s.Info$;
import org.log4s.LogLevel;
import org.log4s.Trace$;
import org.log4s.Warn$;
import org.log4s.log4sjs.ExceptionInfo;
import org.log4s.log4sjs.ExceptionInfo$;
import org.log4s.log4sjs.ExceptionInfo$NoException$;
import org.log4s.log4sjs.Log4sConfig$;
import org.log4s.log4sjs.Log4sEvent;
import org.log4s.log4sjs.LoggerParser$;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.MDC$;
import scala.collection.immutable.Seq;
import scala.scalajs.js.Date;
import scala.scalajs.js.Error;

public class Log4sLoggerFactory
implements ILoggerFactory {
    public final Log4sConfig$ org$log4s$log4sjs$Log4sLoggerFactory$$config() {
        return Log4sConfig$.MODULE$;
    }

    @Override
    public Logger getLogger(String name) {
        return new Log4sLoggerInstance(this, name);
    }

    private final class Log4sLoggerInstance
    extends Logger {
        private final String name;
        private final Seq<String> path;
        private final Log4sLoggerFactory $outer;

        public Log4sLoggerInstance(Log4sLoggerFactory $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.path = LoggerParser$.MODULE$.apply(name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean isEnabled(LogLevel level) {
            return this.$outer.org$log4s$log4sjs$Log4sLoggerFactory$$config().isPathEnabled(this.path, level);
        }

        public void doLog(LogLevel level, String message, ExceptionInfo throwable) {
            Log4sEvent event = new Log4sEvent(this.name, this.path, level, message, MDC$.MODULE$.asScala(), Thread.currentThread().getName(), throwable, new Date());
            this.$outer.org$log4s$log4sjs$Log4sLoggerFactory$$config().doLog(event);
        }

        public ExceptionInfo doLog$default$3() {
            return ExceptionInfo$NoException$.MODULE$;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isEnabled(Trace$.MODULE$);
        }

        @Override
        public void trace(String message) {
            this.doLog(Trace$.MODULE$, message, this.doLog$default$3());
        }

        @Override
        public void trace(String message, Throwable t) {
            this.doLog(Trace$.MODULE$, message, ExceptionInfo$.MODULE$.apply(t));
        }

        @Override
        public void trace(String message, Error e) {
            this.doLog(Trace$.MODULE$, message, ExceptionInfo$.MODULE$.apply(e));
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isEnabled(Debug$.MODULE$);
        }

        @Override
        public void debug(String message) {
            this.doLog(Debug$.MODULE$, message, this.doLog$default$3());
        }

        @Override
        public void debug(String message, Throwable t) {
            this.doLog(Debug$.MODULE$, message, ExceptionInfo$.MODULE$.apply(t));
        }

        @Override
        public void debug(String message, Error e) {
            this.doLog(Debug$.MODULE$, message, ExceptionInfo$.MODULE$.apply(e));
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isEnabled(Info$.MODULE$);
        }

        @Override
        public void info(String message) {
            this.doLog(Info$.MODULE$, message, this.doLog$default$3());
        }

        @Override
        public void info(String message, Throwable t) {
            this.doLog(Info$.MODULE$, message, ExceptionInfo$.MODULE$.apply(t));
        }

        @Override
        public void info(String message, Error e) {
            this.doLog(Info$.MODULE$, message, ExceptionInfo$.MODULE$.apply(e));
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isEnabled(Warn$.MODULE$);
        }

        @Override
        public void warn(String message) {
            this.doLog(Warn$.MODULE$, message, this.doLog$default$3());
        }

        @Override
        public void warn(String message, Throwable t) {
            this.doLog(Warn$.MODULE$, message, ExceptionInfo$.MODULE$.apply(t));
        }

        @Override
        public void warn(String message, Error e) {
            this.doLog(Warn$.MODULE$, message, ExceptionInfo$.MODULE$.apply(e));
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isEnabled(Error$.MODULE$);
        }

        @Override
        public void error(String message) {
            this.doLog(Error$.MODULE$, message, this.doLog$default$3());
        }

        @Override
        public void error(String message, Throwable t) {
            this.doLog(Error$.MODULE$, message, ExceptionInfo$.MODULE$.apply(t));
        }

        @Override
        public void error(String message, Error e) {
            this.doLog(Error$.MODULE$, message, ExceptionInfo$.MODULE$.apply(e));
        }

        public final Log4sLoggerFactory org$log4s$log4sjs$Log4sLoggerFactory$Log4sLoggerInstance$$$outer() {
            return this.$outer;
        }
    }
}

