/*
 * Decompiled with CFR 0.152.
 */
package org.log4s.log4sjs;

import java.io.Serializable;
import org.log4s.log4sjs.ExceptionInfo;
import org.log4s.log4sjs.ExceptionInfo$NoException$;
import org.log4s.log4sjs.LoggedEvent;
import org.log4s.log4sjs.MessageFormatter;
import org.log4s.log4sjs.StandardMessageFormatter$;
import org.log4s.log4sjs.StandardMessageFormatter$MDCFormat$AlwaysMDC$;
import org.log4s.log4sjs.StandardMessageFormatter$MDCFormat$NoMDC$;
import org.log4s.log4sjs.StandardMessageFormatter$MDCFormat$NonEmptyMDC$;
import scala.Function$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.Error;

public class StandardMessageFormatter
extends scala.scalajs.js.Object
implements MessageFormatter {
    private final boolean useLocalizedThrowableMessages;
    private final MDCFormat mdcFormat;
    private final String indentString;
    private Function1 mdcBuilder$lzy1;
    private boolean mdcBuilderbitmap$1;

    public static boolean $lessinit$greater$default$1() {
        return StandardMessageFormatter$.MODULE$.$lessinit$greater$default$1();
    }

    public static MDCFormat $lessinit$greater$default$2() {
        return StandardMessageFormatter$.MODULE$.$lessinit$greater$default$2();
    }

    public StandardMessageFormatter(boolean useLocalizedThrowableMessages, MDCFormat mdcFormat) {
        this.useLocalizedThrowableMessages = useLocalizedThrowableMessages;
        this.mdcFormat = mdcFormat;
        int indentSize = 8;
        this.indentString = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), 8);
    }

    public boolean useLocalizedThrowableMessages() {
        return this.useLocalizedThrowableMessages;
    }

    public MDCFormat mdcFormat() {
        return this.mdcFormat;
    }

    @Override
    public String render(LoggedEvent le) {
        ExceptionInfo t = le.throwable();
        String message = le.message();
        return StringOps$.MODULE$.format$extension("%s %-5s%s %s - %s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{StandardMessageFormatter.timePart$1(le), StandardMessageFormatter.levelPart$1(le), this.mdcPart$1(le), StandardMessageFormatter.loggerPart$1(le), message, this.throwablePart$1(t)}));
    }

    public Option<String> renderExceptionInfo(ExceptionInfo ei) {
        None$ none$;
        ExceptionInfo exceptionInfo = ei;
        if (ExceptionInfo$NoException$.MODULE$.equals((Object)exceptionInfo)) {
            none$ = None$.MODULE$;
        } else if (exceptionInfo instanceof ExceptionInfo.ThrowableException) {
            ExceptionInfo.ThrowableException te = (ExceptionInfo.ThrowableException)exceptionInfo;
            none$ = Some$.MODULE$.apply((Object)this.renderStackTrace(te.throwable()));
        } else if (exceptionInfo instanceof ExceptionInfo.JsErrorException) {
            ExceptionInfo.JsErrorException ee = (ExceptionInfo.JsErrorException)exceptionInfo;
            none$ = Some$.MODULE$.apply((Object)this.renderJsError(ee.error()));
        } else {
            throw new MatchError((Object)exceptionInfo);
        }
        return none$;
    }

    public String renderStackTrace(Throwable t2) {
        return ((IterableOnceOps)((IterableOps)this.unfoldCauses(t2).$plus$colon((Object)t2)).map((Function1 & Serializable)t -> this.renderOneStack((Throwable)t))).mkString("Caused by: ");
    }

    public String renderJsError(Error jse) {
        None$ none$;
        Dynamic dynamic = ((Dynamic)jse).selectDynamic("stack");
        if (dynamic instanceof String) {
            String s = (String)dynamic;
            none$ = Some$.MODULE$.apply((Object)s);
        } else {
            Dynamic other = dynamic;
            none$ = None$.MODULE$;
        }
        None$ stackPart = none$;
        return (String)stackPart.getOrElse(() -> StandardMessageFormatter.renderJsError$$anonfun$1(jse));
    }

    public String renderOneStack(Throwable t) {
        String className = t.getClass().getName();
        String message = this.useLocalizedThrowableMessages() ? t.getLocalizedMessage() : t.getMessage();
        Object[] frames = t.getStackTrace();
        Object object = Predef$.MODULE$.refArrayOps(frames);
        Object[] stack = (String[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)frame -> {
            Vector basicInfo = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.indentString, "at ", frame.getClassName(), ".", frame.getMethodName()}));
            Seq positionInfo = (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)frame.getFileName()).map((Function1 & Serializable)fn -> {
                Nil$ nil$;
                int n = frame.getLineNumber();
                int n2 = n;
                if (n2 < 0) {
                    nil$ = package$.MODULE$.Nil();
                } else {
                    int other = n;
                    nil$ = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{":", BoxesRunTime.boxToInteger((int)other).toString()}));
                }
                Nil$ linePart = nil$;
                return (Seq)((SeqOps)((SeqOps)linePart.$plus$colon(fn)).$plus$colon((Object)"(")).$colon$plus((Object)")");
            })).toSeq().flatten(Predef$.MODULE$.$conforms());
            return (Vector)((SeqOps)basicInfo.$plus$plus((IterableOnce)positionInfo)).$colon$plus((Object)"\n");
        }, ClassTag$.MODULE$.apply(String.class));
        return "" + className + ": " + message + "\n" + Predef$.MODULE$.wrapRefArray(stack).mkString();
    }

    private Function1<Map<String, String>, String> mdcBuilder() {
        if (!this.mdcBuilderbitmap$1) {
            Function1 & Serializable intersect;
            MDCFormat mDCFormat = this.mdcFormat();
            if (StandardMessageFormatter$MDCFormat$NoMDC$.MODULE$.equals(mDCFormat)) {
                intersect = (Function1 & Serializable)y -> (String)Function$.MODULE$.const((Object)"", y);
            } else if (StandardMessageFormatter$MDCFormat$NonEmptyMDC$.MODULE$.equals(mDCFormat)) {
                intersect = (Function1 & Serializable)mdc2 -> mdc2.isEmpty() ? "" : StandardMessageFormatter.buildMDC$2(mdc2);
            } else if (StandardMessageFormatter$MDCFormat$AlwaysMDC$.MODULE$.equals(mDCFormat)) {
                intersect = (Function1 & Serializable)mdc2 -> mdc2.isEmpty() ? " {}" : StandardMessageFormatter.buildMDC$2(mdc2);
            } else {
                throw new MatchError((Object)mDCFormat);
            }
            this.mdcBuilder$lzy1 = intersect;
            this.mdcBuilderbitmap$1 = true;
        }
        return this.mdcBuilder$lzy1;
    }

    private Seq<Throwable> unfoldCauses(Throwable t) {
        return StandardMessageFormatter.unfold$1(t, (Function1 & Serializable)thr -> Option$.MODULE$.apply((Object)thr.getCause()).map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply(c, c)));
    }

    private static final String throwablePart$3$$anonfun$2() {
        return "";
    }

    private final String throwablePart$1(ExceptionInfo t$1) {
        return (String)this.renderExceptionInfo(t$1).map((Function1 & Serializable)_$1 -> "\n" + _$1).getOrElse(StandardMessageFormatter::throwablePart$3$$anonfun$2);
    }

    private static final String levelPart$1(LoggedEvent le$1) {
        return le$1.level().name().toUpperCase();
    }

    private static final /* synthetic */ char timePart$2$$anonfun$1(char x$1) {
        int n;
        char c = x$1;
        if ('T' == c) {
            n = 32;
        } else if ('.' == c) {
            n = 44;
        } else {
            char other = c;
            n = other;
        }
        return (char)n;
    }

    private static final String timePart$1(LoggedEvent le$2) {
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.init$extension(Predef$.MODULE$.augmentString(le$2.timestamp().toISOString()))), (Function1 & Serializable)x$1 -> StandardMessageFormatter.timePart$2$$anonfun$1(BoxesRunTime.unboxToChar((Object)x$1)));
    }

    private static final String loggerPart$1(LoggedEvent le$3) {
        return le$3.loggerName();
    }

    private final String mdcPart$1(LoggedEvent le$4) {
        return (String)this.mdcBuilder().apply(le$4.mdc());
    }

    private static final String renderJsError$$anonfun$1(Error jse$1) {
        return "{jse.name}: " + jse$1.message();
    }

    private static final String buildMDC$2(Map mdc2) {
        return ((IterableOnceOps)((IterableOps)mdc2.foldRight((Object)package$.MODULE$.Nil(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                throw new MatchError((Object)tuple22);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            List l = (List)tuple22._2();
            return l.$colon$colon((Object)v).$colon$colon((Object)"=").$colon$colon((Object)k).$colon$colon((Object)", ");
        })).tail()).mkString(" {", "", "}");
    }

    private static final Seq helper$1(Function1 fn$2, Object b, Vector accum) {
        Tuple2 tuple2;
        Option option;
        Vector vector = accum;
        Object object = b;
        while ((option = (Option)fn$2.apply(object)) instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Object b2;
            Object a = tuple2._1();
            Object object2 = b2 = tuple2._2();
            Vector vector2 = (Vector)vector.$colon$plus(a);
            object = object2;
            vector = vector2;
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        return vector;
    }

    private static final Seq unfold$1(Object b, Function1 fn) {
        return StandardMessageFormatter.helper$1(fn, b, package$.MODULE$.Vector().empty());
    }

    public static interface MDCFormat {
    }
}

