/*
 * Decompiled with CFR 0.152.
 */
package losty.netatmo;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import losty.netatmo.NetatmoUtils;
import losty.netatmo.model.Home;
import losty.netatmo.model.Measures;
import losty.netatmo.model.Module;
import losty.netatmo.model.Station;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.json.JSONException;
import org.json.JSONObject;

public class NetatmoHttpClient {
    private static final String URL_BASE = "https://api.netatmo.net";
    private static final String URL_REQUEST_TOKEN = "https://api.netatmo.net/oauth2/token";
    private static final String URL_GET_STATIONS_DATA = "https://api.netatmo.net/api/getstationsdata";
    private static final String URL_GET_MEASURES = "https://api.netatmo.net/api/getmeasure";
    private static final String URL_GET_PUBLIC_DATA = "https://api.netatmo.net/api/getpublicdata";
    private static final String URL_GET_HOMESDATA = "https://api.netatmo.net/api/homesdata";
    private static final String URL_GET_HOMESTATUS = "https://api.netatmo.net/api/homestatus";
    private static final String SCOPE = "read_station read_thermostat";
    private final OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
    private String clientId;
    private String clientSecret;

    public NetatmoHttpClient(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public OAuthJSONAccessTokenResponse login(String email, String password) throws OAuthSystemException, OAuthProblemException {
        OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)URL_REQUEST_TOKEN).setGrantType(GrantType.PASSWORD).setClientId(this.clientId).setClientSecret(this.clientSecret).setUsername(email).setPassword(password).setScope(SCOPE).buildBodyMessage();
        return this.oAuthClient.accessToken(request);
    }

    public OAuthJSONAccessTokenResponse refreshToken(OAuthJSONAccessTokenResponse token) throws OAuthSystemException, OAuthProblemException {
        OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)URL_REQUEST_TOKEN).setGrantType(GrantType.REFRESH_TOKEN).setClientId(this.clientId).setClientSecret(this.clientSecret).setRefreshToken(token.getRefreshToken()).setScope(SCOPE).buildBodyMessage();
        return this.oAuthClient.accessToken(request);
    }

    public List<Station> getStationsData(OAuthJSONAccessTokenResponse token, Station station, Boolean getFavorites) throws OAuthSystemException, OAuthProblemException, JSONException {
        ArrayList<String> params = new ArrayList<String>();
        if (station != null) {
            params.add("device_id=" + station.getId());
        }
        if (getFavorites != null) {
            params.add("get_favorites=" + getFavorites);
        }
        String query = NetatmoHttpClient.implode("&", params.toArray(new String[0]));
        String request = "https://api.netatmo.net/api/getstationsdata?" + query;
        OAuthClientRequest bearerClientRequest = new OAuthBearerClientRequest(request).setAccessToken(token.getAccessToken()).buildQueryMessage();
        OAuthResourceResponse resourceResponse = (OAuthResourceResponse)this.oAuthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
        return NetatmoUtils.parseStationsData(new JSONObject(resourceResponse.getBody()));
    }

    public List<Measures> getMeasures(OAuthJSONAccessTokenResponse token, Station station, Module module, List<String> types, String scale, Date dateBegin, Date dateEnd, Integer limit, Boolean realTime) throws OAuthSystemException, OAuthProblemException {
        Long dateBeginMillis = null;
        if (dateBegin != null) {
            dateBeginMillis = dateBegin.getTime() / 1000L;
        }
        Long dateEndMillis = null;
        if (dateEnd != null) {
            dateEndMillis = dateEnd.getTime() / 1000L;
        }
        return this.getMeasures(token, station, module, types, scale, dateBeginMillis, dateEndMillis, limit, realTime);
    }

    public List<Measures> getMeasures(OAuthJSONAccessTokenResponse token, Station station, Module module, List<String> types, String scale, Long dateBegin, Long dateEnd, Integer limit, Boolean realTime) throws OAuthSystemException, OAuthProblemException {
        String[] typesArr = types != null ? types.toArray(new String[0]) : new String[]{};
        ArrayList<String> params = new ArrayList<String>();
        params.add("device_id=" + station.getId());
        params.add("scale=" + scale);
        params.add("type=" + NetatmoHttpClient.implode(",", typesArr));
        if (module != null) {
            params.add("module_id=" + module.getId());
        }
        if (dateBegin != null) {
            params.add(String.format("date_begin=%d", dateBegin));
        }
        if (dateEnd != null) {
            params.add(String.format("date_end=%d", dateEnd));
        }
        if (limit != null) {
            params.add(String.format("limit=%d", limit));
        }
        if (realTime != null) {
            params.add(String.format("real_time=%b", realTime));
        }
        String query = NetatmoHttpClient.implode("&", params.toArray(new String[0]));
        String request = "https://api.netatmo.net/api/getmeasure?" + query;
        OAuthClientRequest bearerClientRequest = new OAuthBearerClientRequest(request).setAccessToken(token.getAccessToken()).buildQueryMessage();
        OAuthResourceResponse resourceResponse = (OAuthResourceResponse)this.oAuthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
        return NetatmoUtils.parseMeasures(new JSONObject(resourceResponse.getBody()), typesArr);
    }

    public List<Map.Entry<Station, Measures>> getPublicData(OAuthJSONAccessTokenResponse token, double lat_ne, double lon_ne, double lat_sw, double lon_sw, List<String> types, Boolean filter) throws OAuthSystemException, OAuthProblemException {
        ArrayList<String> params = new ArrayList<String>();
        params.add("lat_ne=" + lat_ne);
        params.add("lon_ne=" + lon_ne);
        params.add("lat_sw=" + lat_sw);
        params.add("lon_sw=" + lon_sw);
        if (types != null) {
            params.add("required_data=" + NetatmoHttpClient.implode(",", types.toArray(new String[0])));
        }
        if (filter != null) {
            params.add("filter=" + filter);
        }
        String query = NetatmoHttpClient.implode("&", params.toArray(new String[0]));
        String request = "https://api.netatmo.net/api/getpublicdata?" + query;
        OAuthClientRequest bearerClientRequest = new OAuthBearerClientRequest(request).setAccessToken(token.getAccessToken()).buildQueryMessage();
        OAuthResourceResponse resourceResponse = (OAuthResourceResponse)this.oAuthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
        return NetatmoUtils.parsePublicData(new JSONObject(resourceResponse.getBody()));
    }

    private static String implode(String separator, String ... data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length - 1; ++i) {
            sb.append(data[i]);
            sb.append(separator);
        }
        if (data.length > 0) {
            sb.append(data[data.length - 1].trim());
        }
        return sb.toString();
    }

    public List<Home> getHomesdata(OAuthJSONAccessTokenResponse token) throws OAuthSystemException, OAuthProblemException {
        String request = URL_GET_HOMESDATA;
        OAuthClientRequest bearerClientRequest = new OAuthBearerClientRequest(URL_GET_HOMESDATA).setAccessToken(token.getAccessToken()).buildQueryMessage();
        OAuthResourceResponse resourceResponse = (OAuthResourceResponse)this.oAuthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
        return NetatmoUtils.parseHomesdata(new JSONObject(resourceResponse.getBody()));
    }

    public Home getHomestatus(OAuthJSONAccessTokenResponse token, Home home) throws OAuthSystemException, OAuthProblemException {
        ArrayList<String> params = new ArrayList<String>();
        if (home != null) {
            params.add("home_id=" + home.getId());
        }
        String query = NetatmoHttpClient.implode("&", params.toArray(new String[0]));
        String request = "https://api.netatmo.net/api/homestatus?" + query;
        OAuthClientRequest bearerClientRequest = new OAuthBearerClientRequest(request).buildQueryMessage();
        bearerClientRequest.addHeader("Authorization", "Bearer " + token.getAccessToken());
        OAuthResourceResponse resourceResponse = (OAuthResourceResponse)this.oAuthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
        Home result = NetatmoUtils.parseHomestatus(new JSONObject(resourceResponse.getBody()));
        result.setName(home.getName());
        return result;
    }
}

