/*
 * Decompiled with CFR 0.152.
 */
package losty.netatmo;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import losty.netatmo.model.Home;
import losty.netatmo.model.Measures;
import losty.netatmo.model.Module;
import losty.netatmo.model.Room;
import losty.netatmo.model.Station;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NetatmoUtils {
    public static List<Station> parseStationsData(JSONObject response) throws JSONException {
        ArrayList<Station> result = new ArrayList<Station>();
        if (response == null) {
            return result;
        }
        JSONArray JSONstations = response.getJSONObject("body").getJSONArray("devices");
        for (int i = 0; i < JSONstations.length(); ++i) {
            JSONObject station = JSONstations.getJSONObject(i);
            String stationId = station.getString("_id");
            String stationName = station.getString("station_name");
            String stationModuleName = station.optString("module_name", stationId);
            Station newStation = new Station(stationName, stationId);
            Module newStationModule = new Module(stationModuleName, stationId, "NAModule4");
            newStation.addModule(newStationModule);
            JSONArray JSONmodules = station.getJSONArray("modules");
            for (int j = 0; j < JSONmodules.length(); ++j) {
                JSONObject module = JSONmodules.getJSONObject(j);
                String moduleId = module.getString("_id");
                String moduleName = module.optString("module_name", moduleId);
                String moduleType = module.getString("type");
                Module newModule = new Module(moduleName, moduleId, moduleType);
                newStation.addModule(newModule);
            }
            result.add(newStation);
        }
        return result;
    }

    public static List<Measures> parseMeasures(JSONObject response, String[] types) throws JSONException {
        ArrayList<Measures> result = new ArrayList<Measures>();
        if (response == null) {
            return result;
        }
        JSONArray body = response.getJSONArray("body");
        for (int i = 0; i < body.length(); ++i) {
            JSONObject data = body.getJSONObject(i);
            Long beginTime = data.getLong("beg_time");
            Long stepTime = data.optLong("step_time", 0L);
            JSONArray values = data.getJSONArray("value");
            for (int j = 0; j < values.length(); ++j) {
                JSONArray myValues = values.getJSONArray(j);
                long myBeginTime = (beginTime + (long)j * stepTime) * 1000L;
                Measures measures = new Measures();
                measures.setBeginTime(myBeginTime);
                block34: for (int k = 0; k < types.length; ++k) {
                    if (myValues.isNull(k)) continue;
                    switch (types[k]) {
                        case "Temperature": {
                            measures.setTemperature(myValues.getDouble(k));
                            continue block34;
                        }
                        case "CO2": {
                            measures.setCO2(myValues.getDouble(k));
                            continue block34;
                        }
                        case "Humidity": {
                            measures.setHumidity(myValues.getDouble(k));
                            continue block34;
                        }
                        case "Pressure": {
                            measures.setPressure(myValues.getDouble(k));
                            continue block34;
                        }
                        case "Noise": {
                            measures.setNoise(myValues.getDouble(k));
                            continue block34;
                        }
                        case "min_temp": {
                            measures.setMinTemp(myValues.getDouble(k));
                            continue block34;
                        }
                        case "max_temp": {
                            measures.setMaxTemp(myValues.getDouble(k));
                            continue block34;
                        }
                        case "Rain": {
                            measures.setRain(myValues.getDouble(k));
                            continue block34;
                        }
                        case "sum_rain_1": {
                            measures.setSum_rain_1(myValues.getDouble(k));
                            continue block34;
                        }
                        case "sum_rain_24": {
                            measures.setSum_rain_24(myValues.getDouble(k));
                            continue block34;
                        }
                        case "WindAngle": {
                            measures.setWindAngle(myValues.getDouble(k));
                            continue block34;
                        }
                        case "WindStrength": {
                            measures.setWindStrength(myValues.getDouble(k));
                            continue block34;
                        }
                        case "GustAngle": {
                            measures.setGustAngle(myValues.getDouble(k));
                            continue block34;
                        }
                        case "GustStrength": {
                            measures.setGustStrength(myValues.getDouble(k));
                            continue block34;
                        }
                    }
                }
                result.add(measures);
            }
        }
        return result;
    }

    public static List<Map.Entry<Station, Measures>> parsePublicData(JSONObject response) throws JSONException {
        ArrayList<Map.Entry<Station, Measures>> result = new ArrayList<Map.Entry<Station, Measures>>();
        if (response == null) {
            return result;
        }
        JSONArray body = response.getJSONArray("body");
        for (int i = 0; i < body.length(); ++i) {
            JSONObject data = body.getJSONObject(i);
            Station station = NetatmoUtils.parseStation(data);
            List<Module> modules = NetatmoUtils.parseModules(data.getJSONObject("module_types"));
            Map<String, Station> stationsById = NetatmoUtils.determineStations(station, modules);
            JSONObject measuresAllModules = data.getJSONObject("measures");
            for (String measuresModuleId : measuresAllModules.keySet()) {
                JSONObject measuresThisModule = measuresAllModules.getJSONObject(measuresModuleId);
                Station stationForModule = stationsById.get(measuresModuleId);
                Measures measures = null;
                if (stationForModule == null) {
                    throw new RuntimeException(NetatmoUtils.format("Cannot find moduleId=%s", measuresModuleId));
                }
                if (stationForModule.getModules().size() == 0) {
                    measures = NetatmoUtils.parseMeasuresMethod1(measuresThisModule);
                } else {
                    switch (stationForModule.getModules().get(0).getType()) {
                        case "NAModule1": {
                            measures = NetatmoUtils.parseMeasuresMethod1(measuresThisModule);
                            break;
                        }
                        case "NAModule2": {
                            measures = NetatmoUtils.parseMeasuresMethod2(measuresThisModule);
                            break;
                        }
                        case "NAModule3": {
                            measures = NetatmoUtils.parseMeasuresMethod2(measuresThisModule);
                            break;
                        }
                        case "NAModule4": {
                            measures = NetatmoUtils.parseMeasuresMethod1(measuresThisModule);
                        }
                    }
                }
                result.add(new AbstractMap.SimpleImmutableEntry<Station, Measures>(stationForModule, measures));
            }
        }
        return result;
    }

    public static List<Home> parseHomesdata(JSONObject response) throws JSONException {
        ArrayList<Home> result = new ArrayList<Home>();
        if (response == null) {
            return result;
        }
        JSONArray jsonHomes = response.getJSONObject("body").getJSONArray("homes");
        for (int i = 0; i < jsonHomes.length(); ++i) {
            JSONObject homeJsonObject = jsonHomes.getJSONObject(i);
            String id = homeJsonObject.getString("id");
            String name = homeJsonObject.getString("name");
            Home home = new Home(id, name);
            result.add(home);
        }
        return result;
    }

    public static Home parseHomestatus(JSONObject response) throws JSONException {
        Home home = new Home();
        if (response == null) {
            return home;
        }
        JSONObject jsonHome = response.getJSONObject("body").getJSONObject("home");
        String home_id = jsonHome.getString("id");
        home.setId(home_id);
        JSONArray jsonModules = jsonHome.getJSONArray("modules");
        for (int i = 0; i < jsonModules.length(); ++i) {
            JSONObject jsonModule = jsonModules.getJSONObject(i);
            String module_id = jsonModule.getString("id");
            String module_type = jsonModule.getString("type");
            Module module = new Module();
            module.setId(module_id);
            module.setType(module_type);
            if (module_type.equals("NATherm1")) {
                boolean boiler_status = jsonModule.getBoolean("boiler_status");
                boolean reachable = jsonModule.getBoolean("reachable");
                module.setBoilerStatus(boiler_status);
                module.setReachable(reachable);
            }
            home.addModule(module);
        }
        JSONArray jsonRooms = jsonHome.getJSONArray("rooms");
        for (int i = 0; i < jsonRooms.length(); ++i) {
            JSONObject jsonRoom = jsonRooms.getJSONObject(i);
            String room_id = jsonRoom.getString("id");
            boolean reachable = jsonRoom.getBoolean("reachable");
            float therm_measured_temperature = jsonRoom.getFloat("therm_measured_temperature");
            float therm_setpoint_temperature = jsonRoom.getFloat("therm_setpoint_temperature");
            String therm_setpoint_mode = jsonRoom.getString("therm_setpoint_mode");
            long therm_setpoint_start_time = jsonRoom.getLong("therm_setpoint_start_time");
            long therm_setpoint_end_time = jsonRoom.getLong("therm_setpoint_end_time");
            Room room = new Room();
            room.setId(room_id);
            room.setReachable(reachable);
            room.setTherm_measured_temperature(therm_measured_temperature);
            room.setTherm_setpoint_temperature(therm_setpoint_temperature);
            room.setTherm_setpoint_mode(therm_setpoint_mode);
            room.setTherm_setpoint_start_time(therm_setpoint_start_time);
            room.setTherm_setpoint_end_time(therm_setpoint_end_time);
            home.addRoom(room);
        }
        return home;
    }

    private static Map<String, Station> determineStations(Station station, List<Module> modules) {
        HashMap<String, Station> ret = new HashMap<String, Station>();
        ret.put(station.getId(), station);
        for (Module module : modules) {
            Station stationForModule = new Station(station);
            stationForModule.setModules(Collections.singletonList(module));
            ret.put(module.getId(), stationForModule);
        }
        return ret;
    }

    private static Measures parseMeasuresMethod1(JSONObject measuresThisModule) {
        JSONArray types = measuresThisModule.getJSONArray("type");
        JSONObject res = measuresThisModule.getJSONObject("res");
        String timestampStr = (String)res.keys().next();
        JSONArray values = res.getJSONArray(timestampStr);
        Measures ret = new Measures();
        long timestamp = Long.parseLong(timestampStr);
        ret.setBeginTime(timestamp);
        block10: for (int i = 0; i < types.length(); ++i) {
            String type = types.getString(i);
            double value = values.getDouble(i);
            switch (type) {
                case "temperature": {
                    ret.setTemperature(value);
                    continue block10;
                }
                case "humidity": {
                    ret.setHumidity(value);
                    continue block10;
                }
                case "pressure": {
                    ret.setPressure(value);
                }
            }
        }
        return ret;
    }

    private static Measures parseMeasuresMethod2(JSONObject measuresThisModule) {
        Measures ret = new Measures();
        Iterator iterator = measuresThisModule.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "rain_60min": {
                    ret.setSum_rain_1(measuresThisModule.getDouble(key));
                    break;
                }
                case "rain_24h": {
                    ret.setSum_rain_24(measuresThisModule.getDouble(key));
                    break;
                }
                case "rain_live": {
                    ret.setRain(measuresThisModule.getDouble(key));
                    break;
                }
                case "wind_strength": {
                    ret.setWindStrength(measuresThisModule.getDouble(key));
                    break;
                }
                case "wind_angle": {
                    ret.setWindAngle(measuresThisModule.getDouble(key));
                    break;
                }
                case "gust_strength": {
                    ret.setGustStrength(measuresThisModule.getDouble(key));
                    break;
                }
                case "gust_angle": {
                    ret.setGustAngle(measuresThisModule.getDouble(key));
                    break;
                }
                case "rain_timeutc": 
                case "wind_timeutc": {
                    ret.setBeginTime(measuresThisModule.getLong(key));
                }
            }
        }
        return ret;
    }

    private static List<Module> parseModules(JSONObject modules) {
        ArrayList<Module> ret = new ArrayList<Module>();
        for (String moduleId : modules.keySet()) {
            String moduleType = modules.getString(moduleId);
            Module module = new Module(null, moduleId, moduleType);
            ret.add(module);
        }
        return ret;
    }

    private static Station parseStation(JSONObject data) {
        String id = data.getString("_id");
        JSONObject place = data.getJSONObject("place");
        JSONArray location = place.getJSONArray("location");
        String name = NetatmoUtils.format("%f,%f", location.getDouble(1), location.getDouble(0));
        return new Station(name, id);
    }

    public static String format(String string, Object ... params) {
        return String.format(Locale.US, string, params);
    }
}

