/*
 * Decompiled with CFR 0.152.
 */
package org.loxlylabs.nestedtext;

import org.loxlylabs.nestedtext.Token;

public class NestedTextException
extends RuntimeException {
    private final int line;
    private final int column;

    NestedTextException(String message, int line, int column) {
        super(NestedTextException.getErrorMessage(message, line, column));
        this.line = line;
        this.column = column;
    }

    NestedTextException(String message, Token token) {
        super(NestedTextException.getErrorMessage(message, token.line, token.column));
        this.line = token.line;
        this.column = token.column;
    }

    private static String getErrorMessage(String message, int line, int column) {
        if (column == 0) {
            return String.format("Error at line %d: %s", line, message);
        }
        return String.format("Error at line %d, column %d: %s", line, column, message);
    }

    NestedTextException(String message, Throwable cause) {
        super(message, cause);
        this.line = -1;
        this.column = -1;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

