/*
 * Decompiled with CFR 0.152.
 */
package org.loxlylabs.nestedtext;

import java.io.BufferedReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Stream;
import org.loxlylabs.nestedtext.NestedTextException;
import org.loxlylabs.nestedtext.Token;
import org.loxlylabs.nestedtext.TokenType;

class Scanner {
    private final Deque<Integer> indentStack = new ArrayDeque<Integer>();
    private int current = 0;
    private int lineNumber = 1;
    private String curLine;
    private final Stream<String> lines;

    public Scanner(String source) {
        this(source.lines());
    }

    public Scanner(BufferedReader reader) {
        this(reader.lines());
    }

    public Scanner(Stream<String> lines) {
        this.lines = lines;
        this.indentStack.push(0);
    }

    public List<Token> scanTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.lines.forEach(line -> {
            this.current = 0;
            tokens.addAll(this.processLine((String)line));
            ++this.lineNumber;
        });
        if (!tokens.isEmpty() && ((Token)tokens.getLast()).type == TokenType.NEWLINE) {
            tokens.removeLast();
        }
        while (this.indentStack.size() > 1) {
            tokens.add(this.createToken(TokenType.DEDENT, 0));
            this.indentStack.pop();
        }
        tokens.add(this.createToken(TokenType.EOF, 0));
        return tokens;
    }

    private List<Token> processLine(String line) {
        this.curLine = line;
        List<Token> tokens = this.handleIndentation();
        if (tokens == null) {
            return List.of();
        }
        char c = this.advance();
        List<Token> newTokens = switch (c) {
            case '-' -> this.processListLine();
            case '>' -> this.processMultilineStringLine();
            default -> this.processDictionaryLine();
        };
        tokens.addAll(newTokens);
        tokens.add(this.createToken(TokenType.NEWLINE, this.current + 1));
        return tokens;
    }

    private List<Token> processListLine() {
        int keyStart = this.current;
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (this.peek() == ' ') {
            this.advance();
        }
        tokens.add(this.createToken(TokenType.DASH, keyStart + 1));
        if (!this.isEOL()) {
            tokens.add(this.processString());
        }
        return tokens;
    }

    private List<Token> processMultilineStringLine() {
        int keyStart = this.current;
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (this.peek() == ' ') {
            this.advance();
        }
        tokens.add(this.createToken(TokenType.GREATER, keyStart + 1));
        if (!this.isEOL()) {
            tokens.add(this.processString());
        }
        return tokens;
    }

    private List<Token> processDictionaryLine() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        --this.current;
        tokens.add(this.processKey());
        if (!this.isEOL()) {
            tokens.add(this.processString());
        }
        return tokens;
    }

    private Token processKey() {
        int keyStart = this.current;
        while (!this.isEOL()) {
            if (this.peek() == ':') {
                this.advance();
                if (this.peek() != ' ' && !this.isEOL()) continue;
                String value = this.curLine.substring(keyStart, this.current - 1);
                if (this.peek() == ' ') {
                    this.advance();
                }
                return this.createToken(TokenType.KEY, value.stripTrailing(), keyStart + 1);
            }
            this.advance();
        }
        throw new NestedTextException("Unrecognized line structure, couldn't find a key.", this.lineNumber, keyStart + 1);
    }

    private Token processString() {
        String value = this.curLine.substring(this.current);
        return this.createToken(TokenType.STRING, value, this.current + 1);
    }

    private List<Token> handleIndentation() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int indent = 0;
        while (this.peek() == ' ') {
            ++indent;
            this.advance();
        }
        if (this.peek() == '\t') {
            throw new NestedTextException("Tabs are not allowed for indentation; use spaces instead.", this.lineNumber, this.current + 1);
        }
        if (this.peek() == '#' || this.isEOL()) {
            this.skipLine();
            return null;
        }
        Integer lastIndent = this.indentStack.peek();
        if (indent > lastIndent) {
            this.indentStack.push(indent);
            tokens.add(this.createToken(TokenType.INDENT, 0));
        } else if (indent < lastIndent) {
            if (!this.indentStack.contains(indent)) {
                throw new NestedTextException("Mismatched indentation level.", this.lineNumber, this.current + 1);
            }
            while (indent < this.indentStack.peek()) {
                this.indentStack.pop();
                tokens.add(this.createToken(TokenType.DEDENT, 0));
            }
        }
        return tokens;
    }

    private void skipLine() {
        while (!this.isEOL()) {
            this.advance();
        }
    }

    private boolean isEOL() {
        return this.current >= this.curLine.length();
    }

    private char advance() {
        return this.curLine.charAt(this.current++);
    }

    private char peek() {
        if (this.isEOL()) {
            return '\u0000';
        }
        return this.curLine.charAt(this.current);
    }

    private Token createToken(TokenType type, int column) {
        return this.createToken(type, null, column);
    }

    private Token createToken(TokenType type, Object literal, int column) {
        return new Token(type, literal, this.lineNumber, column);
    }
}

