/*
 * Decompiled with CFR 0.152.
 */
package org.loxlylabs.nestedtext;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.loxlylabs.nestedtext.NestedTextException;
import org.loxlylabs.nestedtext.Token;
import org.loxlylabs.nestedtext.TokenType;

class Parser {
    private final List<Token> tokens;
    private int current = 0;

    public Parser(List<Token> tokens) {
        this.tokens = tokens;
    }

    public Object parse() {
        if (this.isAtEnd() || this.peek().type == TokenType.EOF) {
            return null;
        }
        if (this.check(TokenType.INDENT)) {
            throw new NestedTextException("top-level content must start in column 1.", this.peek().line, 0);
        }
        Object obj = this.parseObject();
        if (!this.isAtEnd()) {
            throw this.error(this.peek(), "expected end of file.");
        }
        return obj;
    }

    private Object parseObject() {
        TokenType nextTok = this.peek().type;
        if (nextTok == TokenType.DASH) {
            return this.parseList();
        }
        if (nextTok == TokenType.GREATER) {
            return this.parseMultilineString();
        }
        if (nextTok == TokenType.KEY) {
            return this.parseDictionary();
        }
        throw this.error(this.peek(), "Unexpected token; expected a list ('-'), dictionary ('key:'), or multiline string ('>').");
    }

    private List<Object> parseList() {
        ArrayList<Object> list = new ArrayList<Object>();
        int expectedIndentation = -1;
        while (this.match(TokenType.DASH)) {
            Object value;
            if (expectedIndentation == -1) {
                expectedIndentation = this.previous().column;
            }
            if (this.check(TokenType.NEWLINE) && this.checkNext(TokenType.INDENT)) {
                this.advance();
                this.advance();
                value = this.parseObject();
                this.consume(TokenType.DEDENT, "invalid indentation.");
            } else if (this.match(TokenType.STRING)) {
                value = this.previous().literal;
                this.match(TokenType.NEWLINE);
            } else {
                value = "";
                this.match(TokenType.NEWLINE);
            }
            list.add(value);
        }
        if (this.check(TokenType.KEY) || this.check(TokenType.GREATER)) {
            throw this.error(this.peek(), "expected list item.");
        }
        if (this.check(TokenType.INDENT)) {
            throw new NestedTextException("invalid indentation.", this.peek().line, expectedIndentation == -1 ? this.peek().column : expectedIndentation);
        }
        return list;
    }

    private Map<String, Object> parseDictionary() {
        LinkedHashMap<String, Object> dictionary = new LinkedHashMap<String, Object>();
        int expectedIndentation = -1;
        while (this.match(TokenType.KEY)) {
            Object value;
            String key;
            if (expectedIndentation == -1) {
                expectedIndentation = this.previous().column;
            }
            if (dictionary.containsKey(key = (String)this.previous().literal)) {
                throw this.error(this.previous(), "duplicate key: " + key + ".");
            }
            if (this.check(TokenType.NEWLINE) && this.checkNext(TokenType.INDENT)) {
                this.advance();
                this.advance();
                value = this.parseObject();
                this.consume(TokenType.DEDENT, "invalid indentation.");
            } else if (this.match(TokenType.STRING)) {
                value = this.previous().literal;
                this.match(TokenType.NEWLINE);
            } else {
                value = "";
                this.match(TokenType.NEWLINE);
            }
            dictionary.put(key, value);
        }
        if (this.check(TokenType.DASH) || this.check(TokenType.GREATER)) {
            throw this.error(this.peek(), "expected dictionary item.");
        }
        if (this.check(TokenType.INDENT)) {
            throw new NestedTextException("invalid indentation.", this.peek().line, expectedIndentation == -1 ? this.peek().column : expectedIndentation);
        }
        return dictionary;
    }

    private String parseMultilineString() {
        StringBuilder sb = new StringBuilder();
        int expectedIndentation = -1;
        boolean start = true;
        while (!this.isAtEnd() && this.peek().type == TokenType.GREATER) {
            if (expectedIndentation == -1) {
                expectedIndentation = this.peek().column;
            }
            if (!start) {
                sb.append("\n");
            }
            start = false;
            this.consume(TokenType.GREATER, "Expect '>' for multiline string line.");
            if (this.check(TokenType.STRING)) {
                sb.append(this.peek().literal);
                this.advance();
            }
            if (this.match(TokenType.NEWLINE)) continue;
        }
        if (this.check(TokenType.DASH) || this.check(TokenType.KEY)) {
            throw this.error(this.peek(), "expected string.");
        }
        if (this.check(TokenType.INDENT)) {
            throw new NestedTextException("invalid indentation.", this.peek().line, expectedIndentation == -1 ? this.peek().column : expectedIndentation);
        }
        return sb.toString();
    }

    private boolean match(TokenType ... types) {
        for (TokenType type : types) {
            if (!this.check(type)) continue;
            this.advance();
            return true;
        }
        return false;
    }

    private Token consume(TokenType type, String message) {
        if (this.check(type)) {
            return this.advance();
        }
        throw this.error(this.peek(), message);
    }

    private boolean check(TokenType type) {
        if (this.isAtEnd()) {
            return false;
        }
        return this.peek().type == type;
    }

    private boolean checkNext(TokenType type) {
        if (this.isAtEnd() || this.current + 1 >= this.tokens.size()) {
            return false;
        }
        return this.peekNext().type == type;
    }

    private Token advance() {
        if (!this.isAtEnd()) {
            ++this.current;
        }
        return this.previous();
    }

    private boolean isAtEnd() {
        return this.peek().type == TokenType.EOF;
    }

    private Token peek() {
        return this.tokens.get(this.current);
    }

    private Token peekNext() {
        if (this.current + 1 >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        return this.tokens.get(this.current + 1);
    }

    private Token previous() {
        return this.tokens.get(this.current - 1);
    }

    private NestedTextException error(Token token, String message) {
        return new NestedTextException(message, token);
    }
}

