/*
 * Decompiled with CFR 0.152.
 */
package org.loxlylabs.nestedtext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.RecordComponent;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.loxlylabs.nestedtext.NestedTextException;
import org.loxlylabs.nestedtext.Parser;
import org.loxlylabs.nestedtext.Scanner;
import org.loxlylabs.nestedtext.Token;

public class NestedText {
    private final Map<Class<?>, Adapter<?>> adapters = new HashMap();
    private String eol = System.lineSeparator();
    private int indentAmount = 4;
    private boolean useReflection = true;

    public <T> NestedText registerAdapter(Class<T> type, Adapter<T> adapter) {
        this.adapters.put(type, adapter);
        return this;
    }

    public NestedText indent(int numSpaces) {
        this.indentAmount = numSpaces;
        return this;
    }

    public NestedText lineSeparator(String lineSeparator) {
        this.eol = lineSeparator;
        return this;
    }

    public NestedText useReflection(boolean useReflection) {
        this.useReflection = useReflection;
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object load(File file) throws IOException {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try (FileInputStream is = new FileInputStream(file);){
            Object object;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, decoder));){
                object = this.load(reader.lines());
            }
            return object;
        }
        catch (MalformedInputException ex) {
            int col = ex.getInputLength();
            throw new NestedTextException("invalid start byte", (Throwable)ex, 0, col);
        }
    }

    public Object load(Path path) throws IOException {
        return this.load(path.toFile());
    }

    public Object load(byte[] data) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            String text = decoder.decode(ByteBuffer.wrap(data)).toString();
            return this.load(text);
        }
        catch (CharacterCodingException e) {
            int n;
            if (e instanceof MalformedInputException) {
                MalformedInputException mal = (MalformedInputException)e;
                n = mal.getInputLength();
            } else {
                n = 0;
            }
            int col = n;
            throw new NestedTextException("invalid start byte", (Throwable)e, 0, col);
        }
    }

    public Object load(String contents) {
        return this.load(contents.lines());
    }

    private Object load(Stream<String> lines) {
        Scanner scanner = new Scanner(lines);
        List<Token> tokens = scanner.scanTokens();
        Parser parser = new Parser(tokens);
        return parser.parse();
    }

    public String dump(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (this.useReflection) {
            obj = this.toNestedTextCompatible(obj);
        }
        this.dumpValue(obj, sb, 0);
        this.removeLastLineSeparator(sb);
        return sb.toString();
    }

    private void removeLastLineSeparator(StringBuilder sb) {
        if (sb.length() >= this.eol.length()) {
            int startOfSeparator = sb.length() - this.eol.length();
            for (int i = 0; i < this.eol.length(); ++i) {
                if (sb.charAt(startOfSeparator + i) == this.eol.charAt(i)) continue;
                return;
            }
            sb.setLength(startOfSeparator);
        }
    }

    private <T> Object applyAdapter(Class<T> type, Object value) {
        Adapter<?> adapter = this.adapters.get(type);
        return adapter.toNestedTextValue(value);
    }

    private Object toNestedTextCompatible(Object o) {
        Object object = o;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Boolean.class, Number.class, Enum.class, Character.class, Map.class, Collection.class}, (Object)object, n)) {
            case -1 -> {
                String var4_4 = null;
                yield var4_4;
            }
            case 0 -> {
                String s;
                String var4_5 = s = (String)object;
                yield var4_5;
            }
            case 1 -> {
                Boolean b = (Boolean)object;
                String var4_6 = b.toString();
                yield var4_6;
            }
            case 2 -> {
                Number n = (Number)object;
                String var4_7 = n.toString();
                yield var4_7;
            }
            case 3 -> {
                Enum e = (Enum)object;
                String var4_8 = e.name();
                yield var4_8;
            }
            case 4 -> {
                Character c = (Character)object;
                String var4_9 = c.toString();
                yield var4_9;
            }
            case 5 -> {
                LinkedHashMap<String, Object> var4_10;
                Map m = (Map)object;
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                for (Map.Entry e : m.entrySet()) {
                    result.put(String.valueOf(e.getKey()), this.toNestedTextCompatible(e.getValue()));
                }
                yield var4_10 = result;
            }
            case 6 -> {
                Collection l = (Collection)object;
                List<Object> var4_11 = l.stream().map(this::toNestedTextCompatible).toList();
                yield var4_11;
            }
            default -> {
                if (this.adapters.containsKey(o.getClass())) {
                    Object var4_12 = this.applyAdapter(o.getClass(), o);
                    yield var4_12;
                }
                if (o.getClass().isArray()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    int length = Array.getLength(o);
                    for (int i = 0; i < length; ++i) {
                        list.add(this.toNestedTextCompatible(Array.get(o, i)));
                    }
                    ArrayList<Object> var4_13 = list;
                    yield var4_13;
                }
                if (o.getClass().isRecord()) {
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    for (RecordComponent comp : o.getClass().getRecordComponents()) {
                        try {
                            Object value = comp.getAccessor().invoke(o, new Object[0]);
                            map.put(comp.getName(), this.toNestedTextCompatible(value));
                        }
                        catch (Exception e) {
                            throw new NestedTextException("Failed to serialize field '" + comp.getName() + "' from object of type " + o.getClass().getSimpleName(), e);
                        }
                    }
                    LinkedHashMap<String, Object> var4_14 = map;
                    yield var4_14;
                }
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (Field field : o.getClass().getDeclaredFields()) {
                    try {
                        field.setAccessible(true);
                        Object value = field.get(o);
                        map.put(field.getName(), this.toNestedTextCompatible(value));
                    }
                    catch (Exception e) {
                        throw new NestedTextException("Failed to serialize field '" + field.getName() + "' from object of type " + o.getClass().getSimpleName(), e);
                    }
                }
                LinkedHashMap<String, Object> var4_15 = map;
                yield var4_15;
            }
        };
    }

    private void dumpValue(Object obj, StringBuilder sb, int indent) {
        Object object = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Map.class, Collection.class}, (Object)object, n)) {
            case -1: {
                break;
            }
            case 0: {
                String s = (String)object;
                this.dumpString(s, sb, indent);
                break;
            }
            case 1: {
                Map m = (Map)object;
                this.dumpMap(m, sb, indent);
                break;
            }
            case 2: {
                Collection l = (Collection)object;
                this.dumpList(l, sb, indent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type for NestedText dump: " + String.valueOf(obj.getClass()));
            }
        }
    }

    private void dumpString(String s, StringBuilder sb, int indent) {
        String indentStr = " ".repeat(indent);
        if (s.contains(this.eol)) {
            String[] lines;
            for (String line : lines = s.split(this.eol, -1)) {
                sb.append(indentStr).append(">");
                if (!line.isEmpty()) {
                    sb.append(" ");
                }
                sb.append(line).append(this.eol);
            }
        } else {
            if (indent == 0) {
                sb.append("> ");
            }
            sb.append(indentStr).append(s).append(this.eol);
        }
    }

    private void dumpMap(Map<?, ?> m, StringBuilder sb, int indent) {
        String indentStr = " ".repeat(indent);
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            String s;
            String key = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof String && !(s = (String)value).contains(this.eol)) {
                sb.append(indentStr).append(key).append(": ").append(s).append(this.eol);
                continue;
            }
            sb.append(indentStr).append(key).append(":").append(this.eol);
            this.dumpValue(value, sb, indent + this.indentAmount);
        }
    }

    private void dumpList(Collection<?> collection, StringBuilder sb, int indent) {
        String indentStr = " ".repeat(indent);
        for (Object item : collection) {
            String s;
            if (item instanceof String && !(s = (String)item).contains(this.eol)) {
                sb.append(indentStr).append("- ").append(s).append(this.eol);
                continue;
            }
            sb.append(indentStr).append("-").append(this.eol);
            this.dumpValue(item, sb, indent + this.indentAmount);
        }
    }

    @FunctionalInterface
    public static interface Adapter<T> {
        public Object toNestedTextValue(T var1);
    }
}

