/*
 * Decompiled with CFR 0.152.
 */
package org.loxlylabs.nestedtext;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.loxlylabs.nestedtext.DeserializationException;
import org.loxlylabs.nestedtext.Deserializer;
import org.loxlylabs.nestedtext.TypeReference;

public class DeserializationContext {
    private final Map<Class<?>, Deserializer<?>> customDeserializers;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Void.TYPE, Void.class);
    private static final Map<Class<?>, Function<String, ?>> STRING_CONVERTERS = Map.ofEntries(Map.entry(String.class, s -> s), Map.entry(Integer.class, Integer::valueOf), Map.entry(Long.class, Long::valueOf), Map.entry(Double.class, Double::valueOf), Map.entry(Float.class, Float::valueOf), Map.entry(Short.class, Short::valueOf), Map.entry(Byte.class, Byte::valueOf), Map.entry(BigDecimal.class, BigDecimal::new), Map.entry(BigInteger.class, BigInteger::new), Map.entry(UUID.class, UUID::fromString), Map.entry(Boolean.class, Boolean::parseBoolean), Map.entry(LocalDate.class, LocalDate::parse), Map.entry(LocalTime.class, LocalTime::parse), Map.entry(LocalDateTime.class, LocalDateTime::parse), Map.entry(Instant.class, Instant::parse), Map.entry(ZonedDateTime.class, ZonedDateTime::parse), Map.entry(Duration.class, Duration::parse), Map.entry(Period.class, Period::parse));

    public DeserializationContext() {
        this.customDeserializers = new HashMap();
    }

    public DeserializationContext(Map<Class<?>, Deserializer<?>> customDeserializers) {
        this.customDeserializers = new HashMap(customDeserializers);
    }

    public <T> T convert(Object source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        return this.convertRecursively(source, targetClass, null);
    }

    public <T> T convert(Object source, TypeReference<T> typeRef) {
        Class rawClass;
        if (source == null) {
            return null;
        }
        Type targetType = typeRef.getType();
        if (targetType instanceof Class) {
            rawClass = (Class)targetType;
        } else if (targetType instanceof ParameterizedType) {
            rawClass = (Class)((ParameterizedType)targetType).getRawType();
        } else {
            throw new DeserializationException("Unsupported type reference: " + String.valueOf(targetType));
        }
        return this.convertRecursively(source, rawClass, targetType);
    }

    private <T> T convertRecursively(Object source, Class<T> targetClass, Type genericType) {
        String s;
        T convertedFromString;
        String str;
        if (source == null) {
            return null;
        }
        if (this.customDeserializers.containsKey(targetClass)) {
            return (T)this.customDeserializers.get(targetClass).deserialize(source, this);
        }
        if (source instanceof String && (str = (String)source).isEmpty()) {
            if (List.class.isAssignableFrom(targetClass) || Collection.class.isAssignableFrom(targetClass)) {
                return (T)Collections.emptyList();
            }
            if (Map.class.isAssignableFrom(targetClass)) {
                return (T)Collections.emptyMap();
            }
            if (targetClass != String.class && !targetClass.isPrimitive()) {
                return null;
            }
        }
        if (source instanceof String && (convertedFromString = this.convertFromString(s = (String)source, targetClass)) != null) {
            return convertedFromString;
        }
        if (source instanceof Map) {
            Map sourceMap = (Map)source;
            if (Map.class.isAssignableFrom(targetClass)) {
                return (T)this.convertMapToMap(sourceMap, genericType);
            }
            return this.convertMapToObject(sourceMap, targetClass);
        }
        if (source instanceof List) {
            List sourceList = (List)source;
            if (targetClass.isArray()) {
                return (T)this.convertListToArray(sourceList, targetClass);
            }
            if (Collection.class.isAssignableFrom(targetClass)) {
                return (T)this.convertListToCollection(sourceList, targetClass, genericType);
            }
        }
        throw new DeserializationException("Cannot convert from " + source.getClass().getName() + " to " + targetClass.getName() + ". No direct mapping or custom deserializer found.");
    }

    private Map<?, ?> convertMapToMap(Map<String, Object> sourceMap, Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            throw new DeserializationException("Cannot convert to Map without generic type information: " + String.valueOf(genericType));
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        Type keyType = typeArguments[0];
        Type valueType = typeArguments[1];
        LinkedHashMap newMap = new LinkedHashMap();
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            Object convertedKey = this.convertRecursively(entry.getKey(), (Class)keyType, keyType);
            Object convertedValue = this.convertRecursively(entry.getValue(), (Class)(valueType instanceof ParameterizedType ? ((ParameterizedType)valueType).getRawType() : valueType), valueType);
            newMap.put(convertedKey, convertedValue);
        }
        return newMap;
    }

    private <T> T convertMapToObject(Map<String, Object> sourceMap, Class<T> targetClass) {
        try {
            if (targetClass.isRecord()) {
                return this.convertMapToRecord(sourceMap, targetClass);
            }
            return this.convertMapToPojo(sourceMap, targetClass);
        }
        catch (Exception e) {
            throw new DeserializationException("Failed to convert Map to " + targetClass.getName(), e);
        }
    }

    private <T> T convertFromString(String s, Class<T> targetClass) {
        Class<T> effectiveTargetClass = targetClass.isPrimitive() ? PRIMITIVE_WRAPPER_MAP.get(targetClass) : targetClass;
        Function<String, ?> converter = STRING_CONVERTERS.get(effectiveTargetClass);
        try {
            if (converter != null) {
                return (T)converter.apply(s);
            }
            if (effectiveTargetClass.isEnum()) {
                return Enum.valueOf(effectiveTargetClass, s);
            }
        }
        catch (Exception e) {
            throw new DeserializationException("Failed to parse string '" + s + "' into type " + targetClass.getName(), e);
        }
        return null;
    }

    private <T> T convertMapToRecord(Map<String, Object> sourceMap, Class<T> recordClass) throws Exception {
        RecordComponent[] components = recordClass.getRecordComponents();
        Object[] constructorArgs = new Object[components.length];
        Class[] constructorParamTypes = new Class[components.length];
        for (int i = 0; i < components.length; ++i) {
            RecordComponent component = components[i];
            String name = component.getName();
            Class<?> type = component.getType();
            Type genericType = component.getGenericType();
            constructorParamTypes[i] = type;
            Object value = sourceMap.get(name);
            constructorArgs[i] = this.convertRecursively(value, type, genericType);
        }
        Constructor<T> constructor = recordClass.getDeclaredConstructor(constructorParamTypes);
        return constructor.newInstance(constructorArgs);
    }

    private <T> T convertMapToPojo(Map<String, Object> sourceMap, Class<T> pojoClass) throws Exception {
        Constructor<T> constructor = pojoClass.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        T instance = constructor.newInstance(new Object[0]);
        for (Field field : pojoClass.getDeclaredFields()) {
            if (!sourceMap.containsKey(field.getName())) continue;
            field.setAccessible(true);
            Object value = sourceMap.get(field.getName());
            Object convertedValue = this.convertRecursively(value, field.getType(), field.getGenericType());
            field.set(instance, convertedValue);
        }
        return instance;
    }

    private Collection<?> convertListToCollection(List<?> sourceList, Class<? extends Collection> targetClass, Type genericType) {
        AbstractCollection newCollection;
        if (!(genericType instanceof ParameterizedType)) {
            throw new DeserializationException("Cannot convert to list without generic type information: " + targetClass.getName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type itemGenericType = parameterizedType.getActualTypeArguments()[0];
        Class<?> itemRawClass = DeserializationContext.getListRawClass(itemGenericType);
        if (targetClass.isAssignableFrom(ArrayList.class)) {
            newCollection = new ArrayList();
        } else if (targetClass.isAssignableFrom(HashSet.class)) {
            newCollection = new HashSet();
        } else {
            throw new DeserializationException("Unsupported collection type: " + targetClass.getName());
        }
        for (Object item : sourceList) {
            newCollection.add(this.convertRecursively(item, itemRawClass, itemGenericType));
        }
        return newCollection;
    }

    private static Class<?> getListRawClass(Type itemGenericType) {
        if (itemGenericType instanceof Class) {
            Class clazz = (Class)itemGenericType;
            return clazz;
        }
        if (itemGenericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)itemGenericType;
            return (Class)pType.getRawType();
        }
        throw new DeserializationException("Unsupported generic type in List: " + itemGenericType.getTypeName());
    }

    private Object[] convertListToArray(List<?> sourceList, Class<?> targetArrayClass) {
        Class<?> componentType = targetArrayClass.getComponentType();
        Object[] newArray = (Object[])Array.newInstance(componentType, sourceList.size());
        for (int i = 0; i < sourceList.size(); ++i) {
            newArray[i] = this.convertRecursively(sourceList.get(i), componentType, null);
        }
        return newArray;
    }
}

