/*
 * Decompiled with CFR 0.152.
 */
package org.loxlylabs.nestedtext;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.loxlylabs.nestedtext.DeserializationContext;
import org.loxlylabs.nestedtext.Deserializer;
import org.loxlylabs.nestedtext.DumpOptions;
import org.loxlylabs.nestedtext.NestedTextException;
import org.loxlylabs.nestedtext.NestedTextSerializer;
import org.loxlylabs.nestedtext.Parser;
import org.loxlylabs.nestedtext.Scanner;
import org.loxlylabs.nestedtext.Serializer;
import org.loxlylabs.nestedtext.Token;
import org.loxlylabs.nestedtext.TypeReference;

public class NestedText {
    private final Map<Class<?>, Deserializer<?>> deserializers = new HashMap();
    private final Map<Class<?>, Serializer<?>> serializers = new HashMap();

    public <T> NestedText registerDeserializer(Class<T> type, Deserializer<T> deserializer) {
        this.deserializers.put(type, deserializer);
        return this;
    }

    public <T> NestedText registerSerializer(Class<T> type, Serializer<T> serializer) {
        this.serializers.put(type, serializer);
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object load(Path path) throws IOException {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try (FileInputStream is = new FileInputStream(path.toFile());){
            Object object;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, decoder));){
                object = this.load(reader.lines());
            }
            return object;
        }
        catch (MalformedInputException ex) {
            int col = ex.getInputLength();
            throw new NestedTextException("invalid start byte", (Throwable)ex, 0, col);
        }
    }

    public <T> T load(Path path, Class<T> type) throws IOException {
        Object obj = this.load(path);
        return new DeserializationContext(this.deserializers).convert(obj, type);
    }

    public <T> T load(Path path, TypeReference<T> typeRef) throws IOException {
        Object obj = this.load(path);
        return new DeserializationContext(this.deserializers).convert(obj, typeRef);
    }

    public Object load(byte[] data) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            String text = decoder.decode(ByteBuffer.wrap(data)).toString();
            return this.load(text);
        }
        catch (CharacterCodingException e) {
            int n;
            if (e instanceof MalformedInputException) {
                MalformedInputException mal = (MalformedInputException)e;
                n = mal.getInputLength();
            } else {
                n = 0;
            }
            int col = n;
            throw new NestedTextException("invalid start byte", (Throwable)e, 0, col);
        }
    }

    public <T> T load(byte[] data, Class<T> type) {
        Object obj = this.load(data);
        return new DeserializationContext(this.deserializers).convert(obj, type);
    }

    public <T> T load(byte[] data, TypeReference<T> typeRef) {
        Object obj = this.load(data);
        return new DeserializationContext(this.deserializers).convert(obj, typeRef);
    }

    public Object load(String contents) {
        return this.load(contents.lines());
    }

    public <T> T load(String contents, Class<T> type) {
        Object obj = this.load(contents);
        return new DeserializationContext(this.deserializers).convert(obj, type);
    }

    public <T> T load(String contents, TypeReference<T> typeRef) {
        Object obj = this.load(contents);
        return new DeserializationContext(this.deserializers).convert(obj, typeRef);
    }

    private Object load(Stream<String> lines) {
        Scanner scanner = new Scanner(lines);
        List<Token> tokens = scanner.scanTokens();
        Parser parser = new Parser(tokens);
        return parser.parse();
    }

    public String dump(Object obj) {
        return this.dump(obj, new DumpOptions(System.lineSeparator(), 4, true));
    }

    public String dump(Object obj, DumpOptions options) {
        NestedTextSerializer serializer = new NestedTextSerializer(options, this.serializers);
        return serializer.serialize(obj);
    }
}

