/*
 * Decompiled with CFR 0.152.
 */
package org.loxlylabs.nestedtext;

import java.io.BufferedReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.stream.Stream;
import org.loxlylabs.nestedtext.NestedTextException;
import org.loxlylabs.nestedtext.Token;
import org.loxlylabs.nestedtext.TokenType;

class Scanner {
    private final Deque<Integer> indentStack = new ArrayDeque<Integer>();
    private int current = 0;
    private int lineNumber = 1;
    private String curLine;
    private final Stream<String> lines;

    public Scanner(String source) {
        this(source.lines());
    }

    public Scanner(BufferedReader reader) {
        this(reader.lines());
    }

    public Scanner(Stream<String> lines) {
        this.lines = lines;
        this.indentStack.push(0);
    }

    public List<Token> scanTokens() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.lines.forEach(line -> {
            this.current = 0;
            tokens.addAll(this.processLine((String)line));
            ++this.lineNumber;
        });
        if (!tokens.isEmpty() && ((Token)tokens.getLast()).type == TokenType.NEWLINE) {
            tokens.removeLast();
        }
        while (this.indentStack.size() > 1) {
            tokens.add(this.createToken(TokenType.DEDENT, 0));
            this.indentStack.pop();
        }
        tokens.add(this.createToken(TokenType.EOF, 0));
        return tokens;
    }

    private List<Token> processLine(String line) {
        this.curLine = line;
        List<Token> tokens = this.handleIndentation();
        if (tokens == null) {
            return List.of();
        }
        char c = this.advance();
        List<Token> newTokens = switch (c) {
            case '-' -> this.processListLine();
            case '>' -> this.processMultilineStringLine();
            default -> this.processDictionaryLine();
        };
        tokens.addAll(newTokens);
        tokens.add(this.createToken(TokenType.NEWLINE, this.current));
        return tokens;
    }

    private List<Token> processListLine() {
        int keyStart = this.current - 1;
        if (this.peek() == ' ') {
            this.advance();
        } else if (!this.isEOL()) {
            return this.processDictionaryLine();
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        tokens.add(this.createToken(TokenType.DASH, keyStart));
        if (!this.isEOL()) {
            tokens.add(this.processString());
        }
        return tokens;
    }

    private List<Token> processMultilineStringLine() {
        int keyStart = this.current - 1;
        if (this.peek() == ' ') {
            this.advance();
        } else if (!this.isEOL()) {
            return this.processDictionaryLine();
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        tokens.add(this.createToken(TokenType.GREATER, keyStart));
        if (!this.isEOL()) {
            tokens.add(this.processString());
        }
        return tokens;
    }

    private List<Token> processDictionaryLine() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        --this.current;
        tokens.add(this.processKey());
        if (!this.isEOL()) {
            tokens.add(this.processString());
        }
        return tokens;
    }

    private static String stripTrailingWhitespace(String s) {
        int end;
        for (end = s.length(); end > 0 && Scanner.isWhitespace(s.charAt(end - 1)); --end) {
        }
        return s.substring(0, end);
    }

    private static boolean isWhitespace(int c) {
        return Character.getType(c) == 12 || Character.isWhitespace(c);
    }

    private Token processKey() {
        int keyStart = this.current;
        while (!this.isEOL()) {
            if (this.peek() == ':') {
                char firstChar;
                this.advance();
                if (this.peek() != ' ' && !this.isEOL()) continue;
                String value = this.curLine.substring(keyStart, this.current - 1);
                if (this.peek() == ' ') {
                    this.advance();
                }
                if (!(value.isEmpty() || (firstChar = value.charAt(0)) != '[' && firstChar != '{')) {
                    throw new NestedTextException("key may not start with '" + firstChar + "'.", this.lineNumber - 1, keyStart);
                }
                return this.createToken(TokenType.KEY, Scanner.stripTrailingWhitespace(value), keyStart);
            }
            this.advance();
        }
        throw new NestedTextException("unrecognized line.", this.lineNumber - 1, keyStart);
    }

    private Token processString() {
        String value = this.curLine.substring(this.current);
        return this.createToken(TokenType.STRING, value, this.current);
    }

    private String whiteSpaceToString(char c) {
        return switch (c) {
            case '\t' -> "'\\t'";
            case '\u00a0' -> "'\\xa0' (NO-BREAK SPACE)";
            case '\u1680' -> "'\\u1680' (OGHAM SPACE MARK)";
            case '\u2000' -> "'\\u2000' (EN QUAD)";
            case '\u2001' -> "'\\u2001' (EM QUAD)";
            case '\u2002' -> "'\\u2002' (EN SPACE)";
            case '\u2003' -> "'\\u2003' (EM SPACE)";
            case '\u2004' -> "'\\u2004' (THREE-PER-EM SPACE)";
            case '\u2005' -> "'\\u2005' (FOUR-PER-EM SPACE)";
            case '\u2006' -> "'\\u2006' (SIX-PER-EM SPACE)";
            case '\u2007' -> "'\\u2007' (FIGURE SPACE)";
            case '\u2008' -> "'\\u2008' (PUNCTUATION SPACE)";
            case '\u2009' -> "'\\u2009' (THIN SPACE)";
            case '\u200a' -> "'\\u200A' (HAIR SPACE)";
            case '\u202f' -> "'\\u202F' (NARROW NO-BREAK SPACE)";
            case '\u205f' -> "'\\u205F' (MEDIUM MATHEMATICAL SPACE)";
            case '\u3000' -> "'\\u3000' (IDEOGRAPHIC SPACE)";
            default -> Character.isWhitespace(c) ? String.format("'\\u%04X' (WHITESPACE)", c) : String.format("'\\u%04X'", c);
        };
    }

    private List<Token> handleIndentation() {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int indent = 0;
        while (this.peek() == ' ') {
            ++indent;
            this.advance();
        }
        if (Scanner.isWhitespace(this.peek())) {
            throw new NestedTextException("invalid character in indentation: " + this.whiteSpaceToString(this.peek()) + ".", this.lineNumber - 1, this.current);
        }
        if (this.peek() == '#' || this.isEOL()) {
            this.skipLine();
            return null;
        }
        Integer lastIndent = this.indentStack.peek();
        if (indent > lastIndent) {
            this.indentStack.push(indent);
            tokens.add(this.createToken(TokenType.INDENT, indent));
        } else if (indent < lastIndent) {
            if (!this.indentStack.contains(indent)) {
                throw new NestedTextException("invalid indentation, partial dedent.", this.lineNumber - 1, 0);
            }
            while (indent < this.indentStack.peek()) {
                this.indentStack.pop();
                tokens.add(this.createToken(TokenType.DEDENT, 0));
            }
        }
        return tokens;
    }

    private void skipLine() {
        while (!this.isEOL()) {
            this.advance();
        }
    }

    private boolean isEOL() {
        return this.current >= this.curLine.length();
    }

    private char advance() {
        return this.curLine.charAt(this.current++);
    }

    private char peek() {
        if (this.isEOL()) {
            return '\u0000';
        }
        return this.curLine.charAt(this.current);
    }

    private Token createToken(TokenType type, int column) {
        return this.createToken(type, null, column);
    }

    private Token createToken(TokenType type, Object literal, int column) {
        return new Token(type, literal, this.lineNumber - 1, column);
    }
}

