/*
 * Decompiled with CFR 0.152.
 */
package org.loxlylabs.nestedtext;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.loxlylabs.nestedtext.DeserializationContext;
import org.loxlylabs.nestedtext.Deserializer;
import org.loxlylabs.nestedtext.DumpOptions;
import org.loxlylabs.nestedtext.NestedTextException;
import org.loxlylabs.nestedtext.Parser;
import org.loxlylabs.nestedtext.Scanner;
import org.loxlylabs.nestedtext.SerializationContext;
import org.loxlylabs.nestedtext.Serializer;
import org.loxlylabs.nestedtext.Token;
import org.loxlylabs.nestedtext.TypeMappingRules;
import org.loxlylabs.nestedtext.TypeReference;

public class NestedText {
    private final Map<Class<?>, Deserializer<?>> deserializers;
    private final Map<Class<?>, Serializer<?>> serializers;
    private final Map<Class<?>, TypeMappingRules> typeMappingRules;
    private final String endOfLine;
    private final int indentAmount;

    private NestedText(Builder builder) {
        this.deserializers = Map.copyOf(builder.deserializers);
        this.serializers = Map.copyOf(builder.serializers);
        this.typeMappingRules = Map.copyOf(builder.typeMappingRules);
        this.endOfLine = builder.defaultEol;
        this.indentAmount = builder.defaultIndentAmount;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Reader from(Path path) throws IOException {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try (FileInputStream is = new FileInputStream(path.toFile());){
            Reader reader;
            try (BufferedReader reader2 = new BufferedReader(new InputStreamReader((InputStream)is, decoder));){
                reader = new Reader(this.load(reader2.lines()));
            }
            return reader;
        }
        catch (MalformedInputException ex) {
            int col = ex.getInputLength();
            throw new NestedTextException("invalid start byte", (Throwable)ex, 0, col);
        }
    }

    public Reader from(byte[] data) {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            String text = decoder.decode(ByteBuffer.wrap(data)).toString();
            return this.from(text);
        }
        catch (CharacterCodingException e) {
            int n;
            if (e instanceof MalformedInputException) {
                MalformedInputException mal = (MalformedInputException)e;
                n = mal.getInputLength();
            } else {
                n = 0;
            }
            int col = n;
            throw new NestedTextException("invalid start byte", (Throwable)e, 0, col);
        }
    }

    public Reader from(String contents) {
        return new Reader(this.load(contents.lines()));
    }

    private Object load(Stream<String> lines) {
        Scanner scanner = new Scanner(lines);
        List<Token> tokens = scanner.scanTokens();
        Parser parser = new Parser(tokens);
        return parser.parse();
    }

    public String dump(Object obj) {
        return this.dump(obj, new DumpOptions(this.endOfLine, this.indentAmount));
    }

    public String dump(Object obj, DumpOptions options) {
        SerializationContext serializer = new SerializationContext(options, this.serializers, this.typeMappingRules);
        return serializer.serialize(obj);
    }

    public static class Builder {
        private final Map<Class<?>, Deserializer<?>> deserializers = new HashMap();
        private final Map<Class<?>, Serializer<?>> serializers = new HashMap();
        private final Map<Class<?>, TypeMappingRules> typeMappingRules = new HashMap();
        private String defaultEol = System.lineSeparator();
        private int defaultIndentAmount = 4;

        Builder() {
        }

        public <T> Builder registerDeserializer(Class<T> type, Deserializer<T> deserializer) {
            this.deserializers.put(type, deserializer);
            return this;
        }

        public <T> Builder registerSerializer(Class<T> type, Serializer<T> serializer) {
            this.serializers.put(type, serializer);
            return this;
        }

        public <T> Builder forType(Class<T> type, Consumer<TypeConfiguration<T>> config) {
            TypeMappingRules rules = this.typeMappingRules.computeIfAbsent(type, k -> new TypeMappingRules());
            TypeConfiguration typeConfig = new TypeConfiguration(rules);
            config.accept(typeConfig);
            return this;
        }

        public Builder endOfLine(String eol) {
            this.defaultEol = eol;
            return this;
        }

        public Builder indentAmount(int indent) {
            if (indent <= 0) {
                throw new IllegalArgumentException("Indent amount must be positive.");
            }
            this.defaultIndentAmount = indent;
            return this;
        }

        public NestedText build() {
            return new NestedText(this);
        }
    }

    public final class Reader {
        private final Object source;

        private Reader(Object source) {
            this.source = source;
        }

        public <T> T as(Class<T> targetClass) {
            return new DeserializationContext(NestedText.this.deserializers, NestedText.this.typeMappingRules).convert(this.source, targetClass);
        }

        public <T> T as(TypeReference<T> typeRef) {
            return new DeserializationContext(NestedText.this.deserializers, NestedText.this.typeMappingRules).convert(this.source, typeRef);
        }

        public Object asObject() {
            return this.source;
        }
    }

    public static class Renamer {
        private final String fromField;
        private final TypeMappingRules rules;

        Renamer(String fromField, TypeMappingRules rules) {
            this.fromField = fromField;
            this.rules = rules;
        }

        public void to(String toField) {
            this.rules.renameFromJava().put(this.fromField, toField);
            this.rules.renameTo().put(toField, this.fromField);
        }
    }

    public static class TypeConfiguration<T> {
        private final TypeMappingRules rules;

        private TypeConfiguration(TypeMappingRules rules) {
            this.rules = rules;
        }

        public TypeConfiguration<T> ignoreField(String fieldName) {
            this.rules.fieldsToIgnore().add(fieldName);
            return this;
        }

        public TypeConfiguration<T> ignoreFieldWhenNull(String fieldName) {
            this.rules.fieldsToIgnoreWhenNull().add(fieldName);
            return this;
        }

        public Renamer renameField(String fieldName) {
            return new Renamer(fieldName, this.rules);
        }
    }
}

