/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import org.luaj.vm.LString;

public class LBuffer {
    private byte[] bytes;
    private int length;

    public LBuffer(int n) {
        this.bytes = new byte[n];
        this.length = 0;
    }

    public void append(byte by) {
        this.ensureCapacity(this.length + 1);
        this.bytes[this.length++] = by;
    }

    public void append(LString lString) {
        int n = lString.length();
        this.ensureCapacity(this.length + n);
        lString.copyInto(0, this.bytes, this.length, n);
        this.length += n;
    }

    public void append(String string) {
        int n = LString.lengthAsUtf8(string);
        this.ensureCapacity(this.length + n);
        LString.encodeToUtf8(string, this.bytes, this.length);
        this.length += n;
    }

    public void setLength(int n) {
        this.ensureCapacity(n);
        this.length = n;
    }

    public LString toLuaString() {
        return new LString(LBuffer.realloc(this.bytes, this.length));
    }

    public void ensureCapacity(int n) {
        if (n > this.bytes.length) {
            this.realloc(n);
        }
    }

    private void realloc(int n) {
        this.bytes = LBuffer.realloc(this.bytes, Math.max(this.bytes.length * 2, n));
    }

    private static byte[] realloc(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }
}

