/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import java.util.Random;
import org.luaj.lib.PackageLib;
import org.luaj.vm.LDouble;
import org.luaj.vm.LFunction;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;
import org.luaj.vm.Platform;

public class MathLib
extends LFunction {
    public static final String[] NAMES = new String[]{"math", "max", "min", "modf", "ceil", "floor", "frexp", "ldexp", "random", "randomseed", "atan2", "fmod", "pow", "abs", "acos", "asin", "atan", "cos", "cosh", "deg", "exp", "log", "log10", "rad", "sin", "sinh", "sqrt", "tan", "tanh"};
    private static final int INSTALL = 0;
    public static final int MAX = 1;
    public static final int MIN = 2;
    public static final int MODF = 3;
    public static final int CEIL = 4;
    public static final int FLOOR = 5;
    public static final int FREXP = 6;
    public static final int LDEXP = 7;
    public static final int RANDOM = 8;
    public static final int RSEED = 9;
    public static final int LAST_IRREGULAR = 9;
    public static final int ATAN2 = 10;
    public static final int FMOD = 11;
    public static final int POW = 12;
    public static final int LAST_DOUBLE_ARG = 12;
    public static final int ABS = 13;
    public static final int ACOS = 14;
    public static final int ASIN = 15;
    public static final int ATAN = 16;
    public static final int COS = 17;
    public static final int COSH = 18;
    public static final int DEG = 19;
    public static final int EXP = 20;
    public static final int LOG = 21;
    public static final int LOG10 = 22;
    public static final int RAD = 23;
    public static final int SIN = 24;
    public static final int SINH = 25;
    public static final int SQRT = 26;
    public static final int TAN = 27;
    public static final int TANH = 28;
    private static Platform platform;
    private static Random random;
    private final int id;

    public static void install(LTable lTable) {
        LTable lTable2 = new LTable();
        for (int i = 1; i < NAMES.length; ++i) {
            lTable2.put(NAMES[i], (LValue)new MathLib(i));
        }
        lTable2.put("huge", (LValue)new LDouble(Double.MAX_VALUE));
        lTable2.put("pi", (LValue)new LDouble(Math.PI));
        lTable.put("math", (LValue)lTable2);
        PackageLib.setIsLoaded("math", lTable2);
        platform = Platform.getInstance();
    }

    private MathLib(int n) {
        this.id = n;
    }

    public String toString() {
        return NAMES[this.id] + "()";
    }

    private static void setResult(LuaState luaState, double d) {
        luaState.resettop();
        luaState.pushlvalue(LDouble.numberOf(d));
    }

    public int invoke(LuaState luaState) {
        if (this.id > 12) {
            luaState.pushlvalue(platform.mathop(this.id, luaState.checknumber(1)));
            return 1;
        }
        if (this.id > 9) {
            luaState.pushlvalue(platform.mathop(this.id, luaState.checknumber(1), luaState.checknumber(2)));
            return 1;
        }
        switch (this.id) {
            case 0: {
                MathLib.install(luaState._G);
                return 0;
            }
            case 1: {
                int n = luaState.gettop();
                double d = luaState.checkdouble(1);
                for (int i = 2; i <= n; ++i) {
                    d = Math.max(d, luaState.checkdouble(i));
                }
                luaState.pushnumber(d);
                return 1;
            }
            case 2: {
                int n = luaState.gettop();
                double d = luaState.checkdouble(1);
                for (int i = 2; i <= n; ++i) {
                    d = Math.min(d, luaState.checkdouble(i));
                }
                luaState.pushnumber(d);
                return 1;
            }
            case 3: {
                double d = luaState.checkdouble(1);
                double d2 = d > 0.0 ? Math.floor(d) : Math.ceil(d);
                double d3 = d - d2;
                luaState.pushnumber(d2);
                luaState.pushnumber(d3);
                return 2;
            }
            case 4: {
                luaState.pushnumber(Math.ceil(luaState.checkdouble(1)));
                return 1;
            }
            case 5: {
                luaState.pushnumber(Math.floor(luaState.checkdouble(1)));
                return 1;
            }
            case 6: {
                long l = Double.doubleToLongBits(luaState.checkdouble(1));
                luaState.pushnumber((double)((l & 0xFFFFFFFFFFFFFL) + 0x10000000000000L) * (l >= 0L ? (double)1.110223E-16f : (double)-1.110223E-16f));
                luaState.pushinteger(((int)(l >> 52) & 0x7FF) - 1022);
                return 2;
            }
            case 7: {
                double d = luaState.checkdouble(1);
                int n = luaState.checkint(2);
                luaState.pushnumber(d * Double.longBitsToDouble((long)(n + 1023) << 52));
                return 1;
            }
            case 8: {
                if (random == null) {
                    random = new Random(1L);
                }
                switch (luaState.gettop()) {
                    case 0: {
                        luaState.pushnumber(random.nextDouble());
                        return 1;
                    }
                    case 1: {
                        int n = luaState.checkint(1);
                        luaState.argcheck(1 <= n, 1, "interval is empty");
                        luaState.pushinteger(1 + random.nextInt(n));
                        return 1;
                    }
                }
                int n = luaState.checkint(1);
                int n2 = luaState.checkint(2);
                luaState.argcheck(n <= n2, 2, "interval is empty");
                luaState.pushinteger(n + random.nextInt(n2 + 1 - n));
                return 1;
            }
            case 9: {
                random = new Random(luaState.checkint(1));
                return 0;
            }
        }
        LuaState.vmerror("bad math id");
        return 0;
    }

    static {
        random = null;
    }
}

