/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.luaj.compiler.DumpState;
import org.luaj.lib.LBuffer;
import org.luaj.lib.PackageLib;
import org.luaj.vm.LClosure;
import org.luaj.vm.LFunction;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;

public class StringLib
extends LFunction {
    private static final String[] NAMES = new String[]{"string", "byte", "char", "dump", "find", "format", "gmatch", "gsub", "len", "lower", "match", "rep", "reverse", "sub", "upper"};
    private static final int INSTALL = 0;
    private static final int BYTE = 1;
    private static final int CHAR = 2;
    private static final int DUMP = 3;
    private static final int FIND = 4;
    private static final int FORMAT = 5;
    private static final int GMATCH = 6;
    private static final int GSUB = 7;
    private static final int LEN = 8;
    private static final int LOWER = 9;
    private static final int MATCH = 10;
    private static final int REP = 11;
    private static final int REVERSE = 12;
    private static final int SUB = 13;
    private static final int UPPER = 14;
    private final int id;
    private static final String FLAGS = "-+ #0";
    private static final int L_ESC = 37;
    private static final LString SPECIALS = new LString("^$*+?.([%-");
    private static final int MAX_CAPTURES = 32;
    private static final int CAP_UNFINISHED = -1;
    private static final int CAP_POSITION = -2;
    private static final byte MASK_ALPHA = 1;
    private static final byte MASK_LOWERCASE = 2;
    private static final byte MASK_UPPERCASE = 4;
    private static final byte MASK_DIGIT = 8;
    private static final byte MASK_PUNCT = 16;
    private static final byte MASK_SPACE = 32;
    private static final byte MASK_CONTROL = 64;
    private static final byte MASK_HEXDIGIT = -128;
    private static final byte[] CHAR_TABLE = new byte[256];

    public static void install(LTable lTable) {
        LTable lTable2 = LString.getMetatable();
        for (int i = 1; i < NAMES.length; ++i) {
            lTable2.put(NAMES[i], (LValue)new StringLib(i));
        }
        lTable.put("string", (LValue)lTable2);
        PackageLib.setIsLoaded("string", lTable2);
    }

    public StringLib() {
        this.id = 0;
    }

    private StringLib(int n) {
        this.id = n;
    }

    public String toString() {
        return NAMES[this.id] + "()";
    }

    public int invoke(LuaState luaState) {
        switch (this.id) {
            case 0: {
                StringLib.install(luaState._G);
                return 0;
            }
            case 1: {
                return StringLib.byte_(luaState);
            }
            case 2: {
                return StringLib.char_(luaState);
            }
            case 3: {
                return StringLib.dump(luaState);
            }
            case 4: {
                return StringLib.find(luaState);
            }
            case 5: {
                return StringLib.format(luaState);
            }
            case 6: {
                return StringLib.gmatch(luaState);
            }
            case 7: {
                return StringLib.gsub(luaState);
            }
            case 8: {
                return StringLib.len(luaState);
            }
            case 9: {
                return StringLib.lower(luaState);
            }
            case 10: {
                return StringLib.match(luaState);
            }
            case 11: {
                return StringLib.rep(luaState);
            }
            case 12: {
                return StringLib.reverse(luaState);
            }
            case 13: {
                return StringLib.sub(luaState);
            }
            case 14: {
                return StringLib.upper(luaState);
            }
        }
        luaState.error("bad id");
        return 0;
    }

    static int byte_(LuaState luaState) {
        LString lString = luaState.checklstring(1);
        int n = lString.m_length;
        int n2 = StringLib.posrelat(luaState.optint(2, 1), n);
        int n3 = StringLib.posrelat(luaState.optint(3, n2), n);
        if (n2 <= 0) {
            n2 = 1;
        }
        if (n3 > n) {
            n3 = n;
        }
        if (n2 > n3) {
            return 0;
        }
        int n4 = n3 - n2 + 1;
        if (n2 + n4 <= n3) {
            luaState.error("string slice too long");
        }
        luaState.checkstack(n4);
        for (int i = 0; i < n4; ++i) {
            luaState.pushinteger(lString.luaByte(n2 + i - 1));
        }
        return n4;
    }

    public static int char_(LuaState luaState) {
        int n = luaState.gettop();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 1;
        while (n2 < n) {
            int n4 = luaState.checkint(n3);
            luaState.argcheck(n4 >= 0 && n4 < 256, n3, "invalid value");
            byArray[n2] = (byte)n4;
            ++n2;
            ++n3;
        }
        luaState.pushlstring(byArray);
        return 1;
    }

    static int dump(LuaState luaState) {
        LFunction lFunction = luaState.checkfunction(1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DumpState.dump(((LClosure)lFunction).p, byteArrayOutputStream, true);
            luaState.pushlstring(byteArrayOutputStream.toByteArray());
            return 1;
        }
        catch (IOException iOException) {
            luaState.error(iOException.getMessage());
            return 0;
        }
    }

    static int find(LuaState luaState) {
        return StringLib.str_find_aux(luaState, true);
    }

    static int format(LuaState luaState) {
        LString lString = luaState.checklstring(1);
        int n = lString.length();
        LBuffer lBuffer = new LBuffer(n);
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            if ((n4 = lString.luaByte(n3++)) != 37) {
                lBuffer.append((byte)n4);
                continue;
            }
            if (n3 >= n) continue;
            n4 = lString.luaByte(n3);
            if (n4 == 37) {
                ++n3;
                lBuffer.append((byte)37);
                continue;
            }
            ++n2;
            FormatDesc formatDesc = new FormatDesc(luaState, lString, n3);
            n3 += formatDesc.length;
            switch (formatDesc.conversion) {
                case 99: {
                    formatDesc.format(lBuffer, (byte)luaState.checkint(n2));
                    break;
                }
                case 100: 
                case 105: {
                    formatDesc.format(lBuffer, luaState.checkint(n2));
                    break;
                }
                case 88: 
                case 111: 
                case 117: 
                case 120: {
                    formatDesc.format(lBuffer, luaState.checklong(n2));
                    break;
                }
                case 69: 
                case 71: 
                case 101: 
                case 102: 
                case 103: {
                    formatDesc.format(lBuffer, luaState.checkdouble(n2));
                    break;
                }
                case 113: {
                    StringLib.addquoted(lBuffer, luaState.checklstring(n2));
                    break;
                }
                case 115: {
                    LString lString2 = luaState.checklstring(n2);
                    if (formatDesc.precision == -1 && lString2.length() >= 100) {
                        lBuffer.append(lString2);
                        break;
                    }
                    formatDesc.format(lBuffer, lString2);
                    break;
                }
                default: {
                    luaState.error("invalid option '%" + (char)formatDesc.conversion + "' to 'format'");
                }
            }
        }
        luaState.pushlstring(lBuffer.toLuaString());
        return 1;
    }

    private static void addquoted(LBuffer lBuffer, LString lString) {
        lBuffer.append((byte)34);
        int n = lString.length();
        block5: for (int i = 0; i < n; ++i) {
            int n2 = lString.luaByte(i);
            switch (n2) {
                case 10: 
                case 34: 
                case 92: {
                    lBuffer.append((byte)92);
                    lBuffer.append((byte)n2);
                    continue block5;
                }
                case 13: {
                    lBuffer.append("\\r");
                    continue block5;
                }
                case 0: {
                    lBuffer.append("\\000");
                    continue block5;
                }
                default: {
                    lBuffer.append((byte)n2);
                }
            }
        }
        lBuffer.append((byte)34);
    }

    static int gmatch(LuaState luaState) {
        LString lString = luaState.checklstring(1);
        LString lString2 = luaState.checklstring(2);
        luaState.pushlvalue(new GMatchAux(luaState, lString, lString2));
        return 1;
    }

    static int gsub(LuaState luaState) {
        LString lString = luaState.checklstring(1);
        int n = lString.length();
        LString lString2 = luaState.checklstring(2);
        LValue lValue = luaState.topointer(3);
        int n2 = luaState.optint(4, n + 1);
        boolean bl = lString2.length() > 0 && lString2.charAt(0) == 94;
        LBuffer lBuffer = new LBuffer(n);
        MatchState matchState = new MatchState(luaState, lString, lString2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            matchState.reset();
            int n5 = matchState.match(n3, bl ? 1 : 0);
            if (n5 != -1) {
                ++n4;
                matchState.add_value(lBuffer, n3, n5, lValue);
            }
            if (n5 != -1 && n5 > n3) {
                n3 = n5;
            } else {
                if (n3 >= n) break;
                lBuffer.append((byte)lString.luaByte(n3++));
            }
            if (!bl) continue;
            break;
        }
        lBuffer.append(lString.substring(n3, n));
        luaState.pushlstring(lBuffer.toLuaString());
        luaState.pushinteger(n4);
        return 2;
    }

    static int len(LuaState luaState) {
        luaState.pushinteger(luaState.checklstring(1).length());
        return 1;
    }

    static int lower(LuaState luaState) {
        luaState.pushstring(luaState.checkstring(1).toLowerCase());
        return 1;
    }

    static int match(LuaState luaState) {
        return StringLib.str_find_aux(luaState, false);
    }

    static int rep(LuaState luaState) {
        LString lString = luaState.checklstring(1);
        int n = luaState.checkint(2);
        byte[] byArray = new byte[lString.length() * n];
        int n2 = lString.length();
        for (int i = 0; i < byArray.length; i += n2) {
            lString.copyInto(0, byArray, i, n2);
        }
        luaState.pushlstring(byArray);
        return 1;
    }

    static int reverse(LuaState luaState) {
        LString lString = luaState.checklstring(1);
        int n = lString.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < n) {
            byArray[n3] = (byte)lString.luaByte(n2);
            ++n2;
            --n3;
        }
        luaState.pushlstring(byArray);
        return 1;
    }

    static int sub(LuaState luaState) {
        LString lString = luaState.checklstring(1);
        int n = lString.length();
        int n2 = StringLib.posrelat(luaState.checkint(2), n);
        int n3 = StringLib.posrelat(luaState.optint(3, -1), n);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n3 > n) {
            n3 = n;
        }
        luaState.resettop();
        if (n2 <= n3) {
            LString lString2 = lString.substring(n2 - 1, n3);
            luaState.pushlstring(lString2);
        } else {
            luaState.pushstring("");
        }
        return 1;
    }

    static int upper(LuaState luaState) {
        luaState.pushstring(luaState.checkstring(1).toUpperCase());
        return 1;
    }

    static int str_find_aux(LuaState luaState, boolean bl) {
        boolean bl2;
        LString lString = luaState.checklstring(1);
        LString lString2 = luaState.checklstring(2);
        int n = luaState.optint(3, 1);
        if (n > 0) {
            n = Math.min(n - 1, lString.length());
        } else if (n < 0) {
            n = Math.max(0, lString.length() + n);
        }
        boolean bl3 = bl2 = bl && (luaState.toboolean(4) || lString2.indexOfAny(SPECIALS) == -1);
        if (bl2) {
            int n2 = lString.indexOf(lString2, n);
            if (n2 != -1) {
                luaState.pushinteger(n2 + 1);
                luaState.pushinteger(n2 + lString2.length());
                return 2;
            }
        } else {
            MatchState matchState = new MatchState(luaState, lString, lString2);
            boolean bl4 = false;
            int n3 = 0;
            if (lString2.luaByte(0) == 94) {
                bl4 = true;
                n3 = 1;
            }
            int n4 = n;
            luaState.resettop();
            do {
                matchState.reset();
                int n5 = matchState.match(n4, n3);
                if (n5 == -1) continue;
                if (bl) {
                    luaState.pushinteger(n4 + 1);
                    luaState.pushinteger(n5);
                    matchState.push_captures(false, n4, n5);
                } else {
                    matchState.push_captures(true, n4, n5);
                }
                return -1;
            } while (n4++ < lString.length() && !bl4);
        }
        luaState.pushnil();
        return 1;
    }

    private static int posrelat(int n, int n2) {
        return n >= 0 ? n : n2 + n + 1;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            StringLib.CHAR_TABLE[i] = (byte)((Character.isDigit(c) ? 8 : 0) | (Character.isLowerCase(c) ? 2 : 0) | (Character.isUpperCase(c) ? 4 : 0) | (c < ' ' || c == '\u007f' ? 64 : 0));
            if (c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0xFFFFFF80);
            }
            if (c >= '!' && c <= '/' || c >= ':' && c <= '@') {
                int n = i;
                CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 0x10);
            }
            if ((CHAR_TABLE[i] & 6) == 0) continue;
            int n = i;
            CHAR_TABLE[n] = (byte)(CHAR_TABLE[n] | 1);
        }
        StringLib.CHAR_TABLE[32] = 32;
        CHAR_TABLE[13] = (byte)(CHAR_TABLE[13] | 0x20);
        CHAR_TABLE[10] = (byte)(CHAR_TABLE[10] | 0x20);
        CHAR_TABLE[9] = (byte)(CHAR_TABLE[9] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
        CHAR_TABLE[12] = (byte)(CHAR_TABLE[12] | 0x20);
    }

    private static class MatchState {
        final LString s;
        final LString p;
        final LuaState vm;
        int level;
        int[] cinit;
        int[] clen;

        MatchState(LuaState luaState, LString lString, LString lString2) {
            this.s = lString;
            this.p = lString2;
            this.vm = luaState;
            this.level = 0;
            this.cinit = new int[32];
            this.clen = new int[32];
        }

        void reset() {
            this.level = 0;
        }

        private void add_s(LBuffer lBuffer, LString lString, int n, int n2) {
            int n3 = lString.length();
            for (int i = 0; i < n3; ++i) {
                byte by = (byte)lString.luaByte(i);
                if (by != 37) {
                    lBuffer.append(by);
                    continue;
                }
                if (!Character.isDigit((char)(by = (byte)lString.luaByte(++i)))) {
                    lBuffer.append(by);
                    continue;
                }
                if (by == 48) {
                    lBuffer.append(this.s.substring(n, n2));
                    continue;
                }
                this.push_onecapture(by - 49, n, n2);
                lBuffer.append(this.vm.topointer(-1).luaAsString());
                this.vm.pop(1);
            }
        }

        public void add_value(LBuffer lBuffer, int n, int n2, LValue lValue) {
            switch (lValue.luaGetType()) {
                case 3: 
                case 4: {
                    this.add_s(lBuffer, lValue.luaAsString(), n, n2);
                    return;
                }
                case 6: {
                    this.vm.pushlvalue(lValue);
                    int n3 = this.push_captures(true, n, n2);
                    this.vm.call(n3, 1);
                    break;
                }
                case 5: {
                    this.push_onecapture(0, n, n2);
                    LValue lValue2 = this.vm.topointer(-1);
                    this.vm.pop(1);
                    this.vm.pushlvalue(((LTable)lValue).luaGetTable(this.vm, lValue2));
                    break;
                }
                default: {
                    this.vm.error("bad argument: string/function/table expected");
                    return;
                }
            }
            lValue = this.vm.topointer(-1);
            if (!lValue.toJavaBoolean()) {
                lValue = this.s.substring(n, n2);
            } else if (!lValue.isString()) {
                this.vm.error("invalid replacement value (a " + lValue.luaGetTypeName() + ")");
            }
            this.vm.pop(1);
            lBuffer.append(lValue.luaAsString());
        }

        int push_captures(boolean bl, int n, int n2) {
            int n3 = this.level == 0 && bl ? 1 : this.level;
            for (int i = 0; i < n3; ++i) {
                this.push_onecapture(i, n, n2);
            }
            return n3;
        }

        private void push_onecapture(int n, int n2, int n3) {
            if (n >= this.level) {
                if (n == 0) {
                    this.vm.pushlstring(this.s.substring(n2, n3));
                } else {
                    this.vm.error("invalid capture index");
                }
            } else {
                int n4 = this.clen[n];
                if (n4 == -1) {
                    this.vm.error("unfinished capture");
                }
                if (n4 == -2) {
                    this.vm.pushinteger(this.cinit[n] + 1);
                } else {
                    int n5 = this.cinit[n];
                    this.vm.pushlstring(this.s.substring(n5, n5 + n4));
                }
            }
        }

        private int check_capture(int n) {
            if ((n -= 49) < 0 || n >= this.level || this.clen[n] == -1) {
                this.vm.error("invalid capture index");
            }
            return n;
        }

        private int capture_to_close() {
            int n = this.level;
            --n;
            while (n >= 0) {
                if (this.clen[n] == -1) {
                    return n;
                }
                --n;
            }
            this.vm.error("invalid pattern capture");
            return 0;
        }

        int classend(int n) {
            switch (this.p.luaByte(n++)) {
                case 37: {
                    if (n == this.p.length()) {
                        this.vm.error("malformed pattern (ends with %)");
                    }
                    return n + 1;
                }
                case 91: {
                    if (this.p.luaByte(n) == 94) {
                        ++n;
                    }
                    do {
                        if (n == this.p.length()) {
                            this.vm.error("malformed pattern (missing ])");
                        }
                        if (this.p.luaByte(n++) != 37 || n == this.p.length()) continue;
                        ++n;
                    } while (this.p.luaByte(n) != 93);
                    return n + 1;
                }
            }
            return n;
        }

        static boolean match_class(int n, int n2) {
            boolean bl;
            char c = Character.toLowerCase((char)n2);
            byte by = CHAR_TABLE[n];
            switch (c) {
                case 'a': {
                    bl = (by & 1) != 0;
                    break;
                }
                case 'd': {
                    bl = (by & 8) != 0;
                    break;
                }
                case 'l': {
                    bl = (by & 2) != 0;
                    break;
                }
                case 'u': {
                    bl = (by & 4) != 0;
                    break;
                }
                case 'c': {
                    bl = (by & 0x40) != 0;
                    break;
                }
                case 'p': {
                    bl = (by & 0x10) != 0;
                    break;
                }
                case 's': {
                    bl = (by & 0x20) != 0;
                    break;
                }
                case 'w': {
                    bl = (by & 9) != 0;
                    break;
                }
                case 'x': {
                    bl = (by & 0xFFFFFF80) != 0;
                    break;
                }
                case 'z': {
                    bl = n == 0;
                    break;
                }
                default: {
                    return n2 == n;
                }
            }
            return c == n2 ? bl : !bl;
        }

        boolean matchbracketclass(int n, int n2, int n3) {
            boolean bl = true;
            if (this.p.luaByte(n2 + 1) == 94) {
                bl = false;
                ++n2;
            }
            while (++n2 < n3) {
                if (!(this.p.luaByte(n2) == 37 ? MatchState.match_class(n, this.p.luaByte(++n2)) : (this.p.luaByte(n2 + 1) == 45 && n2 + 2 < n3 ? this.p.luaByte((n2 += 2) - 2) <= n && n <= this.p.luaByte(n2) : this.p.luaByte(n2) == n))) continue;
                return bl;
            }
            return !bl;
        }

        boolean singlematch(int n, int n2, int n3) {
            switch (this.p.luaByte(n2)) {
                case 46: {
                    return true;
                }
                case 37: {
                    return MatchState.match_class(n, this.p.luaByte(n2 + 1));
                }
                case 91: {
                    return this.matchbracketclass(n, n2, n3 - 1);
                }
            }
            return this.p.luaByte(n2) == n;
        }

        int match(int n, int n2) {
            block16: while (n2 != this.p.length()) {
                int n3;
                int n4;
                switch (this.p.luaByte(n2)) {
                    case 40: {
                        if (++n2 < this.p.length() && this.p.luaByte(n2) == 41) {
                            return this.start_capture(n, n2 + 1, -2);
                        }
                        return this.start_capture(n, n2, -1);
                    }
                    case 41: {
                        return this.end_capture(n, n2 + 1);
                    }
                    case 37: {
                        if (n2 + 1 == this.p.length()) {
                            this.vm.error("malformed pattern (ends with '%')");
                        }
                        switch (this.p.luaByte(n2 + 1)) {
                            case 98: {
                                n = this.matchbalance(n, n2 + 2);
                                if (n == -1) {
                                    return -1;
                                }
                                n2 += 4;
                                continue block16;
                            }
                            case 102: {
                                if (this.p.luaByte(n2 += 2) != 91) {
                                    this.vm.error("Missing [ after %f in pattern");
                                }
                                n4 = this.classend(n2);
                                int n5 = n3 = n == 0 ? -1 : this.s.luaByte(n - 1);
                                if (this.matchbracketclass(n3, n2, n4 - 1) || this.matchbracketclass(this.s.luaByte(n), n2, n4 - 1)) {
                                    return -1;
                                }
                                n2 = n4;
                                continue block16;
                            }
                        }
                        n4 = this.p.luaByte(n2 + 1);
                        if (Character.isDigit((char)n4)) {
                            if ((n = this.match_capture(n, n4)) == -1) {
                                return -1;
                            }
                            return this.match(n, n2 + 2);
                        }
                    }
                    case 36: {
                        if (n2 + 1 != this.p.length()) break;
                        return n == this.s.length() ? n : -1;
                    }
                }
                n4 = this.classend(n2);
                n3 = n < this.s.length() && this.singlematch(this.s.luaByte(n), n2, n4) ? 1 : 0;
                int n6 = n4 < this.p.length() ? this.p.luaByte(n4) : 0;
                switch (n6) {
                    case 63: {
                        int n7;
                        if (n3 != 0 && (n7 = this.match(n + 1, n4 + 1)) != -1) {
                            return n7;
                        }
                        n2 = n4 + 1;
                        continue block16;
                    }
                    case 42: {
                        return this.max_expand(n, n2, n4);
                    }
                    case 43: {
                        return n3 != 0 ? this.max_expand(n + 1, n2, n4) : -1;
                    }
                    case 45: {
                        return this.min_expand(n, n2, n4);
                    }
                }
                if (n3 == 0) {
                    return -1;
                }
                ++n;
                n2 = n4;
            }
            return n;
        }

        int max_expand(int n, int n2, int n3) {
            int n4 = 0;
            while (n + n4 < this.s.length() && this.singlematch(this.s.luaByte(n + n4), n2, n3)) {
                ++n4;
            }
            while (n4 >= 0) {
                int n5 = this.match(n + n4, n3 + 1);
                if (n5 != -1) {
                    return n5;
                }
                --n4;
            }
            return -1;
        }

        int min_expand(int n, int n2, int n3) {
            while (true) {
                int n4;
                if ((n4 = this.match(n, n3 + 1)) != -1) {
                    return n4;
                }
                if (n >= this.s.length() || !this.singlematch(this.s.luaByte(n), n2, n3)) break;
                ++n;
            }
            return -1;
        }

        int start_capture(int n, int n2, int n3) {
            int n4 = this.level;
            if (n4 >= 32) {
                this.vm.error("too many captures");
            }
            this.cinit[n4] = n;
            this.clen[n4] = n3;
            this.level = n4 + 1;
            int n5 = this.match(n, n2);
            if (n5 == -1) {
                --this.level;
            }
            return n5;
        }

        int end_capture(int n, int n2) {
            int n3 = this.capture_to_close();
            this.clen[n3] = n - this.cinit[n3];
            int n4 = this.match(n, n2);
            if (n4 == -1) {
                this.clen[n3] = -1;
            }
            return n4;
        }

        int match_capture(int n, int n2) {
            n2 = this.check_capture(n2);
            int n3 = this.clen[n2];
            if (this.s.length() - n >= n3 && LString.equals(this.s, this.cinit[n2], this.s, n, n3)) {
                return n + n3;
            }
            return -1;
        }

        int matchbalance(int n, int n2) {
            int n3 = this.p.length();
            if (n2 == n3 || n2 + 1 == n3) {
                this.vm.error("unbalanced pattern");
            }
            if (this.s.luaByte(n) != this.p.luaByte(n2)) {
                return -1;
            }
            int n4 = this.p.luaByte(n2);
            int n5 = this.p.luaByte(n2 + 1);
            int n6 = 1;
            while (++n < this.s.length()) {
                if (this.s.luaByte(n) == n5) {
                    if (--n6 != 0) continue;
                    return n + 1;
                }
                if (this.s.luaByte(n) != n4) continue;
                ++n6;
            }
            return -1;
        }
    }

    static class GMatchAux
    extends LFunction {
        private final int srclen;
        private final MatchState ms;
        private int soffset;

        public GMatchAux(LuaState luaState, LString lString, LString lString2) {
            this.srclen = lString.length();
            this.ms = new MatchState(luaState, lString, lString2);
            this.soffset = 0;
        }

        public int invoke(LuaState luaState) {
            luaState.resettop();
            while (this.soffset < this.srclen) {
                this.ms.reset();
                int n = this.ms.match(this.soffset, 0);
                if (n >= 0) {
                    int n2 = this.soffset;
                    this.soffset = n;
                    this.ms.push_captures(true, n2, n);
                    return -1;
                }
                ++this.soffset;
            }
            luaState.pushnil();
            return 1;
        }
    }

    private static class FormatDesc {
        private boolean leftAdjust;
        private boolean zeroPad;
        private boolean explicitPlus;
        private boolean space;
        private boolean alternateForm;
        private static final int MAX_FLAGS = 5;
        private int width;
        private int precision;
        public final int conversion;
        public final int length;

        public FormatDesc(LuaState luaState, LString lString, int n) {
            int n2 = n;
            int n3 = lString.length();
            int n4 = 0;
            boolean bl = true;
            block7: while (bl) {
                n4 = n2 < n3 ? lString.luaByte(n2++) : 0;
                switch (n4) {
                    case 45: {
                        this.leftAdjust = true;
                        continue block7;
                    }
                    case 43: {
                        this.explicitPlus = true;
                        continue block7;
                    }
                    case 32: {
                        this.space = true;
                        continue block7;
                    }
                    case 35: {
                        this.alternateForm = true;
                        continue block7;
                    }
                    case 48: {
                        this.zeroPad = true;
                        continue block7;
                    }
                }
                bl = false;
            }
            if (n2 - n > 5) {
                luaState.error("invalid format (repeated flags)");
            }
            this.width = -1;
            if (Character.isDigit((char)n4)) {
                this.width = n4 - 48;
                int n5 = n4 = n2 < n3 ? lString.luaByte(n2++) : 0;
                if (Character.isDigit((char)n4)) {
                    this.width = this.width * 10 + (n4 - 48);
                    n4 = n2 < n3 ? lString.luaByte(n2++) : 0;
                }
            }
            this.precision = -1;
            if (n4 == 46) {
                int n6 = n4 = n2 < n3 ? lString.luaByte(n2++) : 0;
                if (Character.isDigit((char)n4)) {
                    this.precision = n4 - 48;
                    int n7 = n4 = n2 < n3 ? lString.luaByte(n2++) : 0;
                    if (Character.isDigit((char)n4)) {
                        this.precision = this.precision * 10 + (n4 - 48);
                        int n8 = n4 = n2 < n3 ? lString.luaByte(n2++) : 0;
                    }
                }
            }
            if (Character.isDigit((char)n4)) {
                luaState.error("invalid format (width or precision too long)");
            }
            this.zeroPad &= !this.leftAdjust;
            this.conversion = n4;
            this.length = n2 - n;
        }

        public void format(LBuffer lBuffer, byte by) {
            lBuffer.append(by);
        }

        public void format(LBuffer lBuffer, long l) {
            int n;
            int n2;
            String string;
            if (l == 0L && this.precision == 0) {
                string = "";
            } else {
                switch (this.conversion) {
                    case 88: 
                    case 120: {
                        n2 = 16;
                        break;
                    }
                    case 111: {
                        n2 = 8;
                        break;
                    }
                    default: {
                        n2 = 10;
                    }
                }
                string = Long.toString(l, n2);
                if (this.conversion == 88) {
                    string = string.toUpperCase();
                }
            }
            int n3 = n2 = string.length();
            if (l < 0L) {
                --n3;
            } else if (this.explicitPlus || this.space) {
                ++n2;
            }
            int n4 = this.precision > n3 ? this.precision - n3 : (this.precision == -1 && this.zeroPad && this.width > n2 ? this.width - n2 : 0);
            int n5 = n = this.width > (n2 += n4) ? this.width - n2 : 0;
            if (!this.leftAdjust) {
                FormatDesc.pad(lBuffer, ' ', n);
            }
            if (l < 0L) {
                if (n4 > 0) {
                    lBuffer.append((byte)45);
                    string = string.substring(1);
                }
            } else if (this.explicitPlus) {
                lBuffer.append((byte)43);
            } else if (this.space) {
                lBuffer.append((byte)32);
            }
            if (n4 > 0) {
                FormatDesc.pad(lBuffer, '0', n4);
            }
            lBuffer.append(string);
            if (this.leftAdjust) {
                FormatDesc.pad(lBuffer, ' ', n);
            }
        }

        public void format(LBuffer lBuffer, double d) {
            lBuffer.append(String.valueOf(d));
        }

        public void format(LBuffer lBuffer, LString lString) {
            int n = lString.indexOf((byte)0, 0);
            if (n != -1) {
                lString = lString.substring(0, n);
            }
            lBuffer.append(lString);
        }

        public static final void pad(LBuffer lBuffer, char c, int n) {
            byte by = (byte)c;
            while (n-- > 0) {
                lBuffer.append(by);
            }
        }
    }
}

