/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import java.io.ByteArrayOutputStream;
import org.luaj.lib.PackageLib;
import org.luaj.vm.LFunction;
import org.luaj.vm.LNil;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;

public class TableLib
extends LFunction {
    public static final String[] NAMES = new String[]{"table", "concat", "foreach", "foreachi", "getn", "insert", "maxn", "remove", "sort"};
    private static final int INSTALL = 0;
    private static final int CONCAT = 1;
    private static final int FOREACH = 2;
    private static final int FOREACHI = 3;
    private static final int GETN = 4;
    private static final int INSERT = 5;
    private static final int MAXN = 6;
    private static final int REMOVE = 7;
    private static final int SORT = 8;
    private final int id;

    public static void install(LTable lTable) {
        LTable lTable2 = new LTable();
        for (int i = 1; i < NAMES.length; ++i) {
            lTable2.put(NAMES[i], (LValue)new TableLib(i));
        }
        lTable.put("table", (LValue)lTable2);
        PackageLib.setIsLoaded("table", lTable2);
    }

    private TableLib() {
        this.id = 0;
    }

    private TableLib(int n) {
        this.id = n;
    }

    public String toString() {
        return NAMES[this.id] + "()";
    }

    public int invoke(LuaState luaState) {
        switch (this.id) {
            case 0: {
                TableLib.install(luaState._G);
                return 0;
            }
            case 1: {
                LTable lTable = luaState.checktable(1);
                LString lString = luaState.optlstring(2, null);
                int n = luaState.optint(3, 1);
                int n2 = luaState.optint(4, -1);
                if (n2 == -1) {
                    n2 = lTable.luaLength();
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int i = n; i <= n2; ++i) {
                    LValue lValue = lTable.get(i);
                    if (!lValue.isString()) {
                        luaState.argerror(1, "table contains non-strings");
                    }
                    lValue.luaConcatTo(byteArrayOutputStream);
                    if (i >= n2 || lString == null) continue;
                    lString.luaConcatTo(byteArrayOutputStream);
                }
                luaState.pushlstring(byteArrayOutputStream.toByteArray());
                return 1;
            }
            case 2: 
            case 3: {
                LTable lTable = luaState.checktable(1);
                LFunction lFunction = luaState.checkfunction(2);
                luaState.pushlvalue(lTable.foreach(luaState, lFunction, this.id == 3));
                return 1;
            }
            case 4: {
                LTable lTable = luaState.checktable(1);
                luaState.pushinteger(lTable.luaLength());
                return 1;
            }
            case 5: {
                LTable lTable = luaState.checktable(1);
                int n = 0;
                switch (luaState.gettop()) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        n = luaState.checkint(2);
                        break;
                    }
                    default: {
                        luaState.error("wrong number of arguments to 'insert'");
                    }
                }
                lTable.luaInsertPos(n, luaState.topointer(-1));
                return 0;
            }
            case 6: {
                LTable lTable = luaState.checktable(1);
                luaState.pushlvalue(lTable.luaMaxN());
                return 1;
            }
            case 7: {
                LTable lTable = luaState.checktable(1);
                int n = luaState.optint(2, 0);
                LValue lValue = lTable.luaRemovePos(n);
                luaState.pushlvalue(lValue);
                return lValue.isNil() ? 0 : 1;
            }
            case 8: {
                LTable lTable = luaState.checktable(1);
                LNil lNil = luaState.isnoneornil(2) ? LNil.NIL : luaState.checkfunction(2);
                lTable.luaSort(luaState, lNil);
                return 0;
            }
        }
        LuaState.vmerror("bad table id");
        return 0;
    }
}

