/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib.j2se;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.luaj.lib.BaseLib;
import org.luaj.lib.IoLib;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;

public class J2seIoLib
extends IoLib {
    public static void install(LTable lTable) {
        new J2seIoLib().initialize(lTable);
    }

    public J2seIoLib() {
    }

    public J2seIoLib(int n) {
        super(n);
    }

    protected IoLib newInstance(int n) {
        return new J2seIoLib(n);
    }

    protected IoLib.File wrapStdin() throws IOException {
        return new FileImpl(BaseLib.STDIN != null ? BaseLib.STDIN : System.in);
    }

    protected IoLib.File wrapStdout() throws IOException {
        return new FileImpl(BaseLib.STDOUT != null ? BaseLib.STDOUT : System.out);
    }

    protected IoLib.File openFile(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, bl ? "r" : "rw");
        if (bl2) {
            randomAccessFile.seek(randomAccessFile.length());
        } else if (!bl) {
            randomAccessFile.setLength(0L);
        }
        return new FileImpl(randomAccessFile);
    }

    protected IoLib.File openProgram(String string, String string2) throws IOException {
        Process process = Runtime.getRuntime().exec(string);
        return "w".equals(string2) ? new FileImpl(process.getOutputStream()) : new FileImpl(process.getInputStream());
    }

    protected IoLib.File tmpFile() throws IOException {
        File file = File.createTempFile(".luaj", "bin");
        file.deleteOnExit();
        return new FileImpl(new RandomAccessFile(file, "rw"));
    }

    private static void notimplemented() {
        throw new RuntimeException("not implemented");
    }

    private static final class FileImpl
    implements IoLib.File {
        private final RandomAccessFile file;
        private final InputStream is;
        private final OutputStream os;
        private boolean closed = false;
        private boolean nobuffer = false;

        private FileImpl(RandomAccessFile randomAccessFile, InputStream inputStream, OutputStream outputStream) {
            this.file = randomAccessFile;
            this.is = inputStream != null ? (inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream)) : null;
            this.os = outputStream;
        }

        private FileImpl(RandomAccessFile randomAccessFile) {
            this(randomAccessFile, null, null);
        }

        private FileImpl(InputStream inputStream) {
            this(null, inputStream, null);
        }

        private FileImpl(OutputStream outputStream) {
            this(null, null, outputStream);
        }

        public String toString() {
            return "file (" + this.hashCode() + ")";
        }

        public boolean isstdfile() {
            return this.file == null;
        }

        public void close() throws IOException {
            this.closed = true;
            if (this.file != null) {
                this.file.close();
            }
        }

        public void flush() throws IOException {
            if (this.os != null) {
                this.os.flush();
            }
        }

        public void write(LString lString) throws IOException {
            if (this.os != null) {
                this.os.write(lString.m_bytes, lString.m_offset, lString.m_length);
            } else if (this.file != null) {
                this.file.write(lString.m_bytes, lString.m_offset, lString.m_length);
            } else {
                J2seIoLib.notimplemented();
            }
            if (this.nobuffer) {
                this.flush();
            }
        }

        public boolean isclosed() {
            return this.closed;
        }

        public int seek(String string, int n) throws IOException {
            if (this.file != null) {
                if ("set".equals(string)) {
                    this.file.seek(n);
                } else if ("end".equals(string)) {
                    this.file.seek(this.file.length() + (long)n);
                } else {
                    this.file.seek(this.file.getFilePointer() + (long)n);
                }
                return (int)this.file.getFilePointer();
            }
            J2seIoLib.notimplemented();
            return 0;
        }

        public void setvbuf(String string, int n) {
            this.nobuffer = "no".equals(string);
        }

        public int remaining() throws IOException {
            return this.file != null ? (int)(this.file.length() - this.file.getFilePointer()) : -1;
        }

        public int peek() throws IOException {
            if (this.is != null) {
                this.is.mark(1);
                int n = this.is.read();
                this.is.reset();
                return n;
            }
            if (this.file != null) {
                int n = this.file.read();
                this.file.seek(this.file.getFilePointer() - 1L);
                return n;
            }
            J2seIoLib.notimplemented();
            return 0;
        }

        public int read() throws IOException {
            if (this.is != null) {
                return this.is.read();
            }
            if (this.file != null) {
                return this.file.read();
            }
            J2seIoLib.notimplemented();
            return 0;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.file != null) {
                return this.file.read(byArray, n, n2);
            }
            if (this.is != null) {
                return this.is.read(byArray, n, n2);
            }
            J2seIoLib.notimplemented();
            return n2;
        }
    }
}

