/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.luaj.lib.BaseLib;
import org.luaj.vm.CallInfo;
import org.luaj.vm.LBoolean;
import org.luaj.vm.LFunction;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;
import org.luaj.vm.Platform;

public class PackageLib
extends LFunction {
    public static String DEFAULT_LUA_PATH = "?.lua";
    public static InputStream STDIN = null;
    public static PrintStream STDOUT = System.out;
    public static LTable LOADED = null;
    private static final LString _M = new LString("_M");
    private static final LString _NAME = new LString("_NAME");
    private static final LString _PACKAGE = new LString("_PACKAGE");
    private static final LString _DOT = new LString(".");
    private static final LString _EMPTY = new LString("");
    private static final LString __INDEX = new LString("__index");
    private static final LString _LOADERS = new LString("loaders");
    private static final LString _PRELOAD = new LString("preload");
    private static final LString _PATH = new LString("path");
    private static final LValue _SENTINEL = _EMPTY;
    private static final String[] NAMES = new String[]{"package", "module", "require", "loadlib", "seeall", "preload_loader", "lua_loader", "java_loader"};
    private static final int INSTALL = 0;
    private static final int MODULE = 1;
    private static final int REQUIRE = 2;
    private static final int LOADLIB = 3;
    private static final int SEEALL = 4;
    private static final int PRELOAD_LOADER = 5;
    private static final int LUA_LOADER = 6;
    private static final int JAVA_LOADER = 7;
    private static LTable pckg;
    private final int id;

    public static void install(LTable lTable) {
        int n;
        for (n = 1; n <= 2; ++n) {
            lTable.put(NAMES[n], (LValue)new PackageLib(n));
        }
        pckg = new LTable();
        for (n = 3; n <= 4; ++n) {
            pckg.put(NAMES[n], (LValue)new PackageLib(n));
        }
        LOADED = new LTable();
        pckg.put("loaded", (LValue)LOADED);
        pckg.put(_PRELOAD, (LValue)new LTable());
        LTable lTable2 = new LTable(3, 0);
        for (int i = 5; i <= 7; ++i) {
            lTable2.luaInsertPos(0, new PackageLib(i));
        }
        pckg.put("loaders", (LValue)lTable2);
        pckg.put(_PATH, (LValue)new LString(DEFAULT_LUA_PATH));
        lTable.put("package", (LValue)pckg);
        PackageLib.setIsLoaded("package", pckg);
    }

    public static void setIsLoaded(String string, LTable lTable) {
        LOADED.put(string, (LValue)lTable);
    }

    public static void setLuaPath(String string) {
        pckg.put(_PATH, (LValue)new LString(string));
    }

    private PackageLib(int n) {
        this.id = n;
    }

    public String toString() {
        return NAMES[this.id] + "()";
    }

    public int invoke(LuaState luaState) {
        switch (this.id) {
            case 0: {
                PackageLib.install(luaState._G);
                return 0;
            }
            case 1: {
                return PackageLib.module(luaState);
            }
            case 2: {
                return this.require(luaState);
            }
            case 3: {
                return PackageLib.loadlib(luaState);
            }
            case 4: {
                LTable lTable = luaState.checktable(1);
                LTable lTable2 = lTable.luaGetMetatable();
                if (lTable2 == null) {
                    lTable2 = new LTable();
                    lTable.luaSetMetatable(lTable2);
                }
                lTable2.put(__INDEX, (LValue)luaState._G);
                return 0;
            }
            case 5: {
                return this.loader_preload(luaState);
            }
            case 6: {
                return this.loader_Lua(luaState);
            }
            case 7: {
                return this.loader_Java(luaState);
            }
        }
        LuaState.vmerror("bad package id");
        return 0;
    }

    public static int module(LuaState luaState) {
        LTable lTable;
        LString lString = luaState.checklstring(1);
        int n = luaState.gettop();
        LValue lValue = LOADED.luaGetTable(luaState, lString);
        if (!lValue.isTable()) {
            lTable = PackageLib.findtable(luaState._G, lString);
            if (lTable == null) {
                luaState.error("name conflict for module '" + lString + "'");
            }
            LOADED.luaSetTable(luaState, lString, lTable);
        } else {
            lTable = (LTable)lValue;
        }
        LValue lValue2 = lTable.luaGetTable(luaState, _NAME);
        if (lValue2.isNil()) {
            PackageLib.modinit(luaState, lTable, lString);
        }
        CallInfo callInfo = luaState.getStackFrame(0);
        callInfo.closure.env = lTable;
        for (int i = 2; i <= n; ++i) {
            luaState.pushvalue(i);
            luaState.pushlvalue(lTable);
            luaState.call(1, 0);
        }
        return 0;
    }

    private static LTable findtable(LTable lTable, LString lString) {
        int n = -1;
        do {
            LString lString2;
            LValue lValue;
            int n2;
            if ((n = lString.indexOf(_DOT, n2 = n + 1)) < 0) {
                n = lString.m_length;
            }
            if ((lValue = lTable.get(lString2 = lString.substring(n2, n))).isNil()) {
                LTable lTable2 = new LTable();
                lTable.put(lString2, (LValue)lTable2);
                lTable = lTable2;
                continue;
            }
            if (lValue.luaGetType() != 5) {
                return null;
            }
            lTable = (LTable)lValue;
        } while (n < lString.m_length);
        return lTable;
    }

    private static void modinit(LuaState luaState, LTable lTable, LString lString) {
        lTable.luaSetTable(luaState, _M, lTable);
        int n = lString.lastIndexOf(_DOT);
        lTable.luaSetTable(luaState, _NAME, lString);
        lTable.luaSetTable(luaState, _PACKAGE, n < 0 ? _EMPTY : lString.substring(0, n + 1));
    }

    public int require(LuaState luaState) {
        LValue lValue;
        LString lString = luaState.checklstring(1);
        LValue lValue2 = LOADED.luaGetTable(luaState, lString);
        if (lValue2.toJavaBoolean()) {
            if (lValue2 == _SENTINEL) {
                luaState.error("loop or previous error loading module '" + lString + "'");
            }
            luaState.pushlvalue(lValue2);
            return 1;
        }
        LValue lValue3 = pckg.luaGetTable(luaState, _LOADERS);
        if (!lValue3.isTable()) {
            luaState.error("'package.loaders' must be a table");
        }
        LTable lTable = (LTable)lValue3;
        Vector<LString> vector = new Vector<LString>();
        int n = 1;
        while (true) {
            LValue lValue4;
            if ((lValue4 = lTable.get(n)).isNil()) {
                luaState.error("module '" + lString + "' not found: " + vector);
            }
            luaState.pushlvalue(lValue4);
            luaState.pushlstring(lString);
            luaState.call(1, 1);
            if (luaState.isfunction(-1)) break;
            if (luaState.isstring(-1)) {
                vector.addElement(luaState.tolstring(-1));
            }
            luaState.pop(1);
            ++n;
        }
        LOADED.luaSetTable(luaState, lString, _SENTINEL);
        luaState.pushlstring(lString);
        luaState.call(1, 1);
        if (!luaState.isnil(-1)) {
            LOADED.luaSetTable(luaState, lString, luaState.topointer(-1));
        }
        if ((lValue = LOADED.luaGetTable(luaState, lString)) == _SENTINEL) {
            lValue = LBoolean.TRUE;
            LOADED.luaSetTable(luaState, lString, lValue);
        }
        luaState.pushlvalue(lValue);
        return 1;
    }

    public static int loadlib(LuaState luaState) {
        luaState.checkstring(1);
        luaState.pushnil();
        luaState.pushstring("dynamic libraries not enabled");
        luaState.pushstring("absent");
        return 3;
    }

    private int loader_preload(LuaState luaState) {
        LValue lValue;
        LString lString = luaState.tolstring(1);
        LValue lValue2 = pckg.luaGetTable(luaState, _PRELOAD);
        if (!lValue2.isTable()) {
            luaState.error("package.preload '" + lString + "' must be a table");
        }
        if ((lValue = lValue2.luaGetTable(luaState, lString)).isNil()) {
            luaState.pushstring("\n\tno field package.preload['" + lString + "']");
        } else {
            luaState.pushlvalue(lValue);
        }
        return 1;
    }

    private int loader_Lua(LuaState luaState) {
        String string;
        String string2 = luaState.tostring(1);
        InputStream inputStream = this.findfile(luaState, string2, _PATH);
        if (inputStream != null && !BaseLib.loadis(luaState, inputStream, string = luaState.tostring(-1))) {
            PackageLib.loaderror(luaState, string);
        }
        return 1;
    }

    private int loader_Java(LuaState luaState) {
        String string = luaState.tostring(1);
        Class<?> clazz = null;
        LValue lValue = null;
        try {
            clazz = Class.forName(string);
            lValue = (LValue)clazz.newInstance();
            luaState.pushlvalue(lValue);
        }
        catch (ClassNotFoundException classNotFoundException) {
            luaState.pushstring("\n\tno class '" + string + "'");
        }
        catch (Exception exception) {
            luaState.pushstring("\n\tjava load failed on '" + string + "', " + exception);
        }
        return 1;
    }

    private InputStream findfile(LuaState luaState, String string, LString lString) {
        Platform platform = Platform.getInstance();
        LValue lValue = pckg.luaGetTable(luaState, lString);
        if (!lValue.isString()) {
            luaState.error("package." + lString + " must be a string");
        }
        String string2 = lValue.toJavaString();
        int n = -1;
        int n2 = string2.length();
        StringBuffer stringBuffer = null;
        string = string.replace('.', '/');
        while (n < n2) {
            InputStream inputStream;
            int n3 = n + 1;
            if ((n = string2.indexOf(59, n3)) < 0) {
                n = string2.length();
            }
            String string3 = string2.substring(n3, n);
            int n4 = string3.indexOf(63);
            String string4 = string3;
            if (n4 >= 0) {
                string4 = string3.substring(0, n4) + string + string3.substring(n4 + 1);
            }
            if ((inputStream = platform.openFile(string4)) != null) {
                luaState.pushstring(string4);
                return inputStream;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append("\n\tno file '" + string4 + "'");
        }
        luaState.pushstring(stringBuffer.toString());
        return null;
    }

    private static void loaderror(LuaState luaState, String string) {
        luaState.error("error loading module '" + luaState.tostring(1) + "' from file '" + string + "':\n\t" + luaState.tostring(-1));
    }
}

