/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.script;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.luaj.script.LuaScriptEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuaScriptEngineFactory
implements ScriptEngineFactory {
    private static final String FILEEXT = ".lua";
    private static final String[] MIMETYPES = new String[]{"text/plain", "text/lua", "application/lua"};
    private static final String[] NAMES = new String[]{"lua", "luaj"};
    private ScriptEngine myScriptEngine = new LuaScriptEngine();
    private List<String> extensions = Collections.nCopies(1, ".lua");
    private List<String> mimeTypes = Arrays.asList(MIMETYPES);
    private List<String> names = Arrays.asList(NAMES);

    @Override
    public String getEngineName() {
        return this.getScriptEngine().get("javax.script.engine").toString();
    }

    @Override
    public String getEngineVersion() {
        return this.getScriptEngine().get("javax.script.engine_version").toString();
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getLanguageName() {
        return this.getScriptEngine().get("javax.script.language").toString();
    }

    @Override
    public String getLanguageVersion() {
        return this.getScriptEngine().get("javax.script.language_version").toString();
    }

    @Override
    public Object getParameter(String string) {
        return this.getScriptEngine().get(string).toString();
    }

    @Override
    public String getMethodCallSyntax(String string, String string2, String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + ":" + string2 + "(");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String getOutputStatement(String string) {
        return "print(" + string + ")";
    }

    @Override
    public String getProgram(String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return this.myScriptEngine;
    }
}

