/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import org.luaj.vm.LClosure;
import org.luaj.vm.LFunction;
import org.luaj.vm.LValue;
import org.luaj.vm.Lua;
import org.luaj.vm.LuaState;

public class CallInfo {
    public LClosure closure;
    public int base;
    public int top;
    public int pc;
    public int resultbase;
    public int nresults;

    CallInfo() {
    }

    void init(LClosure lClosure, int n, int n2, int n3, int n4) {
        this.closure = lClosure;
        this.base = n;
        this.top = n2;
        this.resultbase = n3;
        this.nresults = n4;
        this.pc = 0;
    }

    public boolean isLua() {
        return true;
    }

    public int currentline() {
        int[] nArray = this.closure.p.lineinfo;
        int n = this.currentpc();
        if (nArray != null && n < nArray.length) {
            return nArray[n];
        }
        return -1;
    }

    public LFunction currentfunc(LuaState luaState) {
        LValue lValue;
        int n = this.currentfunca(luaState);
        if (n >= 0 && (lValue = luaState.stack[this.base + n]).isFunction()) {
            return (LFunction)lValue;
        }
        return null;
    }

    public int currentfunca(LuaState luaState) {
        int n = this.closure.p.code[this.currentpc()];
        int n2 = Lua.GET_OPCODE(n);
        if (n2 == 28 || n2 == 29) {
            return Lua.GETARG_A(n);
        }
        return -1;
    }

    public int currentpc() {
        return this.pc > 0 ? this.pc - 1 : 0;
    }
}

