/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.luaj.vm.LDouble;
import org.luaj.vm.LInteger;
import org.luaj.vm.LNil;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.Lua;
import org.luaj.vm.LuaState;

public class LString
extends LValue {
    public byte[] m_bytes;
    public int m_offset;
    public final int m_length;
    public final int m_hash;
    private static LTable s_stringMT;
    public static final LString[] LTYPENAMES;
    static /* synthetic */ Class class$org$luaj$vm$LString;

    public LString(String string) {
        int n = LString.lengthAsUtf8(string);
        byte[] byArray = new byte[n];
        LString.encodeToUtf8(string, byArray, 0);
        this.m_bytes = byArray;
        this.m_offset = 0;
        this.m_length = n;
        this.m_hash = LString.hashBytes(byArray, 0, n);
    }

    public String toJavaString() {
        char[] cArray = new char[this.m_length];
        int n = 0;
        int n2 = this.m_offset;
        int n3 = this.m_offset + this.m_length;
        while (n2 < n3) {
            int n4;
            if ((n4 = this.m_bytes[n2++]) == 0) {
                return new String(cArray, 0, n);
            }
            cArray[n++] = (char)(n4 >= 0 || n2 >= n3 ? n4 : (n4 < -32 || n2 + 1 >= n3 ? (n4 & 0x3F) << 6 | this.m_bytes[n2++] & 0x3F : (n4 & 0xF) << 12 | (this.m_bytes[n2++] & 0x3F) << 6 | this.m_bytes[n2++] & 0x3F));
        }
        return new String(cArray, 0, n);
    }

    public LString(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public LString(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.m_bytes = byArray;
        this.m_offset = n;
        this.m_length = n2;
        this.m_hash = LString.hashBytes(byArray, n, n2);
    }

    public static LString newStringCopy(LString lString) {
        return LString.newStringCopy(lString.m_bytes, lString.m_offset, lString.m_length);
    }

    public static LString newStringCopy(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return new LString(byArray2, 0, n2);
    }

    public static LString newStringNoCopy(byte[] byArray, int n, int n2) {
        return new LString(byArray, n, n2);
    }

    public static int lengthAsUtf8(String string) {
        int n;
        int n2 = n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') continue;
            ++n2;
            if (c < '\u0800') continue;
            ++n2;
        }
        return n2;
    }

    public static void encodeToUtf8(String string, byte[] byArray, int n) {
        int n2 = string.length();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
            byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | c & 0x3F);
        }
    }

    public boolean isString() {
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof LString) {
            LString lString = (LString)object;
            if (this.m_hash == lString.m_hash && this.m_length == lString.m_length) {
                if (this.m_bytes == lString.m_bytes && this.m_offset == lString.m_offset) {
                    return true;
                }
                if (LString.equals(this.m_bytes, this.m_offset, lString.m_bytes, lString.m_offset, this.m_length)) {
                    if (this.m_bytes.length < lString.m_bytes.length) {
                        lString.m_bytes = this.m_bytes;
                        lString.m_offset = this.m_offset;
                    } else {
                        this.m_bytes = lString.m_bytes;
                        this.m_offset = lString.m_offset;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int compareTo(LString lString) {
        int n;
        byte[] byArray = this.m_bytes;
        byte[] byArray2 = lString.m_bytes;
        int n2 = this.m_offset;
        int n3 = n2 + this.m_length;
        int n4 = n + lString.m_length;
        if (byArray == byArray2 && n2 == n && n3 == n4) {
            return 0;
        }
        for (n = lString.m_offset; n2 < n3 && n < n4; ++n2, ++n) {
            if (byArray[n2] == byArray2[n]) continue;
            return (byArray[n2] & 0xFF) - (byArray2[n] & 0xFF);
        }
        return this.m_length - lString.m_length;
    }

    public int hashCode() {
        return this.m_hash;
    }

    public int length() {
        return this.m_length;
    }

    public LString substring(int n, int n2) {
        return new LString(this.m_bytes, this.m_offset + n, n2 - n);
    }

    public int charAt(int n) {
        if (n < 0 || n >= this.m_length) {
            throw new IndexOutOfBoundsException();
        }
        return this.luaByte(n);
    }

    public int indexOfAny(LString lString) {
        int n = this.m_offset + this.m_length;
        int n2 = lString.m_offset + lString.m_length;
        for (int i = this.m_offset; i < n; ++i) {
            for (int j = lString.m_offset; j < n2; ++j) {
                if (this.m_bytes[i] != lString.m_bytes[j]) continue;
                return i - this.m_offset;
            }
        }
        return -1;
    }

    public int indexOf(byte by, int n) {
        for (int i = this.m_offset + n; i < this.m_length; ++i) {
            if (this.m_bytes[i] != by) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(LString lString, int n) {
        int n2 = lString.length();
        int n3 = this.m_offset + this.m_length - n2;
        for (int i = this.m_offset + n; i <= n3; ++i) {
            if (!LString.equals(this.m_bytes, i, lString.m_bytes, lString.m_offset, n2)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(LString lString) {
        int n;
        int n2 = lString.length();
        for (int i = n = this.m_offset + this.m_length - n2; i >= this.m_offset; --i) {
            if (!LString.equals(this.m_bytes, i, lString.m_bytes, lString.m_offset, n2)) continue;
            return i;
        }
        return -1;
    }

    public static LString valueOf(double d) {
        return new LString(String.valueOf(d));
    }

    public static LString valueOf(int n) {
        return new LString(String.valueOf(n));
    }

    public static LString valueOf(String string) {
        return new LString(string);
    }

    public void write(OutputStream outputStream, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n + n2 > this.m_length) {
            throw new IndexOutOfBoundsException();
        }
        outputStream.write(this.m_bytes, this.m_offset + n, n2);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, 0, this.m_length);
    }

    public void copyInto(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.m_bytes, this.m_offset + n, byArray, n2, n3);
    }

    public ByteArrayInputStream toInputStream() {
        return new ByteArrayInputStream(this.m_bytes, this.m_offset, this.m_length){

            public synchronized void reset() {
                this.pos = Math.max(LString.this.m_offset, this.mark);
            }
        };
    }

    public boolean luaBinCmpUnknown(int n, LValue lValue) {
        return lValue.luaBinCmpString(n, this);
    }

    public boolean luaBinCmpString(int n, LString lString) {
        switch (n) {
            case 23: {
                return this.equals(lString);
            }
            case 24: {
                return this.compareTo(lString) < 0;
            }
            case 25: {
                return this.compareTo(lString) <= 0;
            }
        }
        LuaState.vmerror("bad cmp opcode");
        return false;
    }

    public LValue luaBinOpDouble(int n, double d) {
        return this.luaToNumber().luaBinOpDouble(n, d);
    }

    public LValue luaBinOpInteger(int n, int n2) {
        return this.luaToNumber().luaBinOpInteger(n, n2);
    }

    public LValue luaBinOpUnknown(int n, LValue lValue) {
        return this.luaToNumber().luaBinOpUnknown(n, lValue);
    }

    public LValue luaUnaryMinus() {
        return this.luaToNumber().luaUnaryMinus();
    }

    public LValue luaToNumber() {
        return this.luaToNumber(10);
    }

    public LValue luaToNumber(int n) {
        block7: {
            if (n >= 2 && n <= 36) {
                String string = this.toJavaString().trim();
                if ((n == 10 || n == 16) && (string.startsWith("0x") || string.startsWith("0X"))) {
                    n = 16;
                    string = string.substring(2);
                }
                try {
                    long l = Long.parseLong(string, n);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        return new LDouble(l);
                    }
                    return LInteger.valueOf((int)l);
                }
                catch (NumberFormatException numberFormatException) {
                    if (n != 10) break block7;
                    try {
                        return LDouble.numberOf(Double.parseDouble(string));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
            }
        }
        return LNil.NIL;
    }

    public LString luaAsString() {
        return this;
    }

    public int luaLength() {
        return this.m_length;
    }

    public int luaGetType() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LTable luaGetMetatable() {
        Class clazz = class$org$luaj$vm$LString == null ? (class$org$luaj$vm$LString = LString.class$("org.luaj.vm.LString")) : class$org$luaj$vm$LString;
        synchronized (clazz) {
            return s_stringMT;
        }
    }

    public static synchronized LTable getMetatable() {
        if (s_stringMT == null) {
            s_stringMT = new LTable();
            s_stringMT.put(LValue.TM_INDEX, (LValue)s_stringMT);
        }
        return s_stringMT;
    }

    public static boolean equals(LString lString, int n, LString lString2, int n2, int n3) {
        return LString.equals(lString.m_bytes, lString.m_offset + n, lString2.m_bytes, lString2.m_offset + n2, n3);
    }

    public static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray.length < n + n3 || byArray2.length < n2 + n3) {
            return false;
        }
        while (--n3 >= 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    private static int hashBytes(byte[] byArray, int n, int n2) {
        int n3 = n2;
        int n4 = (n2 >> 5) + 1;
        for (int i = n2; i >= n4; i -= n4) {
            n3 ^= (n3 << 5) + (n3 >> 2) + (byArray[n + i - 1] & 0xFF);
        }
        return n3;
    }

    public int luaByte(int n) {
        return this.m_bytes[this.m_offset + n] & 0xFF;
    }

    public void luaConcatTo(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(this.m_bytes, this.m_offset, this.m_length);
    }

    public boolean isNumber() {
        return !this.luaToNumber().isNil();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n = Lua.TYPE_NAMES.length;
        LTYPENAMES = new LString[n];
        for (int i = 0; i < n; ++i) {
            LString.LTYPENAMES[i] = new LString(Lua.TYPE_NAMES[i]);
        }
    }
}

