/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import java.util.Vector;
import org.luaj.vm.LFunction;
import org.luaj.vm.LInteger;
import org.luaj.vm.LNil;
import org.luaj.vm.LString;
import org.luaj.vm.LValue;
import org.luaj.vm.LWeakTable;
import org.luaj.vm.LuaErrorException;
import org.luaj.vm.LuaState;

public class LTable
extends LValue {
    protected Object[] array;
    protected LValue[] hashKeys;
    protected Object[] hashValues;
    private int hashEntries;
    private LTable m_metatable;
    private static final int MIN_HASH_CAPACITY = 2;
    private static final LValue[] NONE = new LValue[0];
    private static final int MAX_KEY = 0x3FFFFFFF;

    public LTable() {
        this.array = NONE;
        this.hashKeys = NONE;
    }

    public LTable(int n, int n2) {
        if (n2 > 0 && n2 < 2) {
            n2 = 2;
        }
        this.array = new Object[n];
        this.hashKeys = new LValue[n2];
        this.hashValues = new Object[n2];
    }

    public boolean isTable() {
        return true;
    }

    public int getArrayCapacity() {
        return this.array.length;
    }

    public int getHashCapacity() {
        return this.hashKeys.length;
    }

    public int size() {
        int n = 0;
        int n2 = this.array.length;
        while (--n2 >= 0) {
            if (this.array[n2] == null) continue;
            ++n;
        }
        n2 = this.hashKeys.length;
        while (--n2 >= 0) {
            if (this.hashKeys[n2] == null) continue;
            ++n;
        }
        return n;
    }

    public void put(LValue lValue, LValue lValue2) {
        if (lValue.isInteger()) {
            int n = lValue.toJavaInt() - 1;
            int n2 = this.array.length;
            if (n >= 0 && n <= n2) {
                if (n == n2) {
                    this.expandArrayPart();
                }
                this.array[n] = this.normalizePut(lValue2);
                return;
            }
        }
        this.hashSet(lValue, this.normalizePut(lValue2));
    }

    public void put(int n, LValue lValue) {
        int n2 = n - 1;
        int n3 = this.array.length;
        if (n2 >= 0 && n2 <= n3) {
            if (n2 == n3) {
                this.expandArrayPart();
            }
            this.array[n2] = this.normalizePut(lValue);
        } else {
            this.hashSet(LInteger.valueOf(n), this.normalizePut(lValue));
        }
    }

    public void put(String string, LValue lValue) {
        this.hashSet(LString.valueOf(string), this.normalizePut(lValue));
    }

    public void put(String string, int n) {
        this.hashSet(LString.valueOf(string), LInteger.valueOf(n));
    }

    private void expandArrayPart() {
        int n = this.array.length;
        int n2 = Math.max(2, n * 2);
        this.arrayExpand(n2);
        for (int i = n; i < n2; ++i) {
            LInteger lInteger = LInteger.valueOf(i + 1);
            Object object = this.hashGet(lInteger);
            if (object == null) continue;
            this.hashSet(lInteger, null);
            this.array[i] = object;
        }
    }

    protected Object normalizePut(LValue lValue) {
        return lValue == LNil.NIL ? null : lValue;
    }

    public LValue get(LValue lValue) {
        int n;
        if (lValue.isInteger() && (n = lValue.toJavaInt()) > 0 && n <= this.array.length) {
            return this.normalizeGet(this.array[n - 1]);
        }
        return this.normalizeGet(this.hashGet(lValue));
    }

    public LValue get(int n) {
        return this.normalizeGet(n > 0 && n <= this.array.length ? this.array[n - 1] : this.hashGet(LInteger.valueOf(n)));
    }

    protected LValue normalizeGet(Object object) {
        return object == null ? LNil.NIL : (LValue)object;
    }

    public boolean containsKey(LValue lValue) {
        int n;
        if (lValue.isInteger() && (n = lValue.toJavaInt()) > 0 && n <= this.array.length) {
            return null != this.array[n - 1];
        }
        return null != this.hashGet(lValue);
    }

    public boolean containsKey(int n) {
        return n > 0 && n <= this.array.length ? this.array[n - 1] != null : this.hashKeys.length > 0 && this.hashKeys[this.hashFindSlot(LInteger.valueOf(n))] != null;
    }

    public int luaLength() {
        int n = 0;
        int n2 = this.array.length;
        if (n2 <= 0 || this.containsKey(n2)) {
            if (this.hashKeys.length == 0) {
                return n2;
            }
            ++n2;
            while (this.containsKey(n2) && n2 < 0x3FFFFFFF) {
                n = n2;
                n2 *= 2;
            }
        }
        while (n2 - n > 1) {
            int n3 = (n + n2) / 2;
            if (!this.containsKey(n3)) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        return n;
    }

    public LTable luaGetMetatable() {
        return this.m_metatable;
    }

    public LTable luaSetMetatable(LValue lValue) {
        if (this.m_metatable != null && this.m_metatable.containsKey(LValue.TM_METATABLE)) {
            throw new LuaErrorException("cannot change a protected metatable");
        }
        if (lValue == null || lValue.isNil()) {
            this.m_metatable = null;
        } else if (lValue.luaGetType() == 5) {
            LTable lTable = (LTable)lValue;
            LValue lValue2 = lTable.get(LValue.TM_MODE);
            if (lValue2.isString() && lValue2.toJavaString().indexOf(118) >= 0) {
                LWeakTable lWeakTable = new LWeakTable(this);
                lWeakTable.m_metatable = lTable;
                return lWeakTable;
            }
            this.m_metatable = lTable;
        } else {
            throw new LuaErrorException("not a table: " + lValue.luaGetTypeName());
        }
        return this;
    }

    public String toJavaString() {
        return "table: " + this.id();
    }

    public int luaGetType() {
        return 5;
    }

    public LValue[] getKeys() {
        int n;
        int n2 = this.array.length;
        int n3 = this.hashKeys.length;
        Vector<LValue> vector = new Vector<LValue>();
        for (n = 0; n < n2; ++n) {
            if (this.array[n] == null) continue;
            vector.addElement(LInteger.valueOf(n + 1));
        }
        for (n = 0; n < n3; ++n) {
            LValue lValue = this.hashKeys[n];
            if (null == lValue) continue;
            vector.addElement(lValue);
        }
        Object[] objectArray = new LValue[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void luaInsertPos(int n, LValue lValue) {
        LValue lValue2;
        if (n == 0) {
            n = this.luaLength() + 1;
        }
        do {
            lValue2 = this.get(n);
            this.put(n++, lValue);
        } while (!(lValue = lValue2).isNil());
    }

    public LValue luaRemovePos(int n) {
        LValue lValue;
        int n2 = this.luaLength();
        if (n == 0) {
            n = n2;
        }
        if (n <= 0 || n > n2) {
            return LNil.NIL;
        }
        LValue lValue2 = this.get(n);
        do {
            lValue = this.get(n + 1);
            this.put(n, lValue);
            ++n;
        } while (!lValue.isNil());
        return lValue2;
    }

    public LValue luaMaxN() {
        int n = this.array.length;
        int n2 = this.hashKeys.length;
        int n3 = Integer.MIN_VALUE;
        int n4 = n;
        while (--n4 >= 0) {
            if (this.array[n4] == null) continue;
            n3 = n4 + 1;
            break;
        }
        for (n4 = 0; n4 < n2; ++n4) {
            int n5;
            LValue lValue = this.hashKeys[n4];
            if (lValue == null || !lValue.isInteger() || (n5 = lValue.toJavaInt()) <= n3) continue;
            n3 = n5;
        }
        return LInteger.valueOf(n3 == Integer.MIN_VALUE ? 0 : n3);
    }

    public void luaSort(LuaState luaState, LValue lValue) {
        this.heapSort(this.luaLength(), luaState, lValue);
    }

    private void heapSort(int n, LuaState luaState, LValue lValue) {
        this.heapify(n, luaState, lValue);
        int n2 = n - 1;
        while (n2 > 0) {
            this.swap(n2, 0);
            this.siftDown(0, --n2, luaState, lValue);
        }
    }

    private void heapify(int n, LuaState luaState, LValue lValue) {
        for (int i = n / 2 - 1; i >= 0; --i) {
            this.siftDown(i, n - 1, luaState, lValue);
        }
    }

    private void siftDown(int n, int n2, LuaState luaState, LValue lValue) {
        int n3 = n;
        while (n3 * 2 + 1 <= n2) {
            int n4 = n3 * 2 + 1;
            if (n4 < n2 && this.compare(n4, n4 + 1, luaState, lValue)) {
                ++n4;
            }
            if (this.compare(n3, n4, luaState, lValue)) {
                this.swap(n3, n4);
                n3 = n4;
                continue;
            }
            return;
        }
    }

    private boolean compare(int n, int n2, LuaState luaState, LValue lValue) {
        LValue lValue2 = this.get(n + 1);
        LValue lValue3 = this.get(n2 + 1);
        if (lValue2.isNil() || lValue3.isNil()) {
            return false;
        }
        if (!lValue.isNil()) {
            luaState.pushlvalue(lValue);
            luaState.pushlvalue(lValue2);
            luaState.pushlvalue(lValue3);
            luaState.call(2, 1);
            boolean bl = luaState.toboolean(-1);
            luaState.resettop();
            return bl;
        }
        return lValue3.luaBinCmpUnknown(24, lValue2);
    }

    private void swap(int n, int n2) {
        LValue lValue = this.get(n + 1);
        this.put(n + 1, this.get(n2 + 1));
        this.put(n2 + 1, lValue);
    }

    public boolean next(LuaState luaState, LValue lValue, boolean bl) {
        Object object;
        int n = this.array.length;
        int n2 = bl ? -1 : this.hashKeys.length;
        int n3 = this.findindex(lValue, n, n2);
        if (n3 < 0) {
            luaState.error("invalid key to 'next'");
        }
        while (n3 < n) {
            object = this.array[n3];
            if (object != null) {
                luaState.pushinteger(n3 + 1);
                luaState.pushlvalue(this.normalizeGet(object));
                return true;
            }
            if (bl) {
                luaState.pushnil();
                return false;
            }
            ++n3;
        }
        if (!bl) {
            n3 -= n;
            while (n3 < n2) {
                object = this.hashValues[n3];
                if (object != null) {
                    LValue lValue2 = this.hashKeys[n3];
                    luaState.pushlvalue(lValue2);
                    luaState.pushlvalue(this.normalizeGet(object));
                    return true;
                }
                ++n3;
            }
        }
        luaState.pushnil();
        return false;
    }

    private int findindex(LValue lValue, int n, int n2) {
        int n3;
        if (lValue.isNil()) {
            return 0;
        }
        if (lValue.isInteger() && 0 < (n3 = lValue.toJavaInt()) && n3 <= n) {
            if (this.array[n3 - 1] == null) {
                return -1;
            }
            return n3;
        }
        if (n2 < 0) {
            return n;
        }
        if (n2 == 0) {
            return -1;
        }
        n3 = this.hashFindSlot(lValue);
        if (this.hashKeys[n3] == null) {
            return -1;
        }
        return n + n3 + 1;
    }

    public LValue foreach(LuaState luaState, LFunction lFunction, boolean bl) {
        LValue lValue = LNil.NIL;
        do {
            luaState.resettop();
            luaState.pushlvalue(lFunction);
            if (!this.next(luaState, lValue, bl)) {
                return LNil.NIL;
            }
            lValue = luaState.topointer(2);
            luaState.call(2, 1);
        } while (luaState.isnil(-1));
        return luaState.poplvalue();
    }

    public void arrayExpand(int n) {
        Object[] objectArray = new Object[n];
        System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
        this.array = objectArray;
    }

    public void arrayPresize(int n) {
        if (this.array.length < n) {
            this.arrayExpand(n);
        }
    }

    public void hashSet(LValue lValue, Object object) {
        if (object == null) {
            this.hashRemove(lValue);
        } else {
            int n;
            if (this.checkLoadFactor()) {
                this.rehash();
            }
            if (this.hashFillSlot(n = this.hashFindSlot(lValue), object)) {
                return;
            }
            this.hashKeys[n] = lValue;
            this.hashValues[n] = object;
        }
    }

    public Object hashGet(LValue lValue) {
        if (this.hashKeys.length <= 0) {
            return null;
        }
        return this.hashValues[this.hashFindSlot(lValue)];
    }

    public int hashFindSlot(LValue lValue) {
        LValue lValue2;
        int n = (lValue.hashCode() & Integer.MAX_VALUE) % this.hashKeys.length;
        while ((lValue2 = this.hashKeys[n]) != null && !lValue2.luaBinCmpUnknown(23, lValue)) {
            n = (n + 1) % this.hashKeys.length;
        }
        return n;
    }

    private boolean hashFillSlot(int n, Object object) {
        this.hashValues[n] = object;
        if (this.hashKeys[n] != null) {
            return true;
        }
        ++this.hashEntries;
        return false;
    }

    protected void hashRemove(LValue lValue) {
        if (this.hashKeys.length > 0) {
            int n = this.hashFindSlot(lValue);
            this.hashClearSlot(n);
        }
    }

    protected void hashClearSlot(int n) {
        if (this.hashKeys[n] != null) {
            int n2 = n;
            int n3 = this.hashKeys.length;
            while (this.hashKeys[n2 = (n2 + 1) % n3] != null) {
                int n4 = (this.hashKeys[n2].hashCode() & Integer.MAX_VALUE) % n3;
                if ((n2 <= n || n4 > n && n4 <= n2) && (n2 >= n || n4 > n || n4 <= n2)) continue;
                this.hashKeys[n] = this.hashKeys[n2];
                this.hashValues[n] = this.hashValues[n2];
                n = n2;
            }
            --this.hashEntries;
            this.hashKeys[n] = null;
            this.hashValues[n] = null;
            if (this.hashEntries == 0) {
                this.hashKeys = NONE;
                this.hashValues = null;
            }
        }
    }

    protected boolean checkLoadFactor() {
        int n = this.hashKeys.length;
        return n >> 1 >= n - this.hashEntries;
    }

    protected void rehash() {
        int n = this.hashKeys.length;
        int n2 = n > 0 ? 2 * n : 2;
        LValue[] lValueArray = this.hashKeys;
        Object[] objectArray = this.hashValues;
        this.hashKeys = new LValue[n2];
        this.hashValues = new Object[n2];
        for (int i = 0; i < n; ++i) {
            LValue lValue = lValueArray[i];
            if (lValue == null) continue;
            Object object = objectArray[i];
            int n3 = this.hashFindSlot(lValue);
            this.hashKeys[n3] = lValue;
            this.hashValues[n3] = object;
        }
    }
}

