/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm;

import org.luaj.vm.LFunction;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;

public class LThread
extends LValue
implements Runnable {
    private static final boolean USE_JAVA_THREADS = true;
    private static final int STATUS_SUSPENDED = 0;
    private static final int STATUS_RUNNING = 1;
    private static final int STATUS_NORMAL = 2;
    private static final int STATUS_DEAD = 3;
    private static final String[] NAMES = new String[]{"suspended", "running", "normal", "dead"};
    private int status = 0;
    public final LuaState vm;
    private Thread thread;
    static LThread running;

    public LThread(LFunction lFunction, LTable lTable) {
        this.vm = new LuaState(lTable);
        this.vm.pushlvalue(lFunction);
    }

    public int luaGetType() {
        return 8;
    }

    public String toJavaString() {
        return "thread: " + this.hashCode();
    }

    public boolean luaSetEnv(LTable lTable) {
        this.vm._G = lTable;
        return true;
    }

    public String getStatus() {
        return NAMES[this.status];
    }

    public static LThread getRunning() {
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LThread lThread = this;
        synchronized (lThread) {
            try {
                this.vm.execute();
            }
            finally {
                this.status = 3;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void yield() {
        LThread lThread = this;
        synchronized (lThread) {
            if (this.status != 1) {
                this.vm.error(this + " not running");
            }
            this.status = 0;
            this.notify();
            try {
                this.wait();
                this.status = 1;
            }
            catch (InterruptedException interruptedException) {
                this.status = 3;
                this.vm.error(this + " " + interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeFrom(LuaState luaState, int n) {
        LThread lThread = this;
        synchronized (lThread) {
            if (this.status == 3) {
                luaState.resettop();
                luaState.pushboolean(false);
                luaState.pushstring("cannot resume dead coroutine");
                return;
            }
            LThread lThread2 = running;
            try {
                if (lThread2 != null) {
                    lThread2.status = 2;
                }
                running = this;
                this.status = 1;
                if (this.vm.cc < 0) {
                    luaState.xmove(this.vm, n);
                    this.vm.prepStackCall();
                } else {
                    this.vm.resettop();
                    luaState.xmove(this.vm, n);
                }
                if (this.thread == null) {
                    this.thread = new Thread(this);
                    this.thread.start();
                }
                this.notify();
                this.wait();
                luaState.resettop();
                if (this.vm.cc >= 0) {
                    luaState.pushboolean(this.status != 3);
                    this.vm.xmove(luaState, this.vm.gettop());
                } else {
                    luaState.pushboolean(true);
                    this.vm.base = 0;
                    this.vm.xmove(luaState, this.vm.gettop());
                }
            }
            catch (Throwable throwable) {
                this.status = 3;
                luaState.resettop();
                luaState.pushboolean(false);
                luaState.pushstring("thread: " + throwable);
                this.notify();
            }
            finally {
                running = lThread2;
            }
        }
    }
}

