/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.luaj.compiler.LuaC;
import org.luaj.lib.DebugLib;
import org.luaj.platform.J2sePlatform;
import org.luaj.vm.LFunction;
import org.luaj.vm.LString;
import org.luaj.vm.LTable;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;
import org.luaj.vm.Platform;

public class lua {
    private static final String version = "Luaj 1.0.3 Copyright (C) 2009 luaj.org";
    private static final String usage = "usage: java -cp luaj-j2se.jar lua [options] [script [args]].\nAvailable options are:\n  -e stat  execute string 'stat'\n  -l name  require library 'name'\n  -i       enter interactive mode after executing 'script'\n  -v       show version information\n  --       stop handling options\n  -        execute stdin and stop handling options";

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws IOException {
        Platform.setInstance(new J2sePlatform());
        LuaC.install();
        LuaState luaState = Platform.newLuaState();
        DebugLib.install(luaState);
        boolean bl = stringArray.length == 0;
        boolean bl2 = false;
        boolean bl3 = true;
        try {
            int n;
            block14: for (n = 0; n < stringArray.length && bl3 && stringArray[n].startsWith("-") && stringArray[n].length() > 1; ++n) {
                switch (stringArray[n].charAt(1)) {
                    case 'e': {
                        if (++n < stringArray.length) continue block14;
                        lua.usageExit();
                        continue block14;
                    }
                    case 'l': {
                        if (++n >= stringArray.length) {
                            lua.usageExit();
                        }
                        lua.loadLibrary(luaState, stringArray[n]);
                        continue block14;
                    }
                    case 'i': {
                        bl = true;
                        continue block14;
                    }
                    case 'v': {
                        bl2 = true;
                        continue block14;
                    }
                    case '-': {
                        if (stringArray[n].length() > 2) {
                            lua.usageExit();
                        }
                        bl3 = false;
                        continue block14;
                    }
                    default: {
                        lua.usageExit();
                    }
                }
            }
            if (bl2) {
                System.out.println(version);
            }
            bl3 = true;
            block15: for (n = 0; n < stringArray.length; ++n) {
                if (!bl3 || !stringArray[n].startsWith("-")) {
                    LTable lTable = new LTable();
                    for (int i = 0; i < stringArray.length; ++i) {
                        lTable.put(i - n, (LValue)new LString(stringArray[i]));
                    }
                    lTable.put(-n - 1, (LValue)new LString("lua"));
                    lTable.put(-n - 2, (LValue)new LString("java"));
                    luaState._G.put("arg", (LValue)lTable);
                    lua.processScript(luaState, new FileInputStream(stringArray[n]), stringArray[n], stringArray, n);
                    break;
                }
                if (stringArray[n].length() <= 1) {
                    lua.processScript(luaState, System.in, "-", stringArray, n);
                    break;
                }
                switch (stringArray[n].charAt(1)) {
                    case 'l': {
                        ++n;
                        continue block15;
                    }
                    case 'e': {
                        lua.processScript(luaState, new ByteArrayInputStream(stringArray[++n].getBytes()), stringArray[n], stringArray, n);
                        continue block15;
                    }
                    case '-': {
                        bl3 = false;
                    }
                }
            }
            if (bl) {
                lua.interactiveMode(luaState);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            System.exit(-2);
        }
    }

    private static void loadLibrary(LuaState luaState, String string) throws IOException {
        try {
            luaState.getglobal("require");
            luaState.pushstring(string);
            int n = luaState.pcall(1, 0);
            if (n == 0) {
                return;
            }
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            LFunction lFunction = (LFunction)obj;
            luaState.call(lFunction);
        }
        catch (Exception exception) {
            throw new IOException("loadLibrary(" + string + ") failed: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processScript(LuaState luaState, InputStream inputStream, String string, String[] stringArray, int n) throws IOException {
        try {
            switch (luaState.load(inputStream, string)) {
                case 0: {
                    if (stringArray != null) {
                        for (int i = n; i < stringArray.length; ++i) {
                            luaState.pushstring(stringArray[i]);
                        }
                    }
                    luaState.call(stringArray.length - n, 0);
                    return;
                }
                case 4: {
                    System.out.println("out of memory during chunk load");
                    return;
                }
                case 3: {
                    System.out.println("syntax error: " + luaState.tostring(-1));
                    return;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            return;
        }
        finally {
            inputStream.close();
        }
    }

    private static void interactiveMode(LuaState luaState) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("> ");
            System.out.flush();
            String string = bufferedReader.readLine();
            if (string == null) {
                return;
            }
            lua.processScript(luaState, new ByteArrayInputStream(string.getBytes()), "-", null, 0);
        }
    }
}

