/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.lib;

import org.luaj.lib.PackageLib;
import org.luaj.vm.LFunction;
import org.luaj.vm.LTable;
import org.luaj.vm.LThread;
import org.luaj.vm.LValue;
import org.luaj.vm.LuaState;

public class CoroutineLib
extends LFunction {
    private static final String[] NAMES = new String[]{"install", "create", "resume", "running", "status", "wrap", "yield", "wrapped"};
    private static final int INSTALL = 0;
    private static final int CREATE = 1;
    private static final int RESUME = 2;
    private static final int RUNNING = 3;
    private static final int STATUS = 4;
    private static final int WRAP = 5;
    private static final int YIELD = 6;
    private static final int WRAPPED = 7;
    private final int id;
    private final LThread thread;

    public static void install(LTable lTable) {
        LTable lTable2 = new LTable(0, 6);
        for (int i = 1; i <= 6; ++i) {
            lTable2.put(NAMES[i], (LValue)new CoroutineLib(i));
        }
        lTable.put("coroutine", (LValue)lTable2);
        PackageLib.setIsLoaded("coroutine", lTable2);
    }

    public CoroutineLib() {
        this.id = 0;
        this.thread = null;
    }

    private CoroutineLib(int n) {
        this.id = n;
        this.thread = null;
    }

    public String toString() {
        return NAMES[this.id] + "()";
    }

    private CoroutineLib(int n, LThread lThread) {
        this.id = n;
        this.thread = lThread;
    }

    public int invoke(LuaState luaState) {
        switch (this.id) {
            case 0: {
                CoroutineLib.install(luaState._G);
                return 0;
            }
            case 1: {
                LFunction lFunction = luaState.checkfunction(1);
                luaState.pushlvalue(new LThread(lFunction, lFunction.luaGetEnv(luaState._G)));
                return 1;
            }
            case 2: {
                LThread lThread = luaState.checkthread(1);
                lThread.resumeFrom(luaState, luaState.gettop() - 1);
                return -1;
            }
            case 3: {
                LThread lThread = LThread.getRunning();
                if (lThread != null) {
                    luaState.pushlvalue(lThread);
                } else {
                    luaState.pushnil();
                }
                return 1;
            }
            case 4: {
                luaState.pushstring(luaState.checkthread(1).getStatus());
                return 1;
            }
            case 5: {
                LFunction lFunction = luaState.checkfunction(1);
                luaState.pushlvalue(new CoroutineLib(7, new LThread(lFunction, lFunction.luaGetEnv(luaState._G))));
                return 1;
            }
            case 6: {
                LThread lThread = LThread.getRunning();
                if (lThread == null) {
                    luaState.error("main thread can't yield");
                    return 0;
                }
                lThread.yield();
                return -1;
            }
            case 7: {
                LThread lThread = this.thread;
                lThread.resumeFrom(luaState, luaState.gettop());
                if (luaState.toboolean(1)) {
                    luaState.remove(1);
                    return -1;
                }
                luaState.error(luaState.tostring(2));
                return 0;
            }
        }
        LuaState.vmerror("bad coroutine id");
        return 0;
    }
}

